/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa.back;

import com.android.dx.rop.code.CstInsn;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.ssa.BasicRegisterMapper;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.RegisterMapper;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.ssa.back.InterferenceGraph;
import com.android.dx.ssa.back.RegisterAllocator;
import com.android.dx.util.BitIntSet;
import java.util.BitSet;

public class FirstFitAllocator
extends RegisterAllocator {
    private static final boolean PRESLOT_PARAMS = true;
    private final BitSet mapped;

    public FirstFitAllocator(SsaMethod ssaMeth, InterferenceGraph interference) {
        super(ssaMeth, interference);
        this.mapped = new BitSet(ssaMeth.getRegCount());
    }

    @Override
    public boolean wantsParamsMovedHigh() {
        return true;
    }

    @Override
    public RegisterMapper allocateRegisters() {
        int oldRegCount = this.ssaMeth.getRegCount();
        BasicRegisterMapper mapper = new BasicRegisterMapper(oldRegCount);
        int nextNewRegister = 0;
        nextNewRegister = this.ssaMeth.getParamWidth();
        for (int i2 = 0; i2 < oldRegCount; ++i2) {
            if (this.mapped.get(i2)) continue;
            int maxCategory = this.getCategoryForSsaReg(i2);
            BitIntSet current = new BitIntSet(oldRegCount);
            this.interference.mergeInterferenceSet(i2, current);
            boolean isPreslotted = false;
            int newReg = 0;
            if (this.isDefinitionMoveParam(i2)) {
                NormalSsaInsn defInsn = (NormalSsaInsn)this.ssaMeth.getDefinitionForRegister(i2);
                newReg = this.paramNumberFromMoveParam(defInsn);
                mapper.addMapping(i2, newReg, maxCategory);
                isPreslotted = true;
            } else {
                mapper.addMapping(i2, nextNewRegister, maxCategory);
                newReg = nextNewRegister;
            }
            for (int j2 = i2 + 1; j2 < oldRegCount; ++j2) {
                if (this.mapped.get(j2) || this.isDefinitionMoveParam(j2) || current.has(j2) || isPreslotted && maxCategory < this.getCategoryForSsaReg(j2)) continue;
                this.interference.mergeInterferenceSet(j2, current);
                maxCategory = Math.max(maxCategory, this.getCategoryForSsaReg(j2));
                mapper.addMapping(j2, newReg, maxCategory);
                this.mapped.set(j2);
            }
            this.mapped.set(i2);
            if (isPreslotted) continue;
            nextNewRegister += maxCategory;
        }
        return mapper;
    }

    private int paramNumberFromMoveParam(NormalSsaInsn ndefInsn) {
        CstInsn origInsn = (CstInsn)ndefInsn.getOriginalRopInsn();
        return ((CstInteger)origInsn.getConstant()).getValue();
    }
}

