/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.builder.model.ClassField;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;

public final class ClassFieldImpl
implements ClassField,
Serializable {
    private static final long serialVersionUID = 3645139904046297388L;
    private final String type;
    private final String name;
    private final String value;
    private final String documentation;
    private final ImmutableSet<String> annotations;

    public ClassFieldImpl(String type, String name, String value) {
        this(type, name, value, "", (ImmutableSet<String>)ImmutableSet.of());
    }

    public ClassFieldImpl(String type, String name, String value, String documentation, ImmutableSet<String> annotations) {
        if (type == null || name == null || value == null || documentation == null || annotations == null) {
            throw new NullPointerException("Build Config field cannot have a null parameter");
        }
        this.type = type;
        this.name = name;
        this.value = value;
        this.documentation = documentation;
        this.annotations = annotations;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ClassFieldImpl that = (ClassFieldImpl)o2;
        return this.type.equals(that.type) && this.name.equals(that.name) && this.value.equals(that.value) && this.documentation.equals(that.documentation) && this.annotations.equals(that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.value, this.documentation, this.annotations);
    }
}

