/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.packaging;

import com.android.builder.packaging.JarMerger;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class TypedefRemover
implements JarMerger.Transformer {
    private final boolean mQuiet;
    private final boolean mVerbose;
    private final boolean mDryRun;
    private Set<String> mAnnotationNames = Sets.newHashSet();
    private Set<String> mAnnotationClassFiles = Sets.newHashSet();
    private Set<String> mAnnotationOuterClassFiles = Sets.newHashSet();

    public TypedefRemover(boolean quiet, boolean verbose, boolean dryRun) {
        this.mQuiet = quiet;
        this.mVerbose = verbose;
        this.mDryRun = dryRun;
    }

    public TypedefRemover() {
        this(true, false, false);
    }

    private static void info(String message) {
        System.out.println(message);
    }

    static void warning(String message) {
        System.out.println("Warning: " + message);
    }

    private static void error(String message) {
        System.err.println("Error: " + message);
    }

    public TypedefRemover setTypedefFile(File file) {
        try {
            for (String line : Files.readLines((File)file, (Charset)Charsets.UTF_8)) {
                if (!line.startsWith("D ")) continue;
                String clz = line.substring(2).trim();
                this.addTypeDef(clz);
            }
        }
        catch (IOException e2) {
            TypedefRemover.error("Could not read " + file + ": " + e2.getLocalizedMessage());
        }
        return this;
    }

    @Override
    public InputStream filter(String path, InputStream input) {
        if (this.mAnnotationClassFiles.contains(path)) {
            return null;
        }
        if (!this.mAnnotationOuterClassFiles.contains(path)) {
            return input;
        }
        try {
            ClassReader reader = new ClassReader(input);
            byte[] rewritten = this.rewriteOuterClass(reader);
            return new ByteArrayInputStream(rewritten);
        }
        catch (IOException ioe) {
            TypedefRemover.error("Could not process " + path + ": " + ioe.getLocalizedMessage());
            return input;
        }
    }

    public void removeFromTypedefFile(File classDir, File file) {
        this.removeFromTypedefFile(Collections.singletonList(classDir), file);
    }

    public void removeFromTypedefFile(Collection<File> classDirs, File file) {
        this.setTypedefFile(file);
        this.remove(classDirs, Collections.emptyList());
    }

    public void remove(Collection<File> classDir, List<String> owners) {
        if (!this.mQuiet) {
            TypedefRemover.info("Deleting @IntDef and @StringDef annotation class files");
        }
        for (String owner : owners) {
            this.addTypeDef(owner);
        }
        this.rewriteOuterClasses(classDir);
        this.deleteAnnotationClasses(classDir);
    }

    private void addTypeDef(String owner) {
        String outer;
        this.mAnnotationClassFiles.add(owner + ".class");
        this.mAnnotationNames.add(owner);
        int index = owner.lastIndexOf(36);
        if (index != -1 && !this.mAnnotationOuterClassFiles.contains(outer = owner.substring(0, index) + ".class")) {
            this.mAnnotationOuterClassFiles.add(outer);
        }
    }

    private void rewriteOuterClasses(Collection<File> classDirs) {
        for (String relative : this.mAnnotationOuterClassFiles) {
            boolean found = false;
            for (File classDir : classDirs) {
                byte[] bytes;
                File file = new File(classDir, relative.replace('/', File.separatorChar));
                if (!file.isFile()) continue;
                found = true;
                try {
                    bytes = Files.toByteArray((File)file);
                }
                catch (IOException e2) {
                    TypedefRemover.error("Could not read " + file + ": " + e2.getLocalizedMessage());
                    continue;
                }
                ClassReader reader = new ClassReader(bytes);
                byte[] rewritten = this.rewriteOuterClass(reader);
                try {
                    Files.write((byte[])rewritten, (File)file);
                }
                catch (IOException e3) {
                    TypedefRemover.error("Could not write " + file + ": " + e3.getLocalizedMessage());
                }
            }
            if (found) continue;
            TypedefRemover.warning("Could not find outer class file for " + relative);
        }
    }

    private byte[] rewriteOuterClass(ClassReader reader) {
        ClassWriter classWriter = new ClassWriter(327680);
        ClassVisitor classVisitor = new ClassVisitor(327680, (ClassVisitor)classWriter){

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                if (!TypedefRemover.this.mAnnotationNames.contains(name)) {
                    super.visitInnerClass(name, outerName, innerName, access);
                }
            }
        };
        reader.accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    private void deleteAnnotationClasses(Collection<File> classDirs) {
        for (String relative : this.mAnnotationClassFiles) {
            boolean found = false;
            for (File classDir : classDirs) {
                boolean deleted;
                File file = new File(classDir, relative.replace('/', File.separatorChar));
                if (!file.isFile()) continue;
                found = true;
                if (this.mVerbose) {
                    if (this.mDryRun) {
                        TypedefRemover.info("Would delete " + file);
                    } else {
                        TypedefRemover.info("Deleting " + file);
                    }
                }
                if (this.mDryRun || (deleted = file.delete())) continue;
                TypedefRemover.warning("Could not delete " + file);
            }
            if (found) continue;
            TypedefRemover.warning("Could not find class file for typedef " + relative);
        }
    }
}

