/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.MutabilityControl;
import com.android.dx.util.ToHuman;
import java.util.Arrays;

public class FixedSizeList
extends MutabilityControl
implements ToHuman {
    private Object[] arr;

    public FixedSizeList(int size) {
        super(size != 0);
        try {
            this.arr = new Object[size];
        }
        catch (NegativeArraySizeException ex) {
            throw new IllegalArgumentException("size < 0");
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FixedSizeList list = (FixedSizeList)other;
        return Arrays.equals(this.arr, list.arr);
    }

    public int hashCode() {
        return Arrays.hashCode(this.arr);
    }

    public String toString() {
        String name = this.getClass().getName();
        return this.toString0(name.substring(name.lastIndexOf(46) + 1) + '{', ", ", "}", false);
    }

    @Override
    public String toHuman() {
        String name = this.getClass().getName();
        return this.toString0(name.substring(name.lastIndexOf(46) + 1) + '{', ", ", "}", true);
    }

    public String toString(String prefix, String separator, String suffix) {
        return this.toString0(prefix, separator, suffix, false);
    }

    public String toHuman(String prefix, String separator, String suffix) {
        return this.toString0(prefix, separator, suffix, true);
    }

    public final int size() {
        return this.arr.length;
    }

    public void shrinkToFit() {
        int sz = this.arr.length;
        int newSz = 0;
        for (int i2 = 0; i2 < sz; ++i2) {
            if (this.arr[i2] == null) continue;
            ++newSz;
        }
        if (sz == newSz) {
            return;
        }
        this.throwIfImmutable();
        Object[] newa = new Object[newSz];
        int at = 0;
        for (int i3 = 0; i3 < sz; ++i3) {
            Object one = this.arr[i3];
            if (one == null) continue;
            newa[at] = one;
            ++at;
        }
        this.arr = newa;
        if (newSz == 0) {
            this.setImmutable();
        }
    }

    protected final Object get0(int n2) {
        try {
            Object result = this.arr[n2];
            if (result == null) {
                throw new NullPointerException("unset: " + n2);
            }
            return result;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return this.throwIndex(n2);
        }
    }

    protected final Object getOrNull0(int n2) {
        return this.arr[n2];
    }

    protected final void set0(int n2, Object obj) {
        this.throwIfImmutable();
        try {
            this.arr[n2] = obj;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.throwIndex(n2);
        }
    }

    private Object throwIndex(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("n < 0");
        }
        throw new IndexOutOfBoundsException("n >= size()");
    }

    private String toString0(String prefix, String separator, String suffix, boolean human) {
        int len = this.arr.length;
        StringBuilder sb2 = new StringBuilder(len * 10 + 10);
        if (prefix != null) {
            sb2.append(prefix);
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 != 0 && separator != null) {
                sb2.append(separator);
            }
            if (human) {
                sb2.append(((ToHuman)this.arr[i2]).toHuman());
                continue;
            }
            sb2.append(this.arr[i2]);
        }
        if (suffix != null) {
            sb2.append(suffix);
        }
        return sb2.toString();
    }
}

