/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.BitIntSet;
import com.android.dx.util.Bits;
import com.android.dx.util.IntIterator;
import com.android.dx.util.IntList;
import com.android.dx.util.IntSet;
import java.util.NoSuchElementException;

public class ListIntSet
implements IntSet {
    final IntList ints = new IntList();

    public ListIntSet() {
        this.ints.sort();
    }

    @Override
    public void add(int value) {
        int index = this.ints.binarysearch(value);
        if (index < 0) {
            this.ints.insert(-(index + 1), value);
        }
    }

    @Override
    public void remove(int value) {
        int index = this.ints.indexOf(value);
        if (index >= 0) {
            this.ints.removeIndex(index);
        }
    }

    @Override
    public boolean has(int value) {
        return this.ints.indexOf(value) >= 0;
    }

    @Override
    public void merge(IntSet other) {
        if (other instanceof ListIntSet) {
            ListIntSet o3 = (ListIntSet)other;
            int szThis = this.ints.size();
            int szOther = o3.ints.size();
            int i3 = 0;
            int j3 = 0;
            while (j3 < szOther && i3 < szThis) {
                while (j3 < szOther && o3.ints.get(j3) < this.ints.get(i3)) {
                    this.add(o3.ints.get(j3++));
                }
                if (j3 == szOther) break;
                while (i3 < szThis && o3.ints.get(j3) >= this.ints.get(i3)) {
                    ++i3;
                }
            }
            while (j3 < szOther) {
                this.add(o3.ints.get(j3++));
            }
            this.ints.sort();
        } else if (other instanceof BitIntSet) {
            BitIntSet o4 = (BitIntSet)other;
            int i4 = 0;
            while (i4 >= 0) {
                this.ints.add(i4);
                i4 = Bits.findFirst(o4.bits, i4 + 1);
            }
            this.ints.sort();
        } else {
            IntIterator iter = other.iterator();
            while (iter.hasNext()) {
                this.add(iter.next());
            }
        }
    }

    @Override
    public int elements() {
        return this.ints.size();
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < ListIntSet.this.ints.size();
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ListIntSet.this.ints.get(this.idx++);
            }
        };
    }

    public String toString() {
        return this.ints.toString();
    }
}

