/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.Reporter;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;

public abstract class BaseCompilerCommand
extends BaseCommand {
    static final /* synthetic */ boolean l;
    private final CompilationMode e;
    private final ProgramConsumer f;
    private final StringConsumer g;
    private final int h;
    private final Reporter i;
    private final boolean j;
    private final boolean k;

    BaseCompilerCommand(boolean bl, boolean bl2) {
        super(bl, bl2);
        this.f = null;
        this.g = null;
        this.e = null;
        this.h = 0;
        this.i = new Reporter();
        this.j = true;
        this.k = false;
    }

    BaseCompilerCommand(AndroidApp androidApp, CompilationMode compilationMode, ProgramConsumer programConsumer2, StringConsumer stringConsumer, int n3, Reporter reporter, boolean bl, boolean bl2) {
        super(androidApp);
        if (!l && n3 <= 0) {
            throw new AssertionError();
        }
        if (!l && compilationMode == null) {
            throw new AssertionError();
        }
        this.e = compilationMode;
        this.f = programConsumer2;
        this.g = stringConsumer;
        this.h = n3;
        this.i = reporter;
        this.j = bl;
        this.k = bl2;
    }

    static {
        l = BaseCompilerCommand.class.desiredAssertionStatus() ^ true;
    }

    public CompilationMode getMode() {
        return this.e;
    }

    public int getMinApiLevel() {
        return this.h;
    }

    public ProgramConsumer getProgramConsumer() {
        return this.f;
    }

    public StringConsumer getMainDexListConsumer() {
        return this.g;
    }

    public boolean getEnableDesugaring() {
        return this.j;
    }

    public boolean isOptimizeMultidexForLinearAlloc() {
        return this.k;
    }

    Reporter a() {
        return this.i;
    }

    public static abstract class Builder<C extends BaseCompilerCommand, B extends Builder<C, B>>
    extends BaseCommand.Builder<C, B> {
        static final /* synthetic */ boolean n;
        private ProgramConsumer f;
        private StringConsumer g;
        private Path h;
        private OutputMode i;
        private CompilationMode j;
        private int k;
        private boolean l;
        private boolean m;

        Builder(DiagnosticsHandler diagnosticsHandler) {
            Builder builder = this;
            super(AndroidApp.a(new Reporter(diagnosticsHandler)));
            builder.f = null;
            builder.g = null;
            builder.h = null;
            builder.i = OutputMode.DexIndexed;
            builder.k = 0;
            builder.l = false;
            builder.m = false;
            builder.j = builder.e();
        }

        Builder(AndroidApp androidApp) {
            Builder builder = this;
            super(AndroidApp.builder(androidApp));
            builder.f = null;
            builder.g = null;
            builder.h = null;
            builder.i = OutputMode.DexIndexed;
            builder.k = 0;
            builder.l = false;
            builder.m = false;
            builder.j = builder.e();
        }

        Builder(AndroidApp androidApp, DiagnosticsHandler diagnosticsHandler) {
            Builder builder = this;
            super(AndroidApp.a(androidApp, new Reporter(diagnosticsHandler)));
            builder.f = null;
            builder.g = null;
            builder.h = null;
            builder.i = OutputMode.DexIndexed;
            builder.k = 0;
            builder.l = false;
            builder.m = false;
            builder.j = builder.e();
        }

        static {
            n = BaseCompilerCommand.class.desiredAssertionStatus() ^ true;
        }

        abstract CompilationMode e();

        public CompilationMode getMode() {
            return this.j;
        }

        public B setMode(CompilationMode compilationMode) {
            if (!n && compilationMode == null) {
                throw new AssertionError();
            }
            this.j = compilationMode;
            return (B)((Builder)this.c());
        }

        public Path getOutputPath() {
            return this.h;
        }

        public OutputMode getOutputMode() {
            return this.i;
        }

        public ProgramConsumer getProgramConsumer() {
            return this.f;
        }

        public StringConsumer getMainDexListConsumer() {
            return this.g;
        }

        public B setOptimizeMultidexForLinearAlloc(boolean bl) {
            this.m = bl;
            return (B)((Builder)this.c());
        }

        protected boolean g() {
            return this.m;
        }

        public B setProgramConsumer(ProgramConsumer programConsumer2) {
            Builder builder = this;
            builder.h = null;
            builder.i = null;
            this.f = programConsumer2;
            return (B)((Builder)this.c());
        }

        public B setMainDexListOutputPath(Path path) {
            this.g = new StringConsumer.FileConsumer(path);
            return (B)((Builder)this.c());
        }

        public B setMainDexListConsumer(StringConsumer stringConsumer) {
            this.g = stringConsumer;
            return (B)((Builder)this.c());
        }

        public B setOutput(Path path, OutputMode outputMode) {
            return this.setOutput(path, outputMode, false);
        }

        protected B setOutput(Path path, OutputMode outputMode, boolean bl) {
            if (!n && path == null) {
                throw new AssertionError();
            }
            if (!n && outputMode == null) {
                throw new AssertionError();
            }
            Builder builder = this;
            this.h = path;
            this.i = outputMode;
            builder.f = builder.a(path, outputMode, bl);
            return (B)((Builder)builder.c());
        }

        protected InternalProgramOutputPathConsumer a(Path path, OutputMode outputMode, boolean bl) {
            Object object;
            if (outputMode == OutputMode.DexIndexed) {
                if (FileUtils.isArchive(path)) {
                    DexIndexedConsumer.ArchiveConsumer archiveConsumer;
                    object = archiveConsumer;
                    archiveConsumer = new DexIndexedConsumer.ArchiveConsumer(path, bl);
                } else {
                    DexIndexedConsumer.DirectoryConsumer directoryConsumer;
                    object = directoryConsumer;
                    directoryConsumer = new DexIndexedConsumer.DirectoryConsumer(path, bl);
                }
                return object;
            }
            if (outputMode == OutputMode.DexFilePerClass) {
                if (FileUtils.isArchive(path)) {
                    return new DexFilePerClassFileConsumer.ArchiveConsumer((Builder)object, path, bl){

                        @Override
                        public boolean combineSyntheticClassesWithPrimaryClass() {
                            return false;
                        }
                    };
                }
                return new DexFilePerClassFileConsumer.DirectoryConsumer((Builder)object, path, bl){

                    @Override
                    public boolean combineSyntheticClassesWithPrimaryClass() {
                        return false;
                    }
                };
            }
            if (outputMode == OutputMode.DexFilePerClassFile) {
                if (FileUtils.isArchive(path)) {
                    DexFilePerClassFileConsumer.ArchiveConsumer archiveConsumer;
                    object = archiveConsumer;
                    archiveConsumer = new DexFilePerClassFileConsumer.ArchiveConsumer(path, bl);
                } else {
                    DexFilePerClassFileConsumer.DirectoryConsumer directoryConsumer;
                    object = directoryConsumer;
                    directoryConsumer = new DexFilePerClassFileConsumer.DirectoryConsumer(path, bl);
                }
                return object;
            }
            if (outputMode == OutputMode.ClassFile) {
                if (FileUtils.isArchive(path)) {
                    ClassFileConsumer.ArchiveConsumer archiveConsumer;
                    object = archiveConsumer;
                    archiveConsumer = new ClassFileConsumer.ArchiveConsumer(path, bl);
                } else {
                    ClassFileConsumer.DirectoryConsumer directoryConsumer;
                    object = directoryConsumer;
                    directoryConsumer = new ClassFileConsumer.DirectoryConsumer(path, bl);
                }
                return object;
            }
            throw new Unreachable("Unexpected output mode: " + (Object)((Object)outputMode));
        }

        public int getMinApiLevel() {
            return this.f() ? this.k : AndroidApiLevel.getDefault().getLevel();
        }

        boolean f() {
            return this.k != 0;
        }

        public B setMinApiLevel(int n3) {
            if (n3 <= 0) {
                this.a().a("Invalid minApiLevel: " + n3);
            } else {
                this.k = n3;
            }
            return (B)((Builder)this.c());
        }

        public B setEnableDesugaring(boolean bl) {
            this.l = bl ^ true;
            return (B)((Builder)this.c());
        }

        public B setDisableDesugaring(boolean bl) {
            this.l = bl;
            return (B)((Builder)this.c());
        }

        public boolean getDisableDesugaring() {
            return this.l;
        }

        @Override
        void d() {
            ArrayList<Class<ClassFileConsumer>> arrayList;
            Builder builder = this;
            Reporter reporter = builder.a();
            if (builder.j == null) {
                reporter.a("Expected valid compilation mode, was null");
            }
            Builder builder2 = this;
            FileUtils.a(builder2.h, reporter);
            if (builder2.getProgramConsumer() == null) {
                reporter.a("A ProgramConsumer or Output is required for compilation");
            }
            Serializable serializable = arrayList;
            arrayList = new ArrayList<Class<ClassFileConsumer>>(3);
            if (this.f instanceof DexIndexedConsumer) {
                serializable.add(DexIndexedConsumer.class);
            }
            if (this.f instanceof DexFilePerClassFileConsumer) {
                serializable.add(DexFilePerClassFileConsumer.class);
            }
            if (this.f instanceof ClassFileConsumer) {
                serializable.add(ClassFileConsumer.class);
            }
            if (serializable.size() > 1) {
                ArrayList<Class<ClassFileConsumer>> arrayList2 = serializable;
                serializable = new StringBuilder().append("Invalid program consumer.").append(" A program consumer can implement at most one consumer type but ").append(this.f.getClass().getName()).append(" implements types:");
                for (Class clazz : arrayList2) {
                    ((StringBuilder)serializable).append(" ").append(clazz.getName());
                }
                reporter.a(((StringBuilder)serializable).toString());
            }
            super.d();
        }
    }
}

