/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.e;
import com.android.tools.r8.m.a.a.d.t;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;

public class FileUtils {
    static final /* synthetic */ boolean a;

    public static boolean isDexFile(Path path) {
        return path.getFileName().toString().toLowerCase().endsWith(".dex");
    }

    public static boolean b(Path path) {
        return path.getFileName().toString().toLowerCase().endsWith(".vdex");
    }

    public static boolean isClassFile(Path object) {
        if (((String)(object = object.getFileName().toString().toLowerCase())).equals("module-info.class")) {
            return false;
        }
        return ((String)object).endsWith(".class");
    }

    public static boolean isJarFile(Path path) {
        return path.getFileName().toString().toLowerCase().endsWith(".jar");
    }

    public static boolean isZipFile(Path path) {
        return path.getFileName().toString().toLowerCase().endsWith(".zip");
    }

    public static boolean isArchive(Path object) {
        return ((String)(object = object.getFileName().toString().toLowerCase())).endsWith(".apk") || ((String)object).endsWith(".jar") || ((String)object).endsWith(".zip") || ((String)object).endsWith(".aar");
    }

    public static String readTextFile(Path path, Charset charset) throws IOException {
        return new String(Files.readAllBytes(path), charset);
    }

    public static List<String> readAllLines(Path path) throws IOException {
        return Files.readAllLines(path);
    }

    public static void writeTextFile(Path path, List<String> list) throws IOException {
        Files.write(path, list, new OpenOption[0]);
    }

    public static void writeTextFile(Path path, String ... stringArray) throws IOException {
        Files.write(path, Arrays.asList(stringArray), new OpenOption[0]);
    }

    public static Path a(Path path, Reporter reporter) {
        if (path != null) {
            if (!(FileUtils.isZipFile(path) || FileUtils.isJarFile(path) || Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]))) {
                reporter.error(new StringDiagnostic(e.a("Invalid output: ", (Object)path, "\nOutput must be a .zip or .jar archive or an existing directory")));
            }
        }
        return path;
    }

    public static OutputStream a(t t2, Path path, OpenOption ... openOptionArray) throws IOException {
        if (!a && path == null) {
            throw new AssertionError();
        }
        return FileUtils.a(t2, path, null, openOptionArray);
    }

    public static OutputStream a(t t2, Path path, OutputStream outputStream, OpenOption ... openOptionArray) throws IOException {
        if (path == null) {
            if (!a && outputStream == null) {
                throw new AssertionError();
            }
        } else {
            outputStream = Files.newOutputStream(path, openOptionArray);
            t2.a(outputStream);
        }
        return outputStream;
    }

    public static boolean a(Path object) {
        if (((String)(object = object.getFileName().toString().toLowerCase())).startsWith("classes") && ((String)object).endsWith(".dex")) {
            if (((String)(object = e.a((String)object, 4, 7))).isEmpty()) {
                return true;
            }
            Object object2 = object;
            int n2 = ((String)object2).charAt(0);
            if (((String)object2).length() == 1) {
                return 50 <= n2 && n2 <= 57;
            }
            if (n2 >= 49 && 57 >= n2) {
                for (n2 = 1; n2 < ((String)object).length(); ++n2) {
                    char c2 = ((String)object).charAt(n2);
                    if (c2 >= '0' && '9' >= c2) {
                        continue;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static void writeToFile(Path path, OutputStream outputStream, byte[] byArray) throws IOException {
        FileUtils.a(path, outputStream, ByteDataView.of(byArray));
    }

    public static void a(Path path, OutputStream outputStream, ByteDataView byteDataView) throws IOException {
        OpenOption[] openOptionArray;
        OutputStream outputStream2;
        Path path2;
        t t2 = t.a();
        try {
            path2 = path;
            outputStream2 = outputStream;
            openOptionArray = new OpenOption[3];
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    t2.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        openOptionArray[0] = StandardOpenOption.CREATE;
        openOptionArray[1] = StandardOpenOption.TRUNCATE_EXISTING;
        openOptionArray[2] = StandardOpenOption.WRITE;
        FileUtils.a(t2, path2, outputStream2, openOptionArray).write(byteDataView.getBuffer(), byteDataView.getOffset(), byteDataView.getLength());
        t2.close();
    }

    public static String withNativeFileSeparators(String string) {
        char c2 = File.separatorChar;
        if (c2 == '/') {
            return string.replace('\\', '/');
        }
        if (!a && c2 != '\\') {
            throw new AssertionError();
        }
        return string.replace('/', '\\');
    }

    static {
        a = FileUtils.class.desiredAssertionStatus() ^ true;
    }
}

