/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.packaging;

import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.packaging.PackageEmbeddedDex;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;

public class PackagingUtils {
    public static final ImmutableSet<String> DEFAULT_DONT_COMPRESS_EXTENSIONS = ImmutableSet.of((Object)".jpg", (Object)".jpeg", (Object)".png", (Object)".gif", (Object)".wav", (Object)".mp2", (Object[])new String[]{".mp3", ".ogg", ".aac", ".mpg", ".mpeg", ".mid", ".midi", ".smf", ".jet", ".rtttl", ".imy", ".xmf", ".mp4", ".m4a", ".m4v", ".3gp", ".3gpp", ".3g2", ".3gpp2", ".amr", ".awb", ".wma", ".wmv", ".webm", ".mkv"});
    private static final ImmutableList<String> NON_RESOURCES_EXTENSIONS = ImmutableList.builder().add((Object)"aidl").add((Object)"rs").add((Object)"fs").add((Object)"rsh").add((Object)"d").add((Object)"java").add((Object)"scala").add((Object)"scc").add((Object)"swp").build();
    public static final ImmutableList<String> SIGNING_EXTENSIONS = ImmutableList.of((Object)"SF", (Object)"RSA", (Object)"DSA", (Object)"EC");

    public static boolean checkFileForApkPackaging(String filePath, boolean allowClassFiles) {
        String fileName = new File(filePath).getName();
        return !PackagingUtils.isOfNonResourcesExtensions(Files.getFileExtension((String)fileName), allowClassFiles) && !filePath.equals("META-INF/MANIFEST.MF") && !PackagingUtils.isUsedForSigning(filePath) && !PackagingUtils.isMavenMetadata(filePath);
    }

    private static boolean isMavenMetadata(String filePath) {
        return filePath.startsWith("META-INF/maven");
    }

    private static boolean isUsedForSigning(String filePath) {
        if (!"META-INF".equals(new File(filePath).getParent())) {
            return false;
        }
        String fileExtension = Files.getFileExtension((String)filePath);
        for (String extension : SIGNING_EXTENSIONS) {
            if (!fileExtension.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOfNonResourcesExtensions(String extension, boolean allowClassFiles) {
        for (String ext : NON_RESOURCES_EXTENSIONS) {
            if (!ext.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return !allowClassFiles && "class".equals(extension);
    }

    public static Predicate<String> getDefaultNoCompressPredicate() {
        return PackagingUtils.getNoCompressPredicateForExtensions(DEFAULT_DONT_COMPRESS_EXTENSIONS);
    }

    public static Predicate<String> getNoCompressPredicate(Collection<String> aaptOptionsNoCompress, ManifestAttributeSupplier manifest) {
        NativeLibrariesPackagingMode packagingMode = PackagingUtils.getNativeLibrariesLibrariesPackagingMode(manifest);
        PackageEmbeddedDex useEmbeddedDex = PackagingUtils.getUseEmbeddedDex(manifest);
        return PackagingUtils.getNoCompressPredicateForExtensions(PackagingUtils.getAllNoCompressExtensions(aaptOptionsNoCompress, packagingMode, useEmbeddedDex));
    }

    public static List<String> getNoCompressGlobsForBundle(Collection<String> aaptOptionsNoCompress) {
        return (List)PackagingUtils.getAllNoCompressExtensions(aaptOptionsNoCompress, NativeLibrariesPackagingMode.COMPRESSED, PackageEmbeddedDex.DEFAULT).stream().map(s3 -> "**" + s3).sorted().collect(ImmutableList.toImmutableList());
    }

    public static NativeLibrariesPackagingMode getNativeLibrariesLibrariesPackagingMode(ManifestAttributeSupplier manifest) {
        Boolean extractNativeLibs = manifest.getExtractNativeLibs();
        if (Boolean.FALSE.equals(extractNativeLibs)) {
            return NativeLibrariesPackagingMode.UNCOMPRESSED_AND_ALIGNED;
        }
        return NativeLibrariesPackagingMode.COMPRESSED;
    }

    public static PackageEmbeddedDex getUseEmbeddedDex(ManifestAttributeSupplier manifest) {
        Boolean useEmbeddedDex = manifest.getUseEmbeddedDex();
        if (useEmbeddedDex == null) {
            return PackageEmbeddedDex.DEFAULT;
        }
        if (Boolean.TRUE.equals(useEmbeddedDex)) {
            return PackageEmbeddedDex.UNCOMPRESSED;
        }
        return PackageEmbeddedDex.COMPRESSED;
    }

    private static Predicate<String> getNoCompressPredicateForExtensions(Iterable<String> noCompressExtensions) {
        return name -> {
            for (String extension : noCompressExtensions) {
                if (!name.toLowerCase(Locale.US).endsWith(extension)) continue;
                return true;
            }
            return false;
        };
    }

    private static List<String> getAllNoCompressExtensions(Collection<String> aaptOptionsNoCompress, NativeLibrariesPackagingMode nativeLibrariesPackagingMode, PackageEmbeddedDex useEmbeddedDex) {
        ArrayList result = Lists.newArrayList(DEFAULT_DONT_COMPRESS_EXTENSIONS);
        if (nativeLibrariesPackagingMode == NativeLibrariesPackagingMode.UNCOMPRESSED_AND_ALIGNED) {
            result.add(".so");
        }
        if (!useEmbeddedDex.isCompressed()) {
            result.add(".dex");
        }
        if (aaptOptionsNoCompress != null) {
            result.addAll(aaptOptionsNoCompress);
        }
        return result;
    }
}

