/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.internal.packaging.ApkFlinger;
import com.android.builder.internal.packaging.ApkFlinger$WhenMappings;
import com.android.builder.internal.packaging.ApkFlingerKt;
import com.android.tools.build.apkzlib.zfile.ApkCreator;
import com.android.tools.build.apkzlib.zfile.ApkCreatorFactory;
import com.android.tools.build.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zipflinger.Entry;
import zipflinger.FileSource;
import zipflinger.Source;
import zipflinger.ZipArchive;
import zipflinger.ZipSource;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\tH\u0016J6\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00152\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/builder/internal/packaging/ApkFlinger;", "Lcom/android/tools/build/apkzlib/zfile/ApkCreator;", "creationData", "Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;", "compressionLevel", "", "(Lcom/android/tools/build/apkzlib/zfile/ApkCreatorFactory$CreationData;I)V", "noCompressPredicate", "Lcom/google/common/base/Predicate;", "", "pageAlignPredicate", "zipArchive", "Lzipflinger/ZipArchive;", "close", "", "deleteFile", "apkPath", "hasPendingChangesWithWait", "", "writeFile", "inputFile", "Ljava/io/File;", "writeZip", "zip", "transform", "Lcom/google/common/base/Function;", "isIgnored", "builder"})
public final class ApkFlinger
implements ApkCreator {
    private final ZipArchive zipArchive;
    private final Predicate<String> noCompressPredicate;
    private final Predicate<String> pageAlignPredicate;
    private final int compressionLevel;

    public void writeZip(@NotNull File zip, @Nullable Function<String, String> transform, @Nullable Predicate<String> isIgnored) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)zip, (String)"zip");
        Preconditions.checkArgument((boolean)zip.isFile(), (String)"!zip.isFile()", (Object[])new Object[0]);
        Predicate predicate = isIgnored;
        if (predicate == null) {
            predicate = writeZip.ignorePredicate.1.INSTANCE;
        }
        Predicate ignorePredicate2 = predicate;
        ZipSource zipSource = new ZipSource(zip);
        Collection entries2 = zipSource.entries().values();
        Iterator iterator = entries2.iterator();
        while (iterator.hasNext()) {
            Object name;
            Entry entry;
            Entry entry2 = entry = (Entry)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)entry2, (String)"entry");
            if (entry2.isDirectory() || ignorePredicate2.apply((Object)entry.getName())) continue;
            Object object = transform;
            if (object == null || (object = (String)object.apply((Object)entry.getName())) == null) {
                object = entry.getName();
            }
            Object object2 = name = object;
            Intrinsics.checkExpressionValueIsNotNull(object2, (String)"name");
            if (StringsKt.contains$default((CharSequence)((CharSequence)object2), (CharSequence)"../", (boolean)false, (int)2, null)) {
                throw (Throwable)new InvalidPathException((String)name, "Entry name contains invalid characters");
            }
            Source zipSourceEntry = zipSource.select(entry.getName(), name);
            if (entry.isCompressed()) continue;
            if (this.pageAlignPredicate.apply(name)) {
                zipSourceEntry.align(ApkFlingerKt.access$getPAGE_ALIGNMENT$p());
                continue;
            }
            zipSourceEntry.align(ApkFlingerKt.access$getDEFAULT_ALIGNMENT$p());
        }
        this.zipArchive.add(zipSource);
    }

    public void writeFile(@NotNull File inputFile, @NotNull String apkPath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
        Intrinsics.checkParameterIsNotNull((Object)apkPath, (String)"apkPath");
        boolean mayCompress = !this.noCompressPredicate.apply((Object)apkPath);
        FileSource fileSource = new FileSource(inputFile, apkPath, mayCompress ? this.compressionLevel : 0);
        if (!mayCompress) {
            if (this.pageAlignPredicate.apply((Object)apkPath)) {
                fileSource.align(ApkFlingerKt.access$getPAGE_ALIGNMENT$p());
            } else {
                fileSource.align(ApkFlingerKt.access$getDEFAULT_ALIGNMENT$p());
            }
        }
        this.zipArchive.add((Source)fileSource);
    }

    public void deleteFile(@NotNull String apkPath) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)apkPath, (String)"apkPath");
        this.zipArchive.delete(apkPath);
    }

    public boolean hasPendingChangesWithWait() throws IOException {
        throw (Throwable)new RuntimeException("not implemented");
    }

    public void close() throws IOException {
        this.zipArchive.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ApkFlinger(@NotNull ApkCreatorFactory.CreationData creationData, int compressionLevel) {
        Intrinsics.checkParameterIsNotNull((Object)creationData, (String)"creationData");
        this.compressionLevel = compressionLevel;
        NativeLibrariesPackagingMode nativeLibrariesPackagingMode = creationData.getNativeLibrariesPackagingMode();
        if (nativeLibrariesPackagingMode == null) throw (Throwable)((Object)new AssertionError());
        switch (ApkFlinger$WhenMappings.$EnumSwitchMapping$0[nativeLibrariesPackagingMode.ordinal()]) {
            case 1: {
                Predicate predicate = creationData.getNoCompressPredicate();
                Intrinsics.checkExpressionValueIsNotNull((Object)predicate, (String)"creationData.noCompressPredicate");
                this.noCompressPredicate = predicate;
                this.pageAlignPredicate = 1.INSTANCE;
                break;
            }
            case 2: {
                final Predicate baseNoCompressPredicate = creationData.getNoCompressPredicate();
                this.noCompressPredicate = (Predicate)new Predicate<String>(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(@Nullable String name) {
                        if (baseNoCompressPredicate.apply((Object)name)) return true;
                        String string = name;
                        if (string == null) return false;
                        boolean bl = StringsKt.endsWith$default((String)string, (String)".so", (boolean)false, (int)2, null);
                        if (!bl) return false;
                        return true;
                    }
                };
                this.pageAlignPredicate = 3.INSTANCE;
                break;
            }
            default: {
                throw (Throwable)((Object)new AssertionError());
            }
        }
        this.zipArchive = new ZipArchive(creationData.getApkPath());
    }
}

