/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.MergeOutputWriter;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;

public final class MergeOutputWriters {
    private MergeOutputWriters() {
    }

    public static MergeOutputWriter toDirectory(final File directory) {
        final Path directoryPath = directory.toPath();
        return new MergeOutputWriter(){
            private boolean isOpen = false;
            private boolean created = false;

            @Override
            public void open() {
                Preconditions.checkState((!this.isOpen ? 1 : 0) != 0, (Object)"Writer already open");
                this.isOpen = true;
            }

            @Override
            public void close() {
                Preconditions.checkState((boolean)this.isOpen, (Object)"Writer closed");
                this.isOpen = false;
            }

            private File toFile(String path) {
                if (!this.created) {
                    FileUtils.mkdirs((File)directory);
                    this.created = true;
                }
                return directoryPath.resolve(path).toFile();
            }

            @Override
            public void remove(String path) {
                Preconditions.checkState((boolean)this.isOpen, (Object)"Writer closed");
                File f3 = this.toFile(path);
                if (!f3.exists()) {
                    return;
                }
                if (f3.isDirectory()) {
                    try {
                        FileUtils.deletePath((File)f3);
                    }
                    catch (IOException e4) {
                        throw new UncheckedIOException(e4);
                    }
                    return;
                }
                if (!f3.delete()) {
                    throw new UncheckedIOException(new IOException("Cannot delete file " + f3.getAbsolutePath()));
                }
                File dir = f3.getParentFile();
                while (!dir.equals(directory)) {
                    String[] names = dir.list();
                    assert (names != null);
                    if (names.length != 0) break;
                    try {
                        FileUtils.delete((File)dir);
                    }
                    catch (IOException e5) {
                        throw new UncheckedIOException(e5);
                    }
                    dir = dir.getParentFile();
                }
            }

            @Override
            public void create(String path, InputStream data) {
                Preconditions.checkState((boolean)this.isOpen, (Object)"Writer closed");
                File f3 = this.toFile(path);
                FileUtils.mkdirs((File)f3.getParentFile());
                try (FileOutputStream fos = new FileOutputStream(f3);){
                    ByteStreams.copy((InputStream)data, (OutputStream)fos);
                }
                catch (IOException e4) {
                    throw new UncheckedIOException(e4);
                }
            }

            @Override
            public void replace(String path, InputStream data) {
                Preconditions.checkState((boolean)this.isOpen, (Object)"Writer closed");
                File f3 = this.toFile(path);
                FileUtils.mkdirs((File)f3.getParentFile());
                try (FileOutputStream fos = new FileOutputStream(f3);){
                    ByteStreams.copy((InputStream)data, (OutputStream)fos);
                }
                catch (IOException e4) {
                    throw new UncheckedIOException(e4);
                }
            }
        };
    }

    public static MergeOutputWriter toZip(final File file) {
        return new MergeOutputWriter(){
            private ZFile zipFile = null;

            @Override
            public void open() {
                Preconditions.checkState((this.zipFile == null ? 1 : 0) != 0, (Object)"Writer already open");
                try {
                    this.zipFile = ZFile.openReadWrite((File)file);
                }
                catch (IOException e4) {
                    throw new UncheckedIOException(e4);
                }
            }

            @Override
            public void close() {
                Preconditions.checkState((this.zipFile != null ? 1 : 0) != 0, (Object)"Writer not open");
                try {
                    this.zipFile.close();
                }
                catch (IOException e4) {
                    throw new UncheckedIOException(e4);
                }
                finally {
                    this.zipFile = null;
                }
            }

            @Override
            public void remove(String path) {
                Preconditions.checkState((this.zipFile != null ? 1 : 0) != 0, (Object)"Writer not open");
                StoredEntry entry = this.zipFile.get(path);
                if (entry != null) {
                    try {
                        entry.delete();
                    }
                    catch (IOException e4) {
                        throw new UncheckedIOException(e4);
                    }
                }
            }

            @Override
            public void create(String path, InputStream data) {
                Preconditions.checkState((this.zipFile != null ? 1 : 0) != 0, (Object)"Writer not open");
                try {
                    this.zipFile.add(path, data);
                }
                catch (IOException e4) {
                    throw new UncheckedIOException(e4);
                }
            }

            @Override
            public void replace(String path, InputStream data) {
                Preconditions.checkState((this.zipFile != null ? 1 : 0) != 0, (Object)"Writer not open");
                try {
                    this.zipFile.add(path, data);
                }
                catch (IOException e4) {
                    throw new UncheckedIOException(e4);
                }
            }
        };
    }
}

