/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.references;

import com.android.tools.r8.e;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.m.a.a.b.Z0;
import com.android.tools.r8.m.a.a.b.b0;
import com.android.tools.r8.references.ArrayReference;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.PrimitiveReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.utils.DescriptorUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public final class Reference {
    public static PrimitiveReference BOOL = PrimitiveReference.a;
    public static PrimitiveReference BYTE = PrimitiveReference.b;
    public static PrimitiveReference CHAR = PrimitiveReference.c;
    public static PrimitiveReference SHORT = PrimitiveReference.d;
    public static PrimitiveReference INT = PrimitiveReference.e;
    public static PrimitiveReference FLOAT = PrimitiveReference.f;
    public static PrimitiveReference LONG = PrimitiveReference.g;
    public static PrimitiveReference DOUBLE = PrimitiveReference.h;
    private static Reference e;
    private final ConcurrentMap<String, ClassReference> a = new Z0().g().f();
    private final ConcurrentMap<String, ArrayReference> b = new Z0().g().f();
    private final ConcurrentMap<MethodReference, MethodReference> c = new Z0().g().f();
    private final ConcurrentMap<FieldReference, FieldReference> d = new Z0().g().f();

    private Reference() {
    }

    private static Reference a() {
        if (e == null) {
            e = new Reference();
        }
        return e;
    }

    public static TypeReference typeFromDescriptor(String string) {
        char c4 = string.charAt(0);
        if (c4 != 'L') {
            if (c4 != '[') {
                return Reference.primitiveFromDescriptor(string);
            }
            return Reference.arrayFromDescriptor(string);
        }
        return Reference.classFromDescriptor(string);
    }

    private static TypeReference a(Class<?> clazz) {
        return Reference.typeFromDescriptor(DescriptorUtils.javaTypeToDescriptor(clazz.getTypeName()));
    }

    public static PrimitiveReference primitiveFromDescriptor(String string) {
        PrimitiveReference primitiveReference;
        if (!PrimitiveReference.i && string.length() != 1) {
            throw new AssertionError();
        }
        switch (string.charAt(0)) {
            default: {
                throw new Unreachable(com.android.tools.r8.e.a("Invalid primitive descriptor: ", string));
            }
            case 'Z': {
                primitiveReference = PrimitiveReference.a;
                break;
            }
            case 'S': {
                primitiveReference = PrimitiveReference.d;
                break;
            }
            case 'J': {
                primitiveReference = PrimitiveReference.g;
                break;
            }
            case 'I': {
                primitiveReference = PrimitiveReference.e;
                break;
            }
            case 'F': {
                primitiveReference = PrimitiveReference.f;
                break;
            }
            case 'D': {
                primitiveReference = PrimitiveReference.h;
                break;
            }
            case 'C': {
                primitiveReference = PrimitiveReference.c;
                break;
            }
            case 'B': {
                primitiveReference = PrimitiveReference.b;
            }
        }
        return primitiveReference;
    }

    public static ClassReference classFromDescriptor(String string) {
        return Reference.a().a.computeIfAbsent(string, ClassReference::a);
    }

    public static ClassReference classFromBinaryName(String string) {
        return Reference.classFromDescriptor(DescriptorUtils.getDescriptorFromClassBinaryName(string));
    }

    public static ClassReference classFromTypeName(String string) {
        return Reference.classFromDescriptor(DescriptorUtils.javaTypeToDescriptor(string));
    }

    public static ClassReference classFromClass(Class<?> clazz) {
        return Reference.classFromTypeName(clazz.getTypeName());
    }

    public static ArrayReference arrayFromDescriptor(String string) {
        return Reference.a().b.computeIfAbsent(string, ArrayReference::a);
    }

    public static MethodReference method(ClassReference classReference, String string, List<TypeReference> list, TypeReference typeReference) {
        MethodReference methodReference2;
        MethodReference methodReference3 = methodReference2;
        methodReference2 = new MethodReference(classReference, string, b0.a(list), typeReference);
        return Reference.a().c.computeIfAbsent(methodReference3, methodReference -> new MethodReference(methodReference.getHolderClass(), methodReference.getMethodName(), b0.a(methodReference.getFormalTypes()), methodReference.getReturnType()));
    }

    public static MethodReference methodFromMethod(Method object) {
        Method method = object;
        String string = method.getName();
        Object object2 = method.getDeclaringClass();
        Object object3 = method.getParameterTypes();
        object = ((Method)object).getReturnType();
        b0.a a4 = b0.h();
        int n3 = ((Class<?>[])object3).length;
        for (int i3 = 0; i3 < n3; ++i3) {
            a4.a(Reference.a(object3[i3]));
        }
        object2 = Reference.classFromClass(object2);
        object3 = a4.a();
        object = object == Void.TYPE ? null : Reference.a(object);
        return Reference.method((ClassReference)object2, string, object3, (TypeReference)object);
    }

    public static MethodReference methodFromMethod(Constructor<?> genericDeclaration) {
        Constructor<?> constructor = genericDeclaration;
        genericDeclaration = constructor.getDeclaringClass();
        Class<?>[] classArray = constructor.getParameterTypes();
        b0.a a4 = b0.h();
        int n3 = classArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            a4.a(Reference.a(classArray[i3]));
        }
        return Reference.method(Reference.classFromClass(genericDeclaration), "<init>", a4.a(), null);
    }

    public static FieldReference field(ClassReference classReference, String string, TypeReference typeReference) {
        FieldReference fieldReference2;
        FieldReference fieldReference3 = fieldReference2;
        fieldReference2 = new FieldReference(classReference, string, typeReference);
        return Reference.a().d.computeIfAbsent(fieldReference3, fieldReference -> new FieldReference(fieldReference.getHolderClass(), fieldReference.getFieldName(), fieldReference.getFieldType()));
    }

    public static FieldReference fieldFromField(Field annotatedElement) {
        Field field = annotatedElement;
        annotatedElement = field.getDeclaringClass();
        String string = field.getName();
        Class<?> clazz = field.getType();
        return Reference.field(Reference.classFromClass(annotatedElement), string, Reference.a(clazz));
    }
}

