/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.utils;

import com.android.builder.utils.ExceptionConsumer;
import com.android.builder.utils.ExceptionFunction;
import com.android.utils.concurrency.ReadWriteProcessLock;
import com.android.utils.concurrency.ReadWriteThreadLock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutionException;

public final class SynchronizedFile {
    private static final String LOCK_FILE_EXTENSION = ".lock";
    private final File fileToSynchronize;
    private final LockingScope lockingScope;
    private final ReadWriteProcessLock readWriteProcessLock;
    private final ReadWriteThreadLock readWriteThreadLock;

    private SynchronizedFile(File fileToSynchronize, LockingScope lockingScope) {
        try {
            fileToSynchronize = fileToSynchronize.getCanonicalFile();
        }
        catch (IOException e4) {
            throw new UncheckedIOException(e4);
        }
        this.fileToSynchronize = fileToSynchronize;
        this.lockingScope = lockingScope;
        if (lockingScope == LockingScope.MULTI_PROCESS) {
            File lockFile = SynchronizedFile.getLockFile(fileToSynchronize);
            this.readWriteProcessLock = new ReadWriteProcessLock(lockFile.toPath());
            this.readWriteThreadLock = null;
        } else {
            this.readWriteProcessLock = null;
            this.readWriteThreadLock = new ReadWriteThreadLock((Object)fileToSynchronize.toPath());
        }
    }

    public static SynchronizedFile getInstanceWithMultiProcessLocking(File fileToSynchronize) {
        return new SynchronizedFile(fileToSynchronize, LockingScope.MULTI_PROCESS);
    }

    public static SynchronizedFile getInstanceWithSingleProcessLocking(File fileToSynchronize) {
        return new SynchronizedFile(fileToSynchronize, LockingScope.SINGLE_PROCESS);
    }

    public static File getLockFile(File fileToSynchronize) {
        return new File(fileToSynchronize.getParent(), fileToSynchronize.getName() + LOCK_FILE_EXTENSION);
    }

    public <V> V read(ExceptionFunction<File, V> action) throws ExecutionException {
        if (this.lockingScope == LockingScope.MULTI_PROCESS) {
            return this.doActionWithMultiProcessLocking(LockingType.SHARED, action);
        }
        return this.doActionWithSingleProcessLocking(LockingType.SHARED, action);
    }

    public <V> V write(ExceptionFunction<File, V> action) throws ExecutionException {
        if (this.lockingScope == LockingScope.MULTI_PROCESS) {
            return this.doActionWithMultiProcessLocking(LockingType.EXCLUSIVE, action);
        }
        return this.doActionWithSingleProcessLocking(LockingType.EXCLUSIVE, action);
    }

    private <V> V doActionWithMultiProcessLocking(LockingType lockingType, ExceptionFunction<File, V> action) throws ExecutionException {
        ReadWriteProcessLock.Lock lock = lockingType == LockingType.SHARED ? ((ReadWriteProcessLock)Preconditions.checkNotNull((Object)this.readWriteProcessLock)).readLock() : ((ReadWriteProcessLock)Preconditions.checkNotNull((Object)this.readWriteProcessLock)).writeLock();
        try {
            lock.lock();
        }
        catch (IOException e4) {
            throw new UncheckedIOException(e4);
        }
        try {
            V e4 = action.accept(this.fileToSynchronize);
            return e4;
        }
        catch (Exception exception) {
            throw new ExecutionException(exception);
        }
        finally {
            try {
                lock.unlock();
            }
            catch (IOException e5) {
                throw new UncheckedIOException(e5);
            }
        }
    }

    private <V> V doActionWithSingleProcessLocking(LockingType lockingType, ExceptionFunction<File, V> action) throws ExecutionException {
        ReadWriteThreadLock.Lock lock = lockingType == LockingType.SHARED ? ((ReadWriteThreadLock)Preconditions.checkNotNull((Object)this.readWriteThreadLock)).readLock() : ((ReadWriteThreadLock)Preconditions.checkNotNull((Object)this.readWriteThreadLock)).writeLock();
        lock.lock();
        try {
            V v3 = action.accept(this.fileToSynchronize);
            return v3;
        }
        catch (Exception exception) {
            throw new ExecutionException(exception);
        }
        finally {
            lock.unlock();
        }
    }

    public void createIfAbsent(ExceptionConsumer<File> action) throws ExecutionException {
        boolean fileExists;
        try {
            fileExists = this.read(File::exists);
        }
        catch (ExecutionException exception) {
            throw new RuntimeException(exception);
        }
        if (!fileExists) {
            try {
                this.write(file -> {
                    if (!file.exists()) {
                        try {
                            action.accept((File)file);
                        }
                        catch (Exception exception) {
                            throw new ActionExecutionException(exception);
                        }
                        Preconditions.checkState((boolean)file.exists(), (Object)("File " + file.getAbsolutePath() + " should have been created but has not"));
                    }
                    return null;
                });
            }
            catch (ExecutionException exception) {
                for (Throwable exceptionInCausalChain : Throwables.getCausalChain((Throwable)exception)) {
                    if (!(exceptionInCausalChain instanceof ActionExecutionException)) continue;
                    throw exception;
                }
                throw new RuntimeException(exception);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileToSynchronize", (Object)this.fileToSynchronize).add("lockingScope", (Object)this.lockingScope).toString();
    }

    private static final class ActionExecutionException
    extends ExecutionException {
        public ActionExecutionException(Exception exception) {
            super(exception);
        }
    }

    @VisibleForTesting
    static enum LockingType {
        SHARED,
        EXCLUSIVE;

    }

    @VisibleForTesting
    static enum LockingScope {
        MULTI_PROCESS,
        SINGLE_PROCESS;

    }
}

