/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.D8DiagnosticsHandler;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexArchiveMerger;
import com.android.builder.dexing.DexArchiveMergerException;
import com.android.builder.dexing.DexArchives;
import com.android.builder.dexing.DexingType;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.errors.DuplicateTypesDiagnostic;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

final class D8DexArchiveMerger
implements DexArchiveMerger {
    private static final Logger LOGGER = Logger.getLogger(D8DexArchiveMerger.class.getName());
    private static final String ERROR_MULTIDEX = "Cannot fit requested classes in a single dex file";
    private final int minSdkVersion;
    private final CompilationMode compilationMode;
    private final MessageReceiver messageReceiver;
    private final ForkJoinPool forkJoinPool;
    private volatile boolean hintForMultidex = false;

    public D8DexArchiveMerger(@Nonnull MessageReceiver messageReceiver, int minSdkVersion, CompilationMode compilationMode, ForkJoinPool forkJoinPool) {
        this.minSdkVersion = minSdkVersion;
        this.compilationMode = compilationMode;
        this.messageReceiver = messageReceiver;
        this.forkJoinPool = forkJoinPool;
    }

    @Override
    public void mergeDexArchives(Iterator<Path> inputs, Path outputDir, Path mainDexClasses, DexingType dexingType) throws DexArchiveMergerException {
        ArrayList inputsList = Lists.newArrayList(inputs);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Merging to '" + outputDir.toAbsolutePath().toString() + "' with D8 from " + inputsList.stream().map(path -> path.toAbsolutePath().toString()).collect(Collectors.joining(", ")));
        }
        if (inputsList.isEmpty()) {
            return;
        }
        InterceptingDiagnosticsHandler d8DiagnosticsHandler = new InterceptingDiagnosticsHandler();
        D8Command.Builder builder = D8Command.builder(d8DiagnosticsHandler);
        builder.setDisableDesugaring(true);
        builder.setIncludeClassesChecksum(this.compilationMode == CompilationMode.DEBUG);
        for (Path input : inputsList) {
            try {
                DexArchive archive = DexArchives.fromInput(input);
                Throwable throwable = null;
                try {
                    for (DexArchiveEntry dexArchiveEntry : archive.getFiles()) {
                        builder.addDexProgramData(dexArchiveEntry.getDexFileContent(), D8DiagnosticsHandler.getOrigin(dexArchiveEntry));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (archive == null) continue;
                    if (throwable != null) {
                        try {
                            archive.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    archive.close();
                }
            }
            catch (IOException e3) {
                throw this.getExceptionToRethrow(e3, d8DiagnosticsHandler);
            }
        }
        try {
            if (mainDexClasses != null) {
                builder.addMainDexListFiles(mainDexClasses);
            }
            ((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)builder.setMinApiLevel(this.minSdkVersion)).setMode(this.compilationMode)).setOutput(outputDir, OutputMode.DexIndexed)).setDisableDesugaring(true)).setIntermediate(false);
            D8.run((D8Command)builder.build(), this.forkJoinPool);
        }
        catch (CompilationFailedException e4) {
            throw this.getExceptionToRethrow(e4, d8DiagnosticsHandler);
        }
    }

    private DexArchiveMergerException getExceptionToRethrow(Throwable t3, D8DiagnosticsHandler d8DiagnosticsHandler) {
        StringBuilder msg = new StringBuilder("Error while merging dex archives: ");
        for (String hint : d8DiagnosticsHandler.getPendingHints()) {
            msg.append(System.lineSeparator());
            msg.append(hint);
        }
        return new DexArchiveMergerException(msg.toString(), t3);
    }

    private class InterceptingDiagnosticsHandler
    extends D8DiagnosticsHandler {
        public InterceptingDiagnosticsHandler() {
            super(D8DexArchiveMerger.this.messageReceiver);
        }

        @Override
        protected Message convertToMessage(Message.Kind kind, Diagnostic diagnostic) {
            if (diagnostic.getDiagnosticMessage().startsWith(D8DexArchiveMerger.ERROR_MULTIDEX)) {
                this.addHint("The number of method references in a .dex file cannot exceed 64K.\nLearn how to resolve this issue at https://developer.android.com/tools/building/multidex.html");
            }
            if (diagnostic instanceof DuplicateTypesDiagnostic) {
                this.addHint(diagnostic.getDiagnosticMessage());
                this.addHint("Learn how to resolve the issue at https://developer.android.com/studio/build/dependencies#duplicate_classes.");
            }
            return super.convertToMessage(kind, diagnostic);
        }
    }
}

