/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.a;
import com.android.tools.r8.graph.M;
import com.android.tools.r8.graph.S;
import com.android.tools.r8.graph.V;
import com.android.tools.r8.graph.Z;
import com.android.tools.r8.graph.b0;
import com.android.tools.r8.graph.f0;
import com.android.tools.r8.shaking.GraphReporter;

public abstract class KeepReason {
    static KeepReason annotatedOn(M m4) {
        return new AnnotatedOn(m4);
    }

    static KeepReason instantiatedIn(S s4) {
        return new InstatiatedIn(s4);
    }

    public static KeepReason invokedViaSuperFrom(S s4) {
        return new InvokedViaSuper(s4);
    }

    public static KeepReason reachableFromLiveType(f0 f02) {
        return new ReachableFromLiveType(f02);
    }

    public static KeepReason invokedFrom(b0 b02, S s4) {
        return new InvokedFrom(b02, s4);
    }

    public static KeepReason invokedFromLambdaCreatedIn(S s4) {
        return new InvokedFromLambdaCreatedIn(s4);
    }

    public static KeepReason isLibraryMethod(b0 b02, f0 f02) {
        return new IsLibraryMethod(b02.c, f02);
    }

    public static KeepReason fieldReferencedIn(S s4) {
        return new ReferencedFrom(s4);
    }

    public static KeepReason referencedInAnnotation(V v4) {
        return new ReferencedInAnnotation(v4);
    }

    public static KeepReason targetedBySuperFrom(S s4) {
        return new TargetedBySuper(s4);
    }

    public static KeepReason reflectiveUseIn(S s4) {
        return new ReflectiveUseFrom(s4);
    }

    public static KeepReason methodHandleReferencedIn(S s4) {
        return new MethodHandleReferencedFrom(s4);
    }

    public abstract a.a edgeKind();

    public abstract GraphNode getSourceNode(GraphReporter var1);

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.q;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(S s4) {
            super(s4);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.l;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class AnnotatedOn
    extends KeepReason {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final M holder;

        private AnnotatedOn(M m4) {
            this.holder = m4;
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.j;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            if (this.holder.i()) {
                return graphReporter.getClassGraphNode(this.holder.f().c);
            }
            if (this.holder.j()) {
                return graphReporter.getFieldGraphNode(this.holder.g().a);
            }
            if (!$assertionsDisabled && !this.holder.k()) {
                throw new AssertionError();
            }
            return graphReporter.getMethodGraphNode(this.holder.h().a);
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final V holder;

        private ReferencedInAnnotation(V v4) {
            this.holder = v4;
        }

        @Override
        public a.a edgeKind() {
            return a.a.n;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getAnnotationGraphNode(this.holder);
        }
    }

    public static class IsLibraryMethod
    extends KeepReason {
        private final f0 implementer;
        private final f0 libraryType;

        private IsLibraryMethod(f0 f02, f0 f03) {
            this.implementer = f02;
            this.libraryType = f03;
        }

        @Override
        public a.a edgeKind() {
            return a.a.o;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.implementer);
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final f0 type;

        private ReachableFromLiveType(f0 f02) {
            this.type = f02;
        }

        @Override
        public a.a edgeKind() {
            return a.a.m;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.k;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.i;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        static final /* synthetic */ boolean $assertionsDisabled;

        private InvokedFrom(b0 b02, S s4) {
            super(s4);
            if (!$assertionsDisabled && b02.c != s4.a.c) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.h;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.g;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.f;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    public static class InstatiatedIn
    extends BasedOnOtherMethod {
        private InstatiatedIn(S s4) {
            super(s4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.e;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final S method;

        private BasedOnOtherMethod(S s4) {
            this.method = s4;
        }

        abstract String getKind();

        public Z getMethod() {
            return this.method.a;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getMethodGraphNode(this.method.a);
        }
    }
}

