/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.FixedSizeList;
import com.android.dx.util.IntList;

public final class ByteCatchList
extends FixedSizeList {
    public static final ByteCatchList EMPTY = new ByteCatchList(0);

    public ByteCatchList(int count) {
        super(count);
    }

    public int byteLength() {
        return 2 + this.size() * 8;
    }

    public Item get(int n4) {
        return (Item)this.get0(n4);
    }

    public void set(int n4, Item item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        this.set0(n4, item);
    }

    public void set(int n4, int startPc, int endPc, int handlerPc, CstType exceptionClass) {
        this.set0(n4, new Item(startPc, endPc, handlerPc, exceptionClass));
    }

    public ByteCatchList listFor(int pc) {
        int sz = this.size();
        Item[] resultArr = new Item[sz];
        int resultSz = 0;
        for (int i4 = 0; i4 < sz; ++i4) {
            Item one = this.get(i4);
            if (!one.covers(pc) || !ByteCatchList.typeNotFound(one, resultArr, resultSz)) continue;
            resultArr[resultSz] = one;
            ++resultSz;
        }
        if (resultSz == 0) {
            return EMPTY;
        }
        ByteCatchList result = new ByteCatchList(resultSz);
        for (int i5 = 0; i5 < resultSz; ++i5) {
            result.set(i5, resultArr[i5]);
        }
        result.setImmutable();
        return result;
    }

    private static boolean typeNotFound(Item item, Item[] arr, int count) {
        CstType type = item.getExceptionClass();
        for (int i4 = 0; i4 < count; ++i4) {
            CstType one = arr[i4].getExceptionClass();
            if (one != type && one != CstType.OBJECT) continue;
            return false;
        }
        return true;
    }

    public IntList toTargetList(int noException) {
        if (noException < -1) {
            throw new IllegalArgumentException("noException < -1");
        }
        boolean hasDefault = noException >= 0;
        int sz = this.size();
        if (sz == 0) {
            if (hasDefault) {
                return IntList.makeImmutable(noException);
            }
            return IntList.EMPTY;
        }
        IntList result = new IntList(sz + (hasDefault ? 1 : 0));
        for (int i4 = 0; i4 < sz; ++i4) {
            result.add(this.get(i4).getHandlerPc());
        }
        if (hasDefault) {
            result.add(noException);
        }
        result.setImmutable();
        return result;
    }

    public TypeList toRopCatchList() {
        int sz = this.size();
        if (sz == 0) {
            return StdTypeList.EMPTY;
        }
        StdTypeList result = new StdTypeList(sz);
        for (int i4 = 0; i4 < sz; ++i4) {
            result.set(i4, this.get(i4).getExceptionClass().getClassType());
        }
        result.setImmutable();
        return result;
    }

    public static class Item {
        private final int startPc;
        private final int endPc;
        private final int handlerPc;
        private final CstType exceptionClass;

        public Item(int startPc, int endPc, int handlerPc, CstType exceptionClass) {
            if (startPc < 0) {
                throw new IllegalArgumentException("startPc < 0");
            }
            if (endPc < startPc) {
                throw new IllegalArgumentException("endPc < startPc");
            }
            if (handlerPc < 0) {
                throw new IllegalArgumentException("handlerPc < 0");
            }
            this.startPc = startPc;
            this.endPc = endPc;
            this.handlerPc = handlerPc;
            this.exceptionClass = exceptionClass;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getEndPc() {
            return this.endPc;
        }

        public int getHandlerPc() {
            return this.handlerPc;
        }

        public CstType getExceptionClass() {
            return this.exceptionClass != null ? this.exceptionClass : CstType.OBJECT;
        }

        public boolean covers(int pc) {
            return pc >= this.startPc && pc < this.endPc;
        }
    }
}

