/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;

class TemplateProcessor {
    private final InputStream mTemplateStream;
    private final Map<String, String> mPlaceHolderMap;

    public TemplateProcessor(InputStream templateStream, Map<String, String> placeHolderMap) {
        this.mTemplateStream = (InputStream)Preconditions.checkNotNull((Object)templateStream);
        this.mPlaceHolderMap = (Map)Preconditions.checkNotNull(placeHolderMap);
    }

    public void generate(File outputFile) throws IOException {
        String template = this.readEmbeddedTextFile(this.mTemplateStream);
        String content = this.replaceParameters(template, this.mPlaceHolderMap);
        this.writeFile(outputFile, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readEmbeddedTextFile(InputStream templateStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(templateStream, Charsets.UTF_8);){
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
    }

    private void writeFile(File file, String content) throws IOException {
        Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content);
    }

    private String replaceParameters(String str, Map<String, String> parameters) {
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            str = str.replaceAll(entry.getKey(), value);
        }
        return str;
    }
}

