/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.desugaring.DesugaringClassAnalyzer;
import com.android.builder.dexing.ClassFile;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.D8DesugarGraphConsumer;
import com.android.builder.dexing.D8DesugarGraphGenerator;
import com.android.builder.dexing.DexParameters;
import com.android.ide.common.blame.Message;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J&\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004\u00a8\u0006\u0015"}, d2={"Lcom/android/builder/dexing/D8DesugarGraphGenerator;", "", "()V", "classFileToOrigin", "Lcom/android/tools/r8/origin/Origin;", "classFile", "Lcom/android/builder/dexing/ClassFile;", "generate", "", "classFiles", "", "dexParams", "Lcom/android/builder/dexing/DexParameters;", "graphConsumer", "Lcom/android/builder/dexing/D8DesugarGraphConsumer;", "getClassFiles", "classpath", "Ljava/nio/file/Path;", "originToFile", "Ljava/io/File;", "origin", "builder"})
public final class D8DesugarGraphGenerator {
    public static final D8DesugarGraphGenerator INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void generate(@NotNull List<ClassFile> classFiles, @NotNull DexParameters dexParams, @NotNull D8DesugarGraphConsumer graphConsumer) {
        Object type;
        Intrinsics.checkParameterIsNotNull(classFiles, (String)"classFiles");
        Intrinsics.checkParameterIsNotNull((Object)dexParams, (String)"dexParams");
        Intrinsics.checkParameterIsNotNull((Object)graphConsumer, (String)"graphConsumer");
        if (dexParams.getMinSdkVersion() >= 24) {
            return;
        }
        boolean bl = false;
        Map typeToClassFileMap = new LinkedHashMap();
        Collection<Path> collection = dexParams.getDesugarBootclasspath().getPaths();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"dexParams.desugarBootclasspath.paths");
        Collection<Path> collection2 = dexParams.getDesugarClasspath().getPaths();
        Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"dexParams.desugarClasspath.paths");
        List<ClassFile> classpath = INSTANCE.getClassFiles(CollectionsKt.plus(collection, (Iterable)collection2));
        for (ClassFile classFile : CollectionsKt.plus((Collection)classFiles, (Iterable)classpath)) {
            type = StringsKt.substringBefore$default((String)StringsKt.replace$default((String)classFile.getRelativePath(), (char)'\\', (char)'/', (boolean)false, (int)4, null), (String)".class", null, (int)2, null);
            typeToClassFileMap.put(type, classFile);
        }
        boolean bl2 = false;
        Set visitedSet = new LinkedHashSet();
        Set toVisitSet = CollectionsKt.toMutableSet((Iterable)classFiles);
        while (true) {
            type = toVisitSet;
            boolean bl3 = false;
            if (!(!type.isEmpty())) break;
            bl3 = false;
            Set toVisitNextSet = new LinkedHashSet();
            for (ClassFile toVisitNode : toVisitSet) {
                void $this$mapNotNullTo$iv$iv;
                Set<String> dependencyTypes;
                Intrinsics.checkExpressionValueIsNotNull(DesugaringClassAnalyzer.computeDependencies(toVisitNode.getContents()), (String)"DesugaringClassAnalyzer.\u2026ies(toVisitNode.contents)");
                Iterable $this$mapNotNull$iv = dependencyTypes;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ClassFile classFile;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl4 = false;
                    String it = (String)element$iv$iv;
                    boolean bl5 = false;
                    if (typeToClassFileMap.containsKey(it)) {
                        classFile = (ClassFile)typeToClassFileMap.get(it);
                    } else {
                        dexParams.getMessageReceiver().receiveMessage(new Message(Message.Kind.WARNING, "D8DesugarGraphGenerator can't resolve type " + it, null, null, null, 28, null));
                        classFile = null;
                    }
                    if (classFile == null) continue;
                    ClassFile classFile2 = classFile;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    ClassFile it$iv$iv = classFile2;
                    boolean bl8 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List dependencyClassFiles = (List)destination$iv$iv;
                toVisitNextSet.addAll(dependencyClassFiles);
                Iterable $this$forEach$iv = dependencyClassFiles;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    Origin dependencyOrigin;
                    ClassFile dependency = (ClassFile)element$iv;
                    boolean bl9 = false;
                    $i$f$forEach = Intrinsics.areEqual((Object)toVisitNode, (Object)dependency) ^ true;
                    boolean bl10 = false;
                    boolean bl11 = false;
                    bl11 = false;
                    boolean bl12 = false;
                    if (!$i$f$forEach) {
                        boolean bl13 = false;
                        String string = "Check failed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    Origin dependentOrigin = INSTANCE.classFileToOrigin(toVisitNode);
                    if (!(Intrinsics.areEqual((Object)dependentOrigin, (Object)(dependencyOrigin = INSTANCE.classFileToOrigin(dependency))) ^ true)) continue;
                    graphConsumer.accept(dependencyOrigin, dependentOrigin);
                }
            }
            visitedSet.addAll(toVisitSet);
            toVisitSet.clear();
            toVisitSet.addAll(SetsKt.minus((Set)toVisitNextSet, (Iterable)visitedSet));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<ClassFile> getClassFiles(List<? extends Path> classpath) {
        boolean bl = false;
        List classFiles = new ArrayList();
        for (Path path : classpath) {
            List list;
            Closeable closeable = ClassFileInputs.fromPath(path);
            List list2 = classFiles;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                List list3;
                ClassFileInput classFileInput = (ClassFileInput)closeable;
                boolean bl3 = false;
                AutoCloseable autoCloseable = classFileInput.entries(getClassFiles.1.1.INSTANCE);
                boolean bl4 = false;
                Throwable throwable2 = null;
                try {
                    Stream classFileStream = (Stream)autoCloseable;
                    boolean bl5 = false;
                    Stream stream = classFileStream.map(getClassFiles.1.2.1.INSTANCE);
                    Intrinsics.checkExpressionValueIsNotNull(stream, (String)"classFileStream.map {\n  \u2026                        }");
                    list3 = StreamsKt.toList(stream);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                list = list3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            List list4 = list;
            list2.addAll(list4);
        }
        return CollectionsKt.toList((Iterable)classFiles);
    }

    private final Origin classFileToOrigin(ClassFile classFile) {
        return classFile.isJarFile() ? (Origin)new ArchiveEntryOrigin(classFile.getRelativePath(), new PathOrigin(classFile.getRoot())) : (Origin)new PathOrigin(classFile.getRoot().resolve(classFile.getRelativePath()));
    }

    @NotNull
    public final File originToFile(@NotNull Origin origin) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
        Origin origin2 = origin;
        if (origin2 instanceof PathOrigin) {
            file = new File(origin.part());
        } else if (origin2 instanceof ArchiveEntryOrigin) {
            file = new File(origin.parent().part());
        } else {
            String string = "Unexpected type " + origin.getClass();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return file;
    }

    private D8DesugarGraphGenerator() {
    }

    static {
        D8DesugarGraphGenerator d8DesugarGraphGenerator;
        INSTANCE = d8DesugarGraphGenerator = new D8DesugarGraphGenerator();
    }
}

