/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.a;
import com.android.tools.r8.graph.N;
import com.android.tools.r8.graph.T;
import com.android.tools.r8.graph.V;
import com.android.tools.r8.graph.Z;
import com.android.tools.r8.graph.b0;
import com.android.tools.r8.graph.f0;
import com.android.tools.r8.shaking.GraphReporter;

public abstract class KeepReason {
    static KeepReason annotatedOn(N n4) {
        return new AnnotatedOn(n4);
    }

    static KeepReason instantiatedIn(T t4) {
        return new InstatiatedIn(t4);
    }

    public static KeepReason invokedViaSuperFrom(T t4) {
        return new InvokedViaSuper(t4);
    }

    public static KeepReason reachableFromLiveType(f0 f02) {
        return new ReachableFromLiveType(f02);
    }

    public static KeepReason invokedFrom(b0 b02, T t4) {
        return new InvokedFrom(b02, t4);
    }

    public static KeepReason invokedFromLambdaCreatedIn(T t4) {
        return new InvokedFromLambdaCreatedIn(t4);
    }

    public static KeepReason isLibraryMethod(b0 b02, f0 f02) {
        return new IsLibraryMethod(b02.c, f02);
    }

    public static KeepReason fieldReferencedIn(T t4) {
        return new ReferencedFrom(t4);
    }

    public static KeepReason referencedInAnnotation(V v4) {
        return new ReferencedInAnnotation(v4);
    }

    public static KeepReason targetedBySuperFrom(T t4) {
        return new TargetedBySuper(t4);
    }

    public static KeepReason reflectiveUseIn(T t4) {
        return new ReflectiveUseFrom(t4);
    }

    public static KeepReason methodHandleReferencedIn(T t4) {
        return new MethodHandleReferencedFrom(t4);
    }

    public abstract a.a edgeKind();

    public abstract GraphNode getSourceNode(GraphReporter var1);

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.q;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(T t4) {
            super(t4);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.l;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class AnnotatedOn
    extends KeepReason {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final N holder;

        private AnnotatedOn(N n4) {
            this.holder = n4;
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.j;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            if (this.holder.d()) {
                return graphReporter.getClassGraphNode(this.holder.a().c);
            }
            if (this.holder.e()) {
                return graphReporter.getFieldGraphNode(this.holder.b().a);
            }
            if (!$assertionsDisabled && !this.holder.f()) {
                throw new AssertionError();
            }
            return graphReporter.getMethodGraphNode(this.holder.c().a);
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final V holder;

        private ReferencedInAnnotation(V v4) {
            this.holder = v4;
        }

        @Override
        public a.a edgeKind() {
            return a.a.n;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getAnnotationGraphNode(this.holder);
        }
    }

    public static class IsLibraryMethod
    extends KeepReason {
        private final f0 implementer;
        private final f0 libraryType;

        private IsLibraryMethod(f0 f02, f0 f03) {
            this.implementer = f02;
            this.libraryType = f03;
        }

        @Override
        public a.a edgeKind() {
            return a.a.o;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.implementer);
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final f0 type;

        private ReachableFromLiveType(f0 f02) {
            this.type = f02;
        }

        @Override
        public a.a edgeKind() {
            return a.a.m;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.k;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.i;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        static final /* synthetic */ boolean $assertionsDisabled;

        private InvokedFrom(b0 b02, T t4) {
            super(t4);
            if (!$assertionsDisabled && b02.c != t4.a.c) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.h;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.g;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.f;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    public static class InstatiatedIn
    extends BasedOnOtherMethod {
        private InstatiatedIn(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.e;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final T method;

        private BasedOnOtherMethod(T t4) {
            this.method = t4;
        }

        abstract String getKind();

        public Z getMethod() {
            return this.method.a;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getMethodGraphNode(this.method.a);
        }
    }
}

