/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.f0;
import com.android.tools.r8.r.a.a.b.W;
import com.android.tools.r8.r.a.a.b.v;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWildcard;
import com.android.tools.r8.u.a.a.a.h.D;
import com.android.tools.r8.u.a.a.a.h.E;
import com.android.tools.r8.u.a.a.a.h.a;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class ProguardClassNameList {
    public static Builder builder() {
        return new Builder();
    }

    public static ProguardClassNameList emptyList() {
        return new EmptyClassNameList();
    }

    public static ProguardClassNameList singletonList(ProguardTypeMatcher proguardTypeMatcher) {
        return new SingleClassNameList(proguardTypeMatcher);
    }

    static Iterable<ProguardWildcard> getWildcardsOrEmpty(ProguardClassNameList proguardClassNameList) {
        return proguardClassNameList == null ? Collections::emptyIterator : proguardClassNameList.getWildcards();
    }

    public abstract int size();

    public abstract void writeTo(StringBuilder var1);

    public String toString() {
        StringBuilder stringBuilder;
        ProguardClassNameList proguardClassNameList = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        proguardClassNameList.writeTo(new StringBuilder());
        return stringBuilder2.toString();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract List<f0> asSpecificDexTypes();

    public abstract boolean matches(f0 var1);

    protected Iterable<ProguardWildcard> getWildcards() {
        return Collections::emptyIterator;
    }

    protected ProguardClassNameList materialize(com.android.tools.r8.graph.W w4) {
        return this;
    }

    public abstract void forEachTypeMatcher(Consumer<ProguardTypeMatcher> var1);

    private static class MixedClassNameList
    extends ProguardClassNameList {
        private final E<ProguardTypeMatcher> classNames;

        private MixedClassNameList(E<ProguardTypeMatcher> e4) {
            this.classNames = e4;
        }

        @Override
        public int size() {
            return ((D)this.classNames).size();
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
            boolean bl = true;
            for (E.a a4 : ((D)this.classNames).c()) {
                if (!bl) {
                    stringBuilder.append(',');
                }
                if (((a)(a4 = (a)a4)).d()) {
                    stringBuilder.append('!');
                }
                stringBuilder.append(((ProguardTypeMatcher)a4.getKey()).toString());
                bl = false;
            }
        }

        @Override
        public boolean equals(Object object) {
            if (mixedClassNameList2 == object) {
                return true;
            }
            if (object != null && MixedClassNameList.class == object.getClass()) {
                MixedClassNameList mixedClassNameList = mixedClassNameList2;
                MixedClassNameList mixedClassNameList2 = (MixedClassNameList)object;
                return Objects.equals(mixedClassNameList.classNames, mixedClassNameList2.classNames);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.classNames);
        }

        @Override
        public List<f0> asSpecificDexTypes() {
            return null;
        }

        @Override
        public boolean matches(f0 f02) {
            for (E.a a4 : ((D)((MixedClassNameList)this).classNames).c()) {
                if (!((ProguardTypeMatcher)a4.getKey()).matches(f02)) continue;
                return ((a)a4).d() ^ true;
            }
            return false;
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return ((D)this.classNames).keySet().stream().map(ProguardTypeMatcher::getWildcards).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false))::iterator;
        }

        @Override
        protected ProguardClassNameList materialize(com.android.tools.r8.graph.W w4) {
            Builder builder = ProguardClassNameList.builder();
            this.classNames.forEach((proguardTypeMatcher, bl) -> {
                boolean bl2 = bl;
                builder.addClassName(bl2, proguardTypeMatcher.materialize(w4));
            });
            return builder.build();
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            ((D)this.classNames).c().forEach(a4 -> consumer.accept((ProguardTypeMatcher)a4.getKey()));
        }
    }

    private static class PositiveClassNameList
    extends ProguardClassNameList {
        private final W<ProguardTypeMatcher> classNames;

        private PositiveClassNameList(Collection<ProguardTypeMatcher> collection) {
            this.classNames = W.a(collection);
        }

        @Override
        public int size() {
            return this.classNames.size();
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
            boolean bl = true;
            for (ProguardTypeMatcher proguardTypeMatcher : this.classNames) {
                if (!bl) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(proguardTypeMatcher);
                bl = false;
            }
        }

        @Override
        public boolean equals(Object object) {
            if (positiveClassNameList2 == object) {
                return true;
            }
            if (object != null && PositiveClassNameList.class == object.getClass()) {
                PositiveClassNameList positiveClassNameList = positiveClassNameList2;
                PositiveClassNameList positiveClassNameList2 = (PositiveClassNameList)object;
                return Objects.equals(positiveClassNameList.classNames, positiveClassNameList2.classNames);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.classNames);
        }

        @Override
        public List<f0> asSpecificDexTypes() {
            if (this.classNames.stream().allMatch(proguardTypeMatcher -> proguardTypeMatcher.getSpecificType() != null)) {
                return this.classNames.stream().map(ProguardTypeMatcher::getSpecificType).collect(Collectors.toList());
            }
            return null;
        }

        @Override
        public boolean matches(f0 f02) {
            return this.classNames.stream().anyMatch(proguardTypeMatcher -> proguardTypeMatcher.matches(f02));
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.classNames.stream().map(ProguardTypeMatcher::getWildcards).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false))::iterator;
        }

        @Override
        protected PositiveClassNameList materialize(com.android.tools.r8.graph.W w4) {
            return new PositiveClassNameList(this.classNames.stream().map(proguardTypeMatcher -> proguardTypeMatcher.materialize(w4)).collect(Collectors.toList()));
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            this.classNames.forEach(consumer);
        }
    }

    static class SingleClassNameList
    extends ProguardClassNameList {
        final ProguardTypeMatcher className;

        private SingleClassNameList(ProguardTypeMatcher proguardTypeMatcher) {
            this.className = proguardTypeMatcher;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
            stringBuilder.append(this.className.toString());
        }

        @Override
        public boolean equals(Object object) {
            if (singleClassNameList2 == object) {
                return true;
            }
            if (object != null && SingleClassNameList.class == object.getClass()) {
                SingleClassNameList singleClassNameList = singleClassNameList2;
                SingleClassNameList singleClassNameList2 = (SingleClassNameList)object;
                return Objects.equals(singleClassNameList.className, singleClassNameList2.className);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.className);
        }

        @Override
        public List<f0> asSpecificDexTypes() {
            f0 f02 = ((SingleClassNameList)((Object)f02)).className.getSpecificType();
            return f02 == null ? null : Collections.singletonList(f02);
        }

        @Override
        public boolean matches(f0 f02) {
            return this.className.matches(f02);
        }

        @Override
        protected Iterable<ProguardWildcard> getWildcards() {
            return this.className.getWildcards();
        }

        @Override
        protected SingleClassNameList materialize(com.android.tools.r8.graph.W w4) {
            return new SingleClassNameList(this.className.materialize(w4));
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
            consumer.accept(this.className);
        }
    }

    private static class EmptyClassNameList
    extends ProguardClassNameList {
        private EmptyClassNameList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void writeTo(StringBuilder stringBuilder) {
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof EmptyClassNameList;
        }

        @Override
        public int hashCode() {
            return 7;
        }

        @Override
        public List<f0> asSpecificDexTypes() {
            return null;
        }

        @Override
        public boolean matches(f0 f02) {
            return false;
        }

        @Override
        public void forEachTypeMatcher(Consumer<ProguardTypeMatcher> consumer) {
        }
    }

    public static class Builder {
        private final E<ProguardTypeMatcher> matchers;

        private Builder() {
            D d4;
            D d5 = d4;
            d4 = new D();
            v1.matchers = d5;
        }

        public Builder addClassName(boolean bl, ProguardTypeMatcher proguardTypeMatcher) {
            Builder builder = this;
            ((D)builder.matchers).a(proguardTypeMatcher, bl);
            return builder;
        }

        ProguardClassNameList build() {
            if (((D)this.matchers).a(true)) {
                return new MixedClassNameList(this.matchers);
            }
            if (((D)this.matchers).size() == 1) {
                return new SingleClassNameList((ProguardTypeMatcher)v.b(((D)this.matchers).keySet()));
            }
            return new PositiveClassNameList(((D)this.matchers).keySet());
        }
    }
}

