/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing.r8;

import com.android.builder.dexing.r8.CachingArchiveClassFileProvider;
import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.DirectoryClassFileProvider;
import com.android.tools.r8.ProgramResource;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class ClassFileProviderFactory
implements Closeable {
    private Collection<Path> paths;
    private static final AtomicLong nextId = new AtomicLong();
    private List<ClassFileResourceProvider> providers;
    private final OrderedClassFileResourceProvider orderedClassFileResourceProvider;
    private final long id;

    public ClassFileProviderFactory(Collection<Path> paths) throws IOException {
        this.paths = paths;
        this.id = nextId.addAndGet(1L);
        this.providers = Lists.newArrayListWithExpectedSize((int)paths.size());
        for (Path path : paths) {
            if (!path.toFile().exists()) continue;
            this.providers.add(ClassFileProviderFactory.createProvider(path));
        }
        this.orderedClassFileResourceProvider = new OrderedClassFileResourceProvider(this.providers);
    }

    public Collection<Path> getPaths() {
        return this.paths;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public void close() throws IOException {
        for (ClassFileResourceProvider provider2 : this.providers) {
            if (!(provider2 instanceof Closeable)) continue;
            ((Closeable)((Object)provider2)).close();
        }
        this.providers.clear();
    }

    public ClassFileResourceProvider getOrderedProvider() {
        return this.orderedClassFileResourceProvider;
    }

    private static ClassFileResourceProvider createProvider(Path entry) throws IOException {
        if (Files.isRegularFile(entry, new LinkOption[0])) {
            return new CachingArchiveClassFileProvider(entry);
        }
        if (Files.isDirectory(entry, new LinkOption[0])) {
            return DirectoryClassFileProvider.fromDirectory(entry);
        }
        throw new FileNotFoundException(entry.toString());
    }

    private static class OrderedClassFileResourceProvider
    implements ClassFileResourceProvider {
        private final Supplier<Map<String, ClassFileResourceProvider>> descriptors = Suppliers.memoize(() -> {
            HashMap descs = Maps.newHashMap();
            for (ClassFileResourceProvider provider2 : providers) {
                for (String s4 : provider2.getClassDescriptors()) {
                    if (descs.containsKey(s4)) continue;
                    descs.put(s4, provider2);
                }
            }
            return descs;
        });

        OrderedClassFileResourceProvider(List<ClassFileResourceProvider> providers) {
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.descriptors.get().keySet();
        }

        @Override
        public ProgramResource getProgramResource(String descriptor) {
            ClassFileResourceProvider provider2 = this.descriptors.get().get(descriptor);
            if (provider2 == null) {
                return null;
            }
            return provider2.getProgramResource(descriptor);
        }
    }
}

