/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency.level2;

import com.android.builder.dependency.HashCodeUtils;
import com.android.builder.dependency.MavenCoordinatesImpl;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;

public final class JavaDependency
extends Dependency {
    private static final String LOCAL_JAR_GROUPID = "__local_jars__";
    private final boolean isLocal;
    private final int hashcode;

    public JavaDependency(File artifactFile, MavenCoordinates coordinates, String name, String projectPath) {
        this(artifactFile, coordinates, name, projectPath, false);
    }

    public JavaDependency(File artifactFile) {
        this(artifactFile, JavaDependency.getCoordForLocalJar(artifactFile), null, null, true);
    }

    private JavaDependency(File artifactFile, MavenCoordinates coordinates, String name, String projectPath, boolean isLocal) {
        super(artifactFile, coordinates, name != null ? name : coordinates.toString(), projectPath);
        this.isLocal = isLocal;
        this.hashcode = this.computeHashCode();
    }

    @Override
    public File getClasspathFile() {
        return this.getArtifactFile();
    }

    @Override
    public List<File> getAdditionalClasspath() {
        return ImmutableList.of();
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public boolean equals(Object o4) {
        if (this == o4) {
            return true;
        }
        if (o4 == null || this.getClass() != o4.getClass()) {
            return false;
        }
        if (!super.equals(o4)) {
            return false;
        }
        JavaDependency that = (JavaDependency)o4;
        return this.isLocal == that.isLocal;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int computeHashCode() {
        return HashCodeUtils.hashCode(super.hashCode(), this.isLocal);
    }

    public static MavenCoordinatesImpl getCoordForLocalJar(File jarFile) {
        return MavenCoordinatesImpl.create(string -> string, LOCAL_JAR_GROUPID, jarFile.getPath(), "unspecified");
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("artifactFile", (Object)this.getArtifactFile()).add("coordinates", (Object)this.getCoordinates()).add("projectPath", (Object)this.getProjectPath()).add("isLocal", this.isLocal).toString();
    }
}

