/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.ide.common.resources.ResourcePreprocessor;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.vectordrawable.IllegalVectorDrawableResourceRefException;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class VectorDrawableRenderer
implements ResourcePreprocessor {
    private static final String TAG_GRADIENT = "gradient";
    private final Supplier<ILogger> mLogger;
    private final int mMinSdk;
    private final boolean mSupportLibraryIsUsed;
    private final File mOutputDir;
    private final Collection<Density> mDensities;

    public VectorDrawableRenderer(int minSdk, boolean supportLibraryIsUsed, File outputDir, Collection<Density> densities, Supplier<ILogger> loggerSupplier) {
        this.mMinSdk = minSdk;
        this.mSupportLibraryIsUsed = supportLibraryIsUsed;
        this.mOutputDir = outputDir;
        this.mDensities = densities;
        this.mLogger = loggerSupplier;
    }

    public Collection<File> getFilesToBeGenerated(File inputXmlFile) throws IOException {
        FolderConfiguration originalConfiguration = VectorDrawableRenderer.getFolderConfiguration(inputXmlFile);
        PreprocessingReason reason = this.getReasonForPreprocessing(inputXmlFile, originalConfiguration);
        if (reason == null) {
            return Collections.emptyList();
        }
        ArrayList<File> filesToBeGenerated = new ArrayList<File>();
        DensityQualifier densityQualifier = originalConfiguration.getDensityQualifier();
        boolean validDensityQualifier = ResourceQualifier.isValid((ResourceQualifier)densityQualifier);
        if (validDensityQualifier && densityQualifier.getValue() == Density.NODPI) {
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName()));
        } else if (validDensityQualifier && densityQualifier.getValue() != Density.ANYDPI) {
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName().replace(".xml", ".png")));
            originalConfiguration.setVersionQualifier(new VersionQualifier(reason.getSdkThreshold()));
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName()));
        } else {
            if (originalConfiguration.getVersionQualifier() != null) {
                if (validDensityQualifier || originalConfiguration.getVersionQualifier().getVersion() < reason.getSdkThreshold()) {
                    for (Density density : this.mDensities) {
                        FolderConfiguration newConfiguration = FolderConfiguration.copyOf((FolderConfiguration)originalConfiguration);
                        newConfiguration.setDensityQualifier(new DensityQualifier(density));
                        if (originalConfiguration.getVersionQualifier().getVersion() >= reason.getSdkThreshold()) {
                            newConfiguration.removeQualifier((ResourceQualifier)newConfiguration.getVersionQualifier());
                        }
                        filesToBeGenerated.add(new File(this.getDirectory(newConfiguration), inputXmlFile.getName().replace(".xml", ".png")));
                    }
                    originalConfiguration.setVersionQualifier(new VersionQualifier(reason.getSdkThreshold()));
                }
                if (originalConfiguration.getVersionQualifier().getVersion() >= reason.getSdkThreshold()) {
                    originalConfiguration.setDensityQualifier(new DensityQualifier(Density.ANYDPI));
                }
            } else {
                if (this.mMinSdk < reason.getSdkThreshold() && this.mDensities.size() > 0) {
                    for (Density density : this.mDensities) {
                        FolderConfiguration newConfiguration = FolderConfiguration.copyOf((FolderConfiguration)originalConfiguration);
                        newConfiguration.setDensityQualifier(new DensityQualifier(density));
                        filesToBeGenerated.add(new File(this.getDirectory(newConfiguration), inputXmlFile.getName().replace(".xml", ".png")));
                    }
                }
                originalConfiguration.setDensityQualifier(new DensityQualifier(Density.ANYDPI));
                originalConfiguration.setVersionQualifier(new VersionQualifier(reason.getSdkThreshold()));
            }
            FolderConfiguration minSdkSourceConfig = FolderConfiguration.copyOf((FolderConfiguration)originalConfiguration);
            if (originalConfiguration.getDensityQualifier().isMatchFor((ResourceQualifier)new DensityQualifier(Density.ANYDPI))) {
                minSdkSourceConfig.removeQualifier((ResourceQualifier)originalConfiguration.getDensityQualifier());
            }
            minSdkSourceConfig.setVersionQualifier(new VersionQualifier(reason.mSdkThreshold));
            File possibleMinReasonSdkResource = FileUtils.join((File)inputXmlFile.getParentFile().getParentFile(), (String[])new String[]{"drawable-" + minSdkSourceConfig.getQualifierString(), inputXmlFile.getName()});
            if (filesToBeGenerated.isEmpty() || !possibleMinReasonSdkResource.exists()) {
                filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName()));
            }
        }
        return filesToBeGenerated;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private PreprocessingReason getReasonForPreprocessing(File resourceFile, FolderConfiguration folderConfig) throws IOException {
        if (this.mSupportLibraryIsUsed) {
            return null;
        }
        if (this.mMinSdk >= PreprocessingReason.GRADIENT_SUPPORT.getSdkThreshold()) {
            return null;
        }
        if (!VectorDrawableRenderer.isXml(resourceFile) || !VectorDrawableRenderer.isInDrawable(resourceFile)) {
            return null;
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(resourceFile));){
            XMLInputFactory factory = XMLInputFactory.newFactory();
            XMLStreamReader xmlReader = factory.createXMLStreamReader(stream);
            boolean beforeFirstTag = true;
            while (xmlReader.hasNext()) {
                int event = xmlReader.next();
                if (event != 1) continue;
                if (beforeFirstTag) {
                    if (!"vector".equals(xmlReader.getLocalName())) {
                        PreprocessingReason preprocessingReason = null;
                        return preprocessingReason;
                    }
                    beforeFirstTag = false;
                    continue;
                }
                if (TAG_GRADIENT.equals(xmlReader.getLocalName())) {
                    PreprocessingReason preprocessingReason = PreprocessingReason.GRADIENT_SUPPORT;
                    return preprocessingReason;
                }
                int n4 = xmlReader.getAttributeCount();
                for (int i4 = 0; i4 < n4; ++i4) {
                    if (!"fillType".equals(xmlReader.getAttributeLocalName(i4)) || !"http://schemas.android.com/apk/res/android".equals(xmlReader.getAttributeNamespace(i4))) continue;
                    PreprocessingReason preprocessingReason = PreprocessingReason.FILLTYPE_SUPPORT;
                    return preprocessingReason;
                }
            }
            if (!beforeFirstTag && this.mMinSdk < PreprocessingReason.VECTOR_SUPPORT.getSdkThreshold()) {
                PreprocessingReason preprocessingReason = PreprocessingReason.VECTOR_SUPPORT;
                return preprocessingReason;
            }
        }
        catch (XMLStreamException e5) {
            throw new IOException("Failed to parse resource file " + resourceFile.getAbsolutePath(), e5);
        }
        return null;
    }

    private File getDirectory(FolderConfiguration newConfiguration) {
        return new File(this.mOutputDir, newConfiguration.getFolderName(ResourceFolderType.DRAWABLE));
    }

    public void generateFile(File toBeGenerated, File original) throws IOException {
        Files.createParentDirs((File)toBeGenerated);
        if (VectorDrawableRenderer.isXml(toBeGenerated)) {
            Files.copy((File)original, (File)toBeGenerated);
        } else {
            BufferedImage image;
            this.mLogger.get().verbose("Generating PNG: [%s] from [%s]", new Object[]{toBeGenerated.getAbsolutePath(), original.getAbsolutePath()});
            FolderConfiguration folderConfiguration = VectorDrawableRenderer.getFolderConfiguration(toBeGenerated);
            Preconditions.checkState((folderConfiguration.getDensityQualifier() != null ? 1 : 0) != 0);
            Density density = folderConfiguration.getDensityQualifier().getValue();
            assert (density != null);
            float scaleFactor = (float)density.getDpiValue() / (float)Density.MEDIUM.getDpiValue();
            if (scaleFactor <= 0.0f) {
                scaleFactor = 1.0f;
            }
            VdPreview.TargetSize imageSize = VdPreview.TargetSize.createFromScale((double)scaleFactor);
            String xmlContent = Files.asCharSource((File)original, (Charset)StandardCharsets.UTF_8).read();
            try {
                image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)imageSize, (String)xmlContent, null);
            }
            catch (IllegalVectorDrawableResourceRefException e5) {
                String message = String.format("Unable to generate a PNG file from vector drawable from resource reference '%s' (%s line %s). Please consider using vectorDrawables.useSupportLibrary or replace the resource reference with a hexadecimal value. More information: https://developer.android.com/guide/topics/graphics/vector-drawable-resources", e5.getValue(), original.getAbsolutePath(), e5.getSourcePosition().getStartLine() + 1);
                throw new IllegalVectorDrawableResourceRefException(e5.getValue(), e5.getSourcePosition(), message);
            }
            Preconditions.checkState((image != null ? 1 : 0) != 0, (Object)"Generating the image failed.");
            ImageIO.write((RenderedImage)image, "png", toBeGenerated);
        }
    }

    private static FolderConfiguration getFolderConfiguration(File inputXmlFile) {
        String parentName = inputXmlFile.getParentFile().getName();
        FolderConfiguration originalConfiguration = FolderConfiguration.getConfigForFolder((String)parentName);
        Preconditions.checkArgument((originalConfiguration != null ? 1 : 0) != 0, (String)"Invalid resource folder name [%s].", (Object)parentName);
        return originalConfiguration;
    }

    private static boolean isInDrawable(File inputXmlFile) {
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)inputXmlFile.getParentFile().getName());
        return folderType == ResourceFolderType.DRAWABLE;
    }

    private static boolean isXml(File resourceFile) {
        return Files.getFileExtension((String)resourceFile.getName()).equals("xml");
    }

    protected String getPreprocessingReasonDescription(File inputXmlFile) throws IOException {
        FolderConfiguration config = VectorDrawableRenderer.getFolderConfiguration(inputXmlFile);
        PreprocessingReason reason = this.getReasonForPreprocessing(inputXmlFile, config);
        return Objects.requireNonNull(reason, "Processing file for no reason").getExplanation();
    }

    private static enum PreprocessingReason {
        VECTOR_SUPPORT(21, "File was preprocessed as vector drawable support was added in Android 5.0 (API level 21)"),
        GRADIENT_SUPPORT(24, "File was preprocessed as vector drawable gradient support was added in Android 7.0 (API level 24)"),
        FILLTYPE_SUPPORT(24, "File was preprocessed as vector drawable android:filltype support was added in Android 7.0 (API level 24)");

        private final int mSdkThreshold;
        private final String explanation;

        private PreprocessingReason(int sdkThreshold, String explanation) {
            this.mSdkThreshold = sdkThreshold;
            this.explanation = explanation;
        }

        int getSdkThreshold() {
            return this.mSdkThreshold;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }
}

