/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.ChromeTracingProfileConverter;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.PathUtils;
import com.android.utils.StdLogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0006\u0010\u000e\u001a\u00020\nJ0\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J.\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/builder/profile/AnalyticsProfileWriter;", "", "()V", "profileFileName", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "scheduledExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "studioEventFileName", "cleanUpExtraChromeTraceDirectory", "", "profileDir", "Ljava/io/File;", "deInitializedAnalytics", "initializeUsageTracker", "writeAnalytics", "profile", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfile;", "events", "", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "enableChromeTracingOutput", "", "writeAndFinish", "enableProfileJson", "Companion"})
public final class AnalyticsProfileWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final DateTimeFormatter profileFileName = DateTimeFormatter.ofPattern("'profile-'yyyy-MM-dd-HH-mm-ss-SSS'.rawproto'", Locale.US);
    private final DateTimeFormatter studioEventFileName = DateTimeFormatter.ofPattern("'studioEvent-'yyyy-MM-dd-HH-mm-ss-SSS'.trk'", Locale.US);
    @NotNull
    private final ScheduledExecutorService scheduledExecutorService;
    @NotNull
    private static final Object gate = new Object();

    public AnalyticsProfileWriter() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(1)");
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public final void writeAndFinish(@NotNull GradleBuildProfile profile, @NotNull List<AndroidStudioEvent.Builder> events, @Nullable File profileDir, boolean enableProfileJson) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (profileDir == null) {
            this.scheduledExecutorService.submit(new Runnable(this, profile, events, enableProfileJson, profileDir){
                final /* synthetic */ AnalyticsProfileWriter this$0;
                final /* synthetic */ GradleBuildProfile $profile;
                final /* synthetic */ List<AndroidStudioEvent.Builder> $events;
                final /* synthetic */ boolean $enableProfileJson;
                final /* synthetic */ File $profileDir;
                {
                    this.this$0 = $receiver;
                    this.$profile = $profile;
                    this.$events = $events;
                    this.$enableProfileJson = $enableProfileJson;
                    this.$profileDir = $profileDir;
                }

                public final void run() {
                    AnalyticsProfileWriter.access$writeAnalytics(this.this$0, this.$profile, this.$events, this.$enableProfileJson, this.$profileDir);
                }
            });
        } else {
            this.writeAnalytics(profile, events, enableProfileJson, profileDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeAnalytics(GradleBuildProfile profile, List<AndroidStudioEvent.Builder> events, boolean enableChromeTracingOutput, File profileDir) {
        Object object = Companion.getGate();
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            Path path;
            Path studioMetricsFile;
            boolean bl4 = false;
            this.initializeUsageTracker();
            AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE).setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_PROFILE).setGradleBuildProfile(profile).setJavaProcessStats(CommonMetricsData.INSTANCE.getJavaProcessStats()).setJvmDetails(CommonMetricsData.INSTANCE.getJvmDetails());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()\n                    .setCategory(AndroidStudioEvent.EventCategory.GRADLE)\n                    .setKind(AndroidStudioEvent.EventKind.GRADLE_BUILD_PROFILE)\n                    .setGradleBuildProfile(profile)\n                    .setJavaProcessStats(CommonMetricsData.javaProcessStats)\n                    .setJvmDetails(CommonMetricsData.jvmDetails)");
            UsageTracker.log((AndroidStudioEvent.Builder)builder);
            Iterable $this$forEach$iv = events;
            boolean $i$f$forEach22 = false;
            Object object2 = $this$forEach$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                AndroidStudioEvent.Builder it2 = (AndroidStudioEvent.Builder)element$iv;
                boolean bl5 = false;
                UsageTracker.log((AndroidStudioEvent.Builder)it2);
            }
            File $i$f$forEach22 = profileDir;
            Path outputFile = $i$f$forEach22 == null ? null : ((object2 = $i$f$forEach22.toPath()) == null ? null : object2.resolve(this.profileFileName.format(LocalDateTime.now())));
            object2 = profileDir;
            Path path2 = object2 == null ? null : (studioMetricsFile = (path = object2.toPath()) == null ? null : path.resolve(this.studioEventFileName.format(LocalDateTime.now())));
            if (outputFile != null) {
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                object2 = new OpenOption[]{StandardOpenOption.CREATE_NEW};
                object2 = new BufferedOutputStream(Files.newOutputStream(outputFile, object2));
                boolean bl6 = false;
                boolean bl7 = false;
                Throwable throwable = null;
                try {
                    BufferedOutputStream outputStream = (BufferedOutputStream)object2;
                    boolean bl8 = false;
                    profile.writeTo((OutputStream)outputStream);
                    outputStream = Unit.INSTANCE;
                }
                catch (Throwable outputStream) {
                    throwable = outputStream;
                    throw outputStream;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                if (enableChromeTracingOutput) {
                    ChromeTracingProfileConverter.toJson(outputFile);
                }
            }
            if (studioMetricsFile != null) {
                object2 = new OpenOption[]{StandardOpenOption.CREATE_NEW};
                object2 = new BufferedOutputStream(Files.newOutputStream(studioMetricsFile, object2));
                boolean bl9 = false;
                boolean bl10 = false;
                Throwable throwable = null;
                try {
                    BufferedOutputStream outputStream = (BufferedOutputStream)object2;
                    boolean bl11 = false;
                    Iterable $this$forEach$iv2 = events;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        AndroidStudioEvent.Builder it3 = (AndroidStudioEvent.Builder)element$iv;
                        boolean bl12 = false;
                        it3.build().toByteString().writeTo((OutputStream)outputStream);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
            }
            this.deInitializedAnalytics(profileDir);
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void initializeUsageTracker() {
        UsageTracker.initialize((ScheduledExecutorService)this.scheduledExecutorService);
        UsageTracker.setMaxJournalTime((long)10L, (TimeUnit)TimeUnit.MINUTES);
        UsageTracker.setMaxJournalSize((int)1000);
    }

    private final void deInitializedAnalytics(File profileDir) {
        UsageTracker.INSTANCE.deinitialize();
        this.cleanUpExtraChromeTraceDirectory(profileDir);
        this.scheduledExecutorService.shutdown();
    }

    private final void cleanUpExtraChromeTraceDirectory(File profileDir) {
        Path profileDirPath;
        File file = profileDir;
        Path path = profileDirPath = file == null ? null : file.toPath();
        if (profileDirPath != null) {
            Path extraChromeTracePath = profileDirPath.resolve("extra_chrome_trace");
            try {
                PathUtils.deleteRecursivelyIfExists((Path)extraChromeTracePath);
            }
            catch (IOException e12) {
                Object[] objectArray = new Object[]{e12};
                new StdLogger(StdLogger.Level.WARNING).warning("Cannot extra Chrome trace directory " + extraChromeTracePath + ". The generatedChrome trace file may contain stale data.", objectArray);
            }
        }
    }

    public static final /* synthetic */ void access$writeAnalytics(AnalyticsProfileWriter $this, GradleBuildProfile profile, List events, boolean enableChromeTracingOutput, File profileDir) {
        $this.writeAnalytics(profile, events, enableChromeTracingOutput, profileDir);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/builder/profile/AnalyticsProfileWriter$Companion;", "", "()V", "gate", "getGate", "()Ljava/lang/Object;", "profile"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getGate() {
            return gate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

