/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2Daemon;
import com.android.builder.internal.aapt.v2.Aapt2DaemonImpl;
import com.android.builder.internal.aapt.v2.Aapt2DaemonTimeouts;
import com.android.builder.internal.aapt.v2.Aapt2DaemonUtil;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.builder.internal.aapt.v2.Aapt2InternalException;
import com.android.builder.internal.aapt.v2.AaptV2CommandBuilder;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.SettableFuture;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000s\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0015\u0018\u00002\u00020\u0001:\u0004)*+,B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020 2\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010!\u001a\u00020\u001aH\u0014J\b\u0010\"\u001a\u00020\u001aH\u0014J\u001c\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\n\u0010&\u001a\u00060'j\u0002`(H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl;", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "displayId", "", "aaptExecutable", "Ljava/nio/file/Path;", "daemonTimeouts", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonTimeouts;", "logger", "Lcom/android/utils/ILogger;", "(Ljava/lang/String;Ljava/nio/file/Path;Lcom/android/builder/internal/aapt/v2/Aapt2DaemonTimeouts;Lcom/android/utils/ILogger;)V", "aaptPath", "aaptCommand", "", "versionString", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lcom/android/builder/internal/aapt/v2/Aapt2DaemonTimeouts;Lcom/android/utils/ILogger;)V", "noOutputExpected", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$NoOutputExpected;", "process", "Ljava/lang/Process;", "processOutput", "com/android/builder/internal/aapt/v2/Aapt2DaemonImpl$processOutput$1", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$processOutput$1;", "writer", "Ljava/io/Writer;", "doCompile", "", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "doConvert", "Lcom/android/builder/internal/aapt/AaptConvertConfig;", "doLink", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "startProcess", "stopProcess", "stopQuietly", "", "message", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "AllowShutdown", "NoOutputExpected", "WaitForReadyOnStdOut", "WaitForTaskCompletion", "builder"})
public final class Aapt2DaemonImpl
extends Aapt2Daemon {
    @NotNull
    private final String aaptPath;
    @NotNull
    private final List<String> aaptCommand;
    @NotNull
    private final Aapt2DaemonTimeouts daemonTimeouts;
    @NotNull
    private final NoOutputExpected noOutputExpected;
    private Process process;
    private Writer writer;
    @NotNull
    private final processOutput.1 processOutput;

    public Aapt2DaemonImpl(@NotNull String displayId, @NotNull String aaptPath, @NotNull List<String> aaptCommand, @NotNull String versionString, @NotNull Aapt2DaemonTimeouts daemonTimeouts, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
        Intrinsics.checkNotNullParameter((Object)aaptPath, (String)"aaptPath");
        Intrinsics.checkNotNullParameter(aaptCommand, (String)"aaptCommand");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        Intrinsics.checkNotNullParameter((Object)daemonTimeouts, (String)"daemonTimeouts");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super("AAPT2 " + versionString + " Daemon " + displayId, logger);
        this.aaptPath = aaptPath;
        this.aaptCommand = aaptCommand;
        this.daemonTimeouts = daemonTimeouts;
        this.noOutputExpected = new NoOutputExpected(this.getDisplayName(), logger);
        this.processOutput = new GrabProcessOutput.IProcessOutput(this){
            @NotNull
            private volatile GrabProcessOutput.IProcessOutput delegate;
            final /* synthetic */ Aapt2DaemonImpl this$0;
            {
                this.this$0 = $receiver;
                this.delegate = Aapt2DaemonImpl.access$getNoOutputExpected$p(this.this$0);
            }

            @NotNull
            public final GrabProcessOutput.IProcessOutput getDelegate() {
                return this.delegate;
            }

            public final void setDelegate(@NotNull GrabProcessOutput.IProcessOutput iProcessOutput) {
                Intrinsics.checkNotNullParameter((Object)iProcessOutput, (String)"<set-?>");
                this.delegate = iProcessOutput;
            }

            public void out(@Nullable String line) {
                this.delegate.out(line);
            }

            public void err(@Nullable String line) {
                this.delegate.err(line);
            }
        };
    }

    public Aapt2DaemonImpl(@NotNull String displayId, @NotNull Path aaptExecutable, @NotNull Aapt2DaemonTimeouts daemonTimeouts, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)displayId, (String)"displayId");
        Intrinsics.checkNotNullParameter((Object)aaptExecutable, (String)"aaptExecutable");
        Intrinsics.checkNotNullParameter((Object)daemonTimeouts, (String)"daemonTimeouts");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Object[] objectArray = aaptExecutable.toFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"aaptExecutable.toFile().absolutePath");
        Object[] objectArray2 = objectArray;
        objectArray = new String[]{aaptExecutable.toFile().getAbsolutePath(), "m"};
        this(displayId, (String)objectArray2, CollectionsKt.listOf((Object[])objectArray), ((Object)aaptExecutable.getParent().getFileName()).toString(), daemonTimeouts, logger);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void startProcess() throws TimeoutException {
        boolean bl2;
        Object object;
        Object object2;
        WaitForReadyOnStdOut waitForReady = new WaitForReadyOnStdOut(this.getDisplayName(), this.getLogger());
        this.processOutput.setDelegate(waitForReady);
        ProcessBuilder processBuilder = new ProcessBuilder(this.aaptCommand);
        Object object3 = processBuilder.start();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"processBuilder.start()");
        this.process = object3;
        Aapt2DaemonImpl aapt2DaemonImpl = this;
        try {
            Aapt2DaemonImpl aapt2DaemonImpl2 = aapt2DaemonImpl;
            object3 = this.process;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                throw null;
            }
            GrabProcessOutput.grabProcessOutput((Process)object3, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.ASYNC, (GrabProcessOutput.IProcessOutput)this.processOutput);
            object2 = this.process;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                throw null;
            }
            object3 = ((Process)object2).getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"process.outputStream");
            object2 = Charsets.UTF_8;
            boolean bl3 = false;
            object = object3;
            int n12 = 0;
            object = new OutputStreamWriter((OutputStream)object, (Charset)object2);
            n12 = 8192;
            bl2 = false;
            object3 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n12);
        }
        catch (Exception exception) {
            void e12;
            void var5_8 = e12;
            boolean bl4 = false;
            boolean bl5 = false;
            void var8_17 = var5_8;
            boolean bl6 = false;
            try {
                Process process = this.process;
                if (process == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                    throw null;
                }
                process.destroyForcibly();
            }
            catch (Exception suppressed) {
                void $this$startProcess_u24lambda_u2d0;
                ExceptionsKt.addSuppressed((Throwable)((Throwable)$this$startProcess_u24lambda_u2d0), (Throwable)suppressed);
            }
            Unit unit = Unit.INSTANCE;
            Aapt2DaemonImpl aapt2DaemonImpl3 = aapt2DaemonImpl;
            throw (Throwable)var5_8;
        }
        aapt2DaemonImpl2.writer = object3;
        try {
            object2 = (Boolean)waitForReady.getFuture().get(this.daemonTimeouts.getStart(), this.daemonTimeouts.getStartUnit());
        }
        catch (TimeoutException e13) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to start AAPT2 process ").append(this.getDisplayName()).append(". Not ready within ").append(this.daemonTimeouts.getStart()).append(' ');
            object = this.daemonTimeouts.getStartUnit().name();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            bl2 = false;
            Object object4 = object;
            boolean bl7 = false;
            Object object5 = object4;
            if (object5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object5).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
            this.stopQuietly(stringBuilder.append(string).append('.').toString(), e13);
            throw new KotlinNothingValueException();
        }
        catch (Exception e14) {
            this.stopQuietly("Failed to start AAPT2 process.", e14);
            throw new KotlinNothingValueException();
        }
        Object ready = object2;
        if (!((Boolean)ready).booleanValue()) {
            this.stopQuietly("Failed to start AAPT2 process.", new IOException("Process unexpectedly exit."));
            throw new KotlinNothingValueException();
        }
        this.processOutput.setDelegate(this.noOutputExpected);
    }

    private final Void stopQuietly(String message, Exception e12) {
        Aapt2InternalException aapt2InternalException = new Aapt2InternalException(message, e12);
        boolean bl2 = false;
        boolean bl3 = false;
        Aapt2InternalException $this$stopQuietly_u24lambda_u2d1 = aapt2InternalException;
        boolean bl4 = false;
        try {
            this.stopProcess();
        }
        catch (Exception suppressed) {
            ExceptionsKt.addSuppressed((Throwable)$this$stopQuietly_u24lambda_u2d1, (Throwable)suppressed);
        }
        throw (Throwable)aapt2InternalException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCompile(@NotNull CompileResourceRequest request, @NotNull ILogger logger) throws TimeoutException, Aapt2InternalException, Aapt2Exception {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        WaitForTaskCompletion waitForTask = new WaitForTaskCompletion(this.getDisplayName(), logger);
        try {
            Object object;
            block13: {
                Object $this$doCompile_u24lambda_u2d2;
                block14: {
                    this.processOutput.setDelegate(waitForTask);
                    Object object2 = this.writer;
                    if (object2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                        throw null;
                    }
                    Aapt2DaemonUtil.requestCompile((Writer)object2, request);
                    object2 = request.getPartialRFile();
                    if (object2 == null) break block13;
                    object = object2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    $this$doCompile_u24lambda_u2d2 = object;
                    boolean bl4 = false;
                    if (StringsKt.startsWith$default((String)request.getInputDirectoryName(), (String)"raw", (boolean)false, (int)2, null)) break block14;
                    String string = request.getInputFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.inputFile.path");
                    if (StringsKt.endsWith$default((String)string, (String)".xml", (boolean)false, (int)2, null)) break block13;
                }
                String type = StringsKt.substringBefore$default((String)request.getInputDirectoryName(), (char)'-', null, (int)2, null);
                String string = request.getInputFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.inputFile.name");
                String nameWithoutExtension = StringsKt.substringBefore$default((String)string, (char)'.', null, (int)2, null);
                Files.write(((File)$this$doCompile_u24lambda_u2d2).toPath(), (Iterable<? extends CharSequence>)((Iterable)ImmutableList.of((Object)("default int " + type + ' ' + nameWithoutExtension))), new OpenOption[0]);
            }
            WaitForTaskCompletion.Result result = (WaitForTaskCompletion.Result)waitForTask.getFuture().get(this.daemonTimeouts.getCompile(), this.daemonTimeouts.getCompileUnit());
            object = result;
            if (object instanceof WaitForTaskCompletion.Result.Succeeded) {
            } else {
                if (object instanceof WaitForTaskCompletion.Result.Failed) {
                    String args = CollectionsKt.joinToString$default((Iterable)((Iterable)AaptV2CommandBuilder.makeCompileCommand(request)), (CharSequence)" \\\n        ", null, null, (int)0, null, null, (int)62, null);
                    throw Aapt2Exception.Companion.create$default(Aapt2Exception.Companion, logger, "Android resource compilation failed", null, ((WaitForTaskCompletion.Result.Failed)result).getStdErr(), this.getDisplayName(), this.aaptPath + " compile " + args, 4, null);
                }
                if (object instanceof WaitForTaskCompletion.Result.InternalAapt2Error) {
                    throw ((WaitForTaskCompletion.Result.InternalAapt2Error)result).getFailure();
                }
            }
        }
        finally {
            this.processOutput.setDelegate(this.noOutputExpected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doLink(@NotNull AaptPackageConfig request, @NotNull ILogger logger) throws TimeoutException, Aapt2InternalException, Aapt2Exception {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        WaitForTaskCompletion waitForTask = new WaitForTaskCompletion(this.getDisplayName(), logger);
        try {
            WaitForTaskCompletion.Result result;
            this.processOutput.setDelegate(waitForTask);
            Writer writer = this.writer;
            if (writer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                throw null;
            }
            Aapt2DaemonUtil.requestLink(writer, request);
            WaitForTaskCompletion.Result result2 = result = (WaitForTaskCompletion.Result)waitForTask.getFuture().get(this.daemonTimeouts.getLink(), this.daemonTimeouts.getLinkUnit());
            if (result2 instanceof WaitForTaskCompletion.Result.Succeeded) {
            } else {
                if (result2 instanceof WaitForTaskCompletion.Result.Failed) {
                    AaptPackageConfig configWithResourcesListed = request.getIntermediateDir() != null ? AaptPackageConfig.copy$default(request, null, null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, null, false, null, false, null, false, null, true, false, null, null, false, false, false, false, null, null, null, null, null, -8388609, 15, null) : request;
                    String args = CollectionsKt.joinToString$default((Iterable)((Iterable)AaptV2CommandBuilder.makeLinkCommand(configWithResourcesListed)), (CharSequence)"\\\n        ", null, null, (int)0, null, null, (int)62, null);
                    throw Aapt2Exception.Companion.create$default(Aapt2Exception.Companion, logger, "Android resource linking failed", null, ((WaitForTaskCompletion.Result.Failed)result).getStdErr(), this.getDisplayName(), this.aaptPath + " link " + args, 4, null);
                }
                if (result2 instanceof WaitForTaskCompletion.Result.InternalAapt2Error) {
                    throw ((WaitForTaskCompletion.Result.InternalAapt2Error)result).getFailure();
                }
            }
        }
        finally {
            this.processOutput.setDelegate(this.noOutputExpected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doConvert(@NotNull AaptConvertConfig request, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        WaitForTaskCompletion waitForTask = new WaitForTaskCompletion(this.getDisplayName(), logger);
        try {
            WaitForTaskCompletion.Result result;
            this.processOutput.setDelegate(waitForTask);
            Writer writer = this.writer;
            if (writer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                throw null;
            }
            Aapt2DaemonUtil.requestConvert(writer, request);
            WaitForTaskCompletion.Result result2 = result = (WaitForTaskCompletion.Result)waitForTask.getFuture().get(this.daemonTimeouts.getLink(), this.daemonTimeouts.getLinkUnit());
            if (result2 instanceof WaitForTaskCompletion.Result.Succeeded) {
            } else {
                if (result2 instanceof WaitForTaskCompletion.Result.Failed) {
                    String args = CollectionsKt.joinToString$default((Iterable)((Iterable)AaptV2CommandBuilder.makeConvertCommand(request)), (CharSequence)"\\\n        ", null, null, (int)0, null, null, (int)62, null);
                    throw Aapt2Exception.Companion.create$default(Aapt2Exception.Companion, logger, "Android resource linking failed", null, ((WaitForTaskCompletion.Result.Failed)result).getStdErr(), this.getDisplayName(), this.aaptPath + " convert " + args, 4, null);
                }
                if (result2 instanceof WaitForTaskCompletion.Result.InternalAapt2Error) {
                    throw ((WaitForTaskCompletion.Result.InternalAapt2Error)result).getFailure();
                }
            }
        }
        finally {
            this.processOutput.setDelegate(this.noOutputExpected);
        }
    }

    @Override
    protected void stopProcess() throws TimeoutException {
        this.processOutput.setDelegate(new AllowShutdown(this.getDisplayName(), this.getLogger()));
        IOException suppressed = null;
        try {
            Writer writer = this.writer;
            if (writer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                throw null;
            }
            writer.write("quit\n\n");
            writer = this.writer;
            if (writer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"writer");
                throw null;
            }
            writer.flush();
        }
        catch (IOException e12) {
            suppressed = e12;
        }
        Object object = this.process;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"process");
            throw null;
        }
        boolean shutdown = ((Process)object).waitFor(this.daemonTimeouts.getStop(), this.daemonTimeouts.getStopUnit());
        if (shutdown) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append(this.getDisplayName()).append(": Failed to shut down within ").append(this.daemonTimeouts.getStop()).append(' ');
        object = this.daemonTimeouts.getStopUnit().name();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        boolean bl2 = false;
        Object object2 = object;
        boolean bl3 = false;
        Object object3 = object2;
        if (object3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object3).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
        object = new TimeoutException(stringBuilder.append(string).append(". Forcing shutdown").toString());
        boolean bl4 = false;
        bl2 = false;
        Object $this$stopProcess_u24lambda_u2d4 = object;
        boolean bl5 = false;
        Object object4 = suppressed;
        if (object4 != null) {
            Exception exception = object4;
            boolean bl6 = false;
            boolean bl7 = false;
            Exception it2 = exception;
            boolean bl8 = false;
            ExceptionsKt.addSuppressed((Throwable)((Throwable)$this$stopProcess_u24lambda_u2d4), (Throwable)it2);
        }
        try {
            object4 = this.process;
            if (object4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"process");
                throw null;
            }
            ((Process)object4).destroyForcibly();
        }
        catch (Exception suppressed2) {
            ExceptionsKt.addSuppressed((Throwable)((Throwable)$this$stopProcess_u24lambda_u2d4), (Throwable)suppressed2);
        }
        throw (Throwable)object;
    }

    public static final /* synthetic */ NoOutputExpected access$getNoOutputExpected$p(Aapt2DaemonImpl $this) {
        return $this.noOutputExpected;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\f\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$NoOutputExpected;", "Lcom/android/utils/GrabProcessOutput$IProcessOutput;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "getLogger", "()Lcom/android/utils/ILogger;", "err", "", "line", "out", "builder"})
    public static final class NoOutputExpected
    implements GrabProcessOutput.IProcessOutput {
        @NotNull
        private final String displayName;
        @NotNull
        private final ILogger logger;

        public NoOutputExpected(@NotNull String displayName, @NotNull ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.displayName = displayName;
            this.logger = logger;
        }

        @NotNull
        public final ILogger getLogger() {
            return this.logger;
        }

        public void out(@Nullable String line) {
            if (line != null) {
                this.logger.error(null, this.displayName + ": Unexpected standard output: " + line, new Object[0]);
            }
        }

        public void err(@Nullable String line) {
            if (line != null) {
                this.logger.error(null, this.displayName + ": Unexpected error output: " + line, new Object[0]);
            } else {
                this.logger.error(null, Intrinsics.stringPlus((String)this.displayName, (Object)": Idle daemon unexpectedly exit. This should not happen."), new Object[0]);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForReadyOnStdOut;", "Lcom/android/utils/GrabProcessOutput$IProcessOutput;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "future", "Lcom/google/common/util/concurrent/SettableFuture;", "", "getFuture", "()Lcom/google/common/util/concurrent/SettableFuture;", "getLogger", "()Lcom/android/utils/ILogger;", "err", "", "line", "out", "builder"})
    public static final class WaitForReadyOnStdOut
    implements GrabProcessOutput.IProcessOutput {
        @NotNull
        private final String displayName;
        @NotNull
        private final ILogger logger;
        @NotNull
        private final SettableFuture<Boolean> future;

        public WaitForReadyOnStdOut(@NotNull String displayName, @NotNull ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.displayName = displayName;
            this.logger = logger;
            SettableFuture settableFuture = SettableFuture.create();
            Intrinsics.checkNotNullExpressionValue((Object)settableFuture, (String)"create<Boolean>()");
            this.future = settableFuture;
        }

        @NotNull
        public final ILogger getLogger() {
            return this.logger;
        }

        @NotNull
        public final SettableFuture<Boolean> getFuture() {
            return this.future;
        }

        public void out(@Nullable String line) {
            String string = line;
            if (string == null) {
                if (!this.future.isDone()) {
                    this.future.set((Object)false);
                }
            } else {
                if (Intrinsics.areEqual((Object)string, (Object)"")) {
                    return;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"Ready")) {
                    this.future.set((Object)true);
                } else {
                    this.logger.error(null, this.displayName + ": Unexpected error output: " + line, new Object[0]);
                }
            }
        }

        public void err(@Nullable String line) {
            String string = line;
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                boolean bl3 = false;
                String it2 = string2;
                boolean bl4 = false;
                this.getLogger().error(null, this.displayName + ": Unexpected error output: " + it2, new Object[0]);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0017\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion;", "Lcom/android/utils/GrabProcessOutput$IProcessOutput;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "errors", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "foundError", "", "future", "Lcom/google/common/util/concurrent/SettableFuture;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result;", "kotlin.jvm.PlatformType", "getFuture", "()Lcom/google/common/util/concurrent/SettableFuture;", "getLogger", "()Lcom/android/utils/ILogger;", "err", "", "line", "out", "Result", "builder"})
    public static final class WaitForTaskCompletion
    implements GrabProcessOutput.IProcessOutput {
        @NotNull
        private final String displayName;
        @NotNull
        private final ILogger logger;
        @NotNull
        private final SettableFuture<Result> future;
        @Nullable
        private StringBuilder errors;
        private boolean foundError;

        public WaitForTaskCompletion(@NotNull String displayName, @NotNull ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.displayName = displayName;
            this.logger = logger;
            SettableFuture settableFuture = SettableFuture.create();
            Intrinsics.checkNotNull((Object)settableFuture);
            this.future = settableFuture;
        }

        @NotNull
        public final ILogger getLogger() {
            return this.logger;
        }

        @NotNull
        public final SettableFuture<Result> getFuture() {
            return this.future;
        }

        public void out(@Nullable String line) {
            String string = line;
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                boolean bl3 = false;
                String it2 = string2;
                boolean bl4 = false;
                Object[] objectArray = new Object[]{this.displayName, it2};
                this.getLogger().lifecycle("%1$s: %2$s", objectArray);
            }
        }

        public void err(@Nullable String line) {
            String string = line;
            if (string == null) {
                this.foundError = true;
                if (this.errors == null) {
                    this.errors = new StringBuilder();
                }
                this.future.set((Object)new Result.InternalAapt2Error(new IOException(Intrinsics.stringPlus((String)"AAPT2 process unexpectedly exit. Error output:\n", (Object)this.errors))));
            } else if (Intrinsics.areEqual((Object)string, (Object)"Done")) {
                if (this.foundError) {
                    StringBuilder stringBuilder = this.errors;
                    Intrinsics.checkNotNull((Object)stringBuilder);
                    String string2 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"errors!!.toString()");
                    this.future.set((Object)new Result.Failed(string2));
                } else if (this.errors != null) {
                    this.logger.warning(String.valueOf(this.errors), new Object[0]);
                    this.future.set((Object)Result.Succeeded.INSTANCE);
                } else {
                    this.future.set((Object)Result.Succeeded.INSTANCE);
                }
                this.errors = null;
            } else if (Intrinsics.areEqual((Object)string, (Object)"Error")) {
                this.foundError = true;
                if (this.errors == null) {
                    this.errors = new StringBuilder();
                }
            } else {
                if (this.errors == null) {
                    this.errors = new StringBuilder();
                }
                StringBuilder stringBuilder = this.errors;
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.append(line).append('\n');
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result;", "", "()V", "Failed", "InternalAapt2Error", "Succeeded", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$Succeeded;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$Failed;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$InternalAapt2Error;", "builder"})
        public static abstract class Result {
            private Result() {
            }

            public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$Succeeded;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result;", "()V", "builder"})
            public static final class Succeeded
            extends Result {
                @NotNull
                public static final Succeeded INSTANCE = new Succeeded();

                private Succeeded() {
                    super(null);
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$Failed;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result;", "stdErr", "", "(Ljava/lang/String;)V", "getStdErr", "()Ljava/lang/String;", "builder"})
            public static final class Failed
            extends Result {
                @NotNull
                private final String stdErr;

                public Failed(@NotNull String stdErr) {
                    Intrinsics.checkNotNullParameter((Object)stdErr, (String)"stdErr");
                    super(null);
                    this.stdErr = stdErr;
                }

                @NotNull
                public final String getStdErr() {
                    return this.stdErr;
                }
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result$InternalAapt2Error;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$WaitForTaskCompletion$Result;", "failure", "Ljava/io/IOException;", "(Ljava/io/IOException;)V", "getFailure", "()Ljava/io/IOException;", "builder"})
            public static final class InternalAapt2Error
            extends Result {
                @NotNull
                private final IOException failure;

                public InternalAapt2Error(@NotNull IOException failure) {
                    Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
                    super(null);
                    this.failure = failure;
                }

                @NotNull
                public final IOException getFailure() {
                    return this.failure;
                }
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\f\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonImpl$AllowShutdown;", "Lcom/android/utils/GrabProcessOutput$IProcessOutput;", "displayName", "", "logger", "Lcom/android/utils/ILogger;", "(Ljava/lang/String;Lcom/android/utils/ILogger;)V", "getLogger", "()Lcom/android/utils/ILogger;", "err", "", "line", "out", "builder"})
    public static final class AllowShutdown
    implements GrabProcessOutput.IProcessOutput {
        @NotNull
        private final String displayName;
        @NotNull
        private final ILogger logger;

        public AllowShutdown(@NotNull String displayName, @NotNull ILogger logger) {
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.displayName = displayName;
            this.logger = logger;
        }

        @NotNull
        public final ILogger getLogger() {
            return this.logger;
        }

        public void out(@Nullable String line) {
            String string = line;
            if ((string == null ? true : Intrinsics.areEqual((Object)string, (Object)"")) ? true : Intrinsics.areEqual((Object)string, (Object)"Exiting daemon")) {
                return;
            }
            this.logger.error(null, this.displayName + ": Unexpected standard output: " + line, new Object[0]);
        }

        public void err(@Nullable String line) {
            String string = line;
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                boolean bl3 = false;
                String it2 = string2;
                boolean bl4 = false;
                this.getLogger().error(null, this.displayName + ": Unexpected error output: " + line, new Object[0]);
            }
        }
    }
}

