/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchive;
import com.google.common.base.Preconditions;

public final class DexArchiveEntry {
    private final byte[] dexFileContent;
    private final String relativePathInArchive;
    private final DexArchive dexArchive;

    public DexArchiveEntry(byte[] dexFileContent, String relativePathInArchive, DexArchive dexArchive) {
        this.relativePathInArchive = relativePathInArchive;
        this.dexFileContent = dexFileContent;
        this.dexArchive = dexArchive;
    }

    public static String withClassExtension(String dexEntryPath) {
        Preconditions.checkState((boolean)dexEntryPath.endsWith(".dex"), (Object)"Dex archives: setting .CLASS extension only for .DEX files");
        return dexEntryPath.substring(0, dexEntryPath.length() - ".dex".length()) + ".class";
    }

    public byte[] getDexFileContent() {
        return this.dexFileContent;
    }

    public String getRelativePathInArchive() {
        return this.relativePathInArchive;
    }

    public DexArchive getDexArchive() {
        return this.dexArchive;
    }
}

