/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.IncrementalFileMergerOutput;
import com.android.builder.merge.MergeInput;
import com.android.builder.merge.MergeOutputWriter;
import com.android.builder.merge.StreamMergeAlgorithm;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.stream.Collectors;

public final class IncrementalFileMergerOutputs {
    private IncrementalFileMergerOutputs() {
    }

    public static IncrementalFileMergerOutput fromAlgorithmAndWriter(final StreamMergeAlgorithm algorithm, final MergeOutputWriter writer) {
        return new IncrementalFileMergerOutput(){

            @Override
            public void open() {
                writer.open();
            }

            @Override
            public void close() throws IOException {
                writer.close();
            }

            @Override
            public void remove(String path) {
                writer.remove(path);
            }

            @Override
            public void create(String path, List<IncrementalFileMergerInput> inputs, boolean compress) {
                try (Closer closer = Closer.create();){
                    List inStreams = inputs.stream().map(i15 -> new MergeInput(i15.openPath(path), i15.getName())).collect(Collectors.toList());
                    InputStream mergedStream = algorithm.merge(path, (List<MergeInput>)ImmutableList.copyOf(inStreams), closer);
                    writer.create(path, mergedStream, compress);
                }
                catch (IOException e15) {
                    throw new UncheckedIOException(e15);
                }
            }

            @Override
            public void update(String path, List<String> prevInputNames, List<IncrementalFileMergerInput> inputs, boolean compress) {
                try (Closer closer = Closer.create();){
                    List inStreams = inputs.stream().map(i15 -> new MergeInput(i15.openPath(path), i15.getName())).collect(Collectors.toList());
                    InputStream mergedStream = algorithm.merge(path, (List<MergeInput>)ImmutableList.copyOf(inStreams), closer);
                    writer.replace(path, mergedStream, compress);
                }
                catch (IOException e15) {
                    throw new UncheckedIOException(e15);
                }
            }
        };
    }
}

