/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.DirectoryBasedClassFileInput;
import com.android.utils.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

final class FileBasedClassFileEntry
implements ClassFileEntry {
    private final String relativePath;
    private final Path fullPath;
    private final DirectoryBasedClassFileInput input;

    public FileBasedClassFileEntry(Path rootPath, Path fullPath, DirectoryBasedClassFileInput input) {
        this.relativePath = PathUtils.toSystemIndependentPath((Path)rootPath.relativize(fullPath));
        this.fullPath = fullPath;
        this.input = input;
    }

    @Override
    public String name() {
        return this.fullPath.getFileName().toString();
    }

    @Override
    public long getSize() throws IOException {
        return Files.size(this.fullPath);
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public ClassFileInput getInput() {
        return this.input;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return Files.readAllBytes(this.fullPath);
    }

    @Override
    public int readAllBytes(byte[] bytes) throws IOException {
        try (SeekableByteChannel sbc = Files.newByteChannel(this.fullPath, new OpenOption[0]);){
            int n15;
            block13: {
                InputStream in5 = Channels.newInputStream(sbc);
                try {
                    long size = sbc.size();
                    if (size > (long)bytes.length) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    n15 = in5.read(bytes, 0, (int)size);
                    if (in5 == null) break block13;
                }
                catch (Throwable throwable) {
                    if (in5 != null) {
                        try {
                            in5.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in5.close();
            }
            return n15;
        }
    }
}

