/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.ZipEntryList;
import com.android.builder.files.ZipSnapshot;
import com.google.common.hash.Hashing;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/builder/files/ZipSnapshotRepository;", "", "directory", "Ljava/io/File;", "keyFunction", "Lkotlin/Function1;", "", "<init>", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)V", "getLastSnapshotOfZip", "Lcom/android/builder/files/ZipSnapshot;", "file", "takeSnapshotOfZip", "", "removeSnapshotOfZip", "clear", "Companion", "builder"})
@SourceDebugExtension(value={"SMAP\nZipSnapshotRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipSnapshotRepository.kt\ncom/android/builder/files/ZipSnapshotRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class ZipSnapshotRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File directory;
    @NotNull
    private final Function1<File, String> keyFunction;

    @JvmOverloads
    public ZipSnapshotRepository(@NotNull File directory, @NotNull Function1<? super File, String> keyFunction) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(keyFunction, (String)"keyFunction");
        this.directory = directory;
        this.keyFunction = keyFunction;
    }

    public /* synthetic */ ZipSnapshotRepository(File file, Function1 function1, int n15, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n15 & 2) != 0) {
            function1 = (Function1)new Function1<File, String>((Object)Companion){

                public final String invoke(File p05) {
                    Intrinsics.checkNotNullParameter((Object)p05, (String)"p0");
                    return ((Companion)this.receiver).defaultKey(p05);
                }
            };
        }
        this(file, (Function1<? super File, String>)function1);
    }

    @Nullable
    public final ZipSnapshot getLastSnapshotOfZip(@NotNull File file) {
        ZipSnapshot zipSnapshot;
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File it = file2 = new File(this.directory, (String)this.keyFunction.invoke((Object)file));
        boolean bl5 = false;
        File file3 = it.isFile() ? file2 : null;
        if (file3 != null) {
            it = file3;
            boolean bl6 = false;
            ZipEntryList zipEntryList = ZipEntryList.Companion.deserializeFile(it);
            Intrinsics.checkNotNull((Object)zipEntryList);
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            zipSnapshot = new ZipSnapshot(zipEntryList, string);
        } else {
            zipSnapshot = null;
        }
        return zipSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void takeSnapshotOfZip(@NotNull File file) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ZipEntryList zipEntryList = ZipEntryList.Companion.fromZip(file);
        File $this$takeSnapshotOfZip_u24lambda_u244 = file2 = new File(this.directory, (String)this.keyFunction.invoke((Object)file));
        boolean bl5 = false;
        Closeable closeable = new FileOutputStream($this$takeSnapshotOfZip_u24lambda_u244);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl6 = false;
            Closeable closeable2 = fos;
            Object object = Charsets.UTF_8;
            closeable2 = new OutputStreamWriter((OutputStream)closeable2, (Charset)object);
            object = null;
            try {
                OutputStreamWriter it = (OutputStreamWriter)closeable2;
                boolean bl7 = false;
                FilesKt.writeBytes((File)$this$takeSnapshotOfZip_u24lambda_u244, (byte[])zipEntryList.toByteArray());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void removeSnapshotOfZip(@NotNull File file) {
        block1: {
            File file2;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (this.getLastSnapshotOfZip(file) == null) {
                throw new IllegalArgumentException("Trying to remove a snapshot that doesn't exist [" + file + "]");
            }
            File it = file2 = new File(this.directory, (String)this.keyFunction.invoke((Object)file));
            boolean bl5 = false;
            File file3 = it.isFile() ? file2 : null;
            if (file3 == null) break block1;
            file3.delete();
        }
    }

    public final void clear() {
        block1: {
            File[] fileArray;
            File[] fileArray2 = this.directory.listFiles();
            if (fileArray2 == null) break block1;
            for (File it : fileArray = fileArray2) {
                boolean bl5 = false;
                it.delete();
            }
        }
    }

    @JvmOverloads
    public ZipSnapshotRepository(@NotNull File directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this(directory, null, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/android/builder/files/ZipSnapshotRepository$Companion;", "", "<init>", "()V", "defaultKey", "", "file", "Ljava/io/File;", "builder"})
    public static final class Companion {
        private Companion() {
        }

        private final String defaultKey(File file) {
            byte[] sha1Sum = Hashing.murmur3_128().hashString((CharSequence)file.getAbsolutePath(), Charsets.UTF_8).asBytes();
            byte[] byArray = Base64.getEncoder().encode(sha1Sum);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.US_ASCII;
            return StringsKt.replace$default((String)new String(byArray2, charset), (String)"/", (String)"_", (boolean)false, (int)4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

