/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.packaging;

import com.android.utils.PathUtils;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Source;
import com.android.zipflinger.Sources;
import com.android.zipflinger.ZipArchive;
import com.android.zipflinger.ZipSource;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarFlinger
implements Closeable {
    private final ZipArchive zipArchive;
    private final Predicate<String> filter;
    private int compressionLevel = -1;
    public static final Predicate<String> CLASSES_ONLY = archivePath -> archivePath.endsWith(".class");
    public static final Predicate<String> EXCLUDE_CLASSES = archivePath -> !CLASSES_ONLY.test((String)archivePath);

    public static Predicate<String> allIgnoringDuplicateResources() {
        HashSet resources = new HashSet();
        return archivePath -> archivePath.endsWith(".class") || resources.add(archivePath);
    }

    public JarFlinger(Path jarFile) throws IOException {
        this(jarFile, null);
    }

    public JarFlinger(Path jarFile, Predicate<String> filter) throws IOException {
        Files.deleteIfExists(jarFile);
        this.zipArchive = new ZipArchive(jarFile);
        this.filter = filter;
    }

    public void addDirectory(Path directory) throws IOException {
        this.addDirectory(directory, this.filter, null);
    }

    public void addDirectory(Path directory, Predicate<String> filterOverride, Transformer transformer) throws IOException {
        this.addDirectory(directory, filterOverride, transformer, new NoOpRelocator());
    }

    public void addDirectory(final Path directory, final Predicate<String> filterOverride, Transformer transformer, final Relocator relocator) throws IOException {
        final ImmutableSortedMap.Builder candidateFiles = ImmutableSortedMap.naturalOrder();
        final ImmutableSortedSet.Builder foldersEncountered = ImmutableSortedSet.naturalOrder();
        Files.walkFileTree(directory, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                String entryPath = PathUtils.toSystemIndependentPath((Path)directory.relativize(file));
                if (filterOverride != null && !filterOverride.test(entryPath)) {
                    return FileVisitResult.CONTINUE;
                }
                entryPath = relocator.relocate(entryPath);
                candidateFiles.put((Object)entryPath, (Object)file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                String entryPath = PathUtils.toSystemIndependentPath((Path)directory.relativize(dir));
                if (!entryPath.isEmpty()) {
                    foldersEncountered.add((Object)entryPath);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        ImmutableSortedSet sortedDirectories = foldersEncountered.build();
        for (String dirName : sortedDirectories) {
            this.zipArchive.add(Sources.dir((String)relocator.relocate(dirName)));
        }
        ImmutableSortedMap sortedFiles = candidateFiles.build();
        for (Map.Entry entry : sortedFiles.entrySet()) {
            String entryPath = (String)entry.getKey();
            if (transformer != null) {
                BufferedInputStream is4 = new BufferedInputStream(Files.newInputStream((Path)entry.getValue(), new OpenOption[0]));
                try {
                    InputStream is22 = transformer.filter(entryPath, is4);
                    if (is22 == null) continue;
                    Source source = Sources.from((InputStream)is22, (String)entryPath, (int)this.compressionLevel);
                    this.zipArchive.add(source);
                    continue;
                }
                finally {
                    ((InputStream)is4).close();
                    continue;
                }
            }
            Source source = Sources.from((Path)((Path)entry.getValue()), (String)entryPath, (int)this.compressionLevel);
            this.zipArchive.add(source);
        }
    }

    public void addJar(Path file) throws IOException {
        this.addJar(file, this.filter, null);
    }

    public void addJar(InputStream inputJar) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(inputJar);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (this.filter != null && !this.filter.test(name)) continue;
                if (name.contains("../")) {
                    throw new InvalidPathException(name, "Entry name contains invalid characters");
                }
                this.addEntry(entry.getName(), new ByteArrayInputStream(zis.readAllBytes()));
            }
        }
    }

    public void addJar(Path path, Predicate<String> filterOverride, Relocator relocator) throws IOException {
        ZipSource source = new ZipSource(path);
        Map entries = source.entries();
        for (Entry entry : entries.values()) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (filterOverride != null && !filterOverride.test(name)) continue;
            if (relocator != null) {
                name = relocator.relocate(name);
            }
            if (name.contains("../")) {
                throw new InvalidPathException(name, "Entry name contains invalid characters");
            }
            source.select(entry.getName(), name);
        }
        this.zipArchive.add(source);
    }

    public void addFile(String entryPath, Path path) throws IOException {
        Source source = Sources.from((Path)path, (String)entryPath, (int)this.compressionLevel);
        this.zipArchive.add(source);
    }

    public void addEntry(String entryPath, InputStream input) throws IOException {
        Source source = Sources.from((InputStream)input, (String)entryPath, (int)this.compressionLevel);
        this.zipArchive.add(source);
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    public void close() throws IOException {
        this.zipArchive.close();
    }

    public static interface Transformer {
        public InputStream filter(String var1, InputStream var2);
    }

    private static class NoOpRelocator
    implements Relocator {
        private NoOpRelocator() {
        }

        @Override
        public String relocate(String entryPath) {
            return entryPath;
        }
    }

    public static interface Relocator {
        public String relocate(String var1);
    }
}

