/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.symbols;

import com.android.builder.symbols.BytecodeRClassWriterKt;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.RGeneration;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.resources.ResourceType;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aX\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010\u001aZ\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0001\u001a\u0016\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0016\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0018"}, d2={"processLibraryMainSymbolTable", "", "librarySymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "depSymbolTables", "", "mainPackageName", "", "rClassOutputJar", "Ljava/io/File;", "symbolFileOut", "platformSymbols", "nonTransitiveRClass", "", "generateDependencyRClasses", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "finalPackageName", "Ljava/nio/file/Path;", "writeSymbolListWithPackageName", "table", "writer", "Ljava/io/Writer;", "writePublicTxtFile", "builder"})
@JvmName(name="SymbolExportUtils")
public final class SymbolExportUtils {
    public static final void processLibraryMainSymbolTable(@NotNull SymbolTable librarySymbols, @NotNull List<? extends SymbolTable> depSymbolTables, @NotNull String mainPackageName, @Nullable File rClassOutputJar, @Nullable File symbolFileOut, @NotNull SymbolTable platformSymbols, boolean nonTransitiveRClass, boolean generateDependencyRClasses, @NotNull IdProvider idProvider) throws IOException {
        Intrinsics.checkNotNullParameter((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkNotNullParameter(depSymbolTables, (String)"depSymbolTables");
        Intrinsics.checkNotNullParameter((Object)mainPackageName, (String)"mainPackageName");
        Intrinsics.checkNotNullParameter((Object)platformSymbols, (String)"platformSymbols");
        Intrinsics.checkNotNullParameter((Object)idProvider, (String)"idProvider");
        File file = symbolFileOut;
        List<SymbolTable> tablesToWrite = SymbolExportUtils.processLibraryMainSymbolTable(mainPackageName, librarySymbols, depSymbolTables, platformSymbols, nonTransitiveRClass, file != null ? file.toPath() : null, generateDependencyRClasses, idProvider);
        if (rClassOutputJar != null) {
            FileUtils.deleteIfExists((File)rClassOutputJar);
            Iterable iterable = tablesToWrite;
            Path path = rClassOutputJar.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            BytecodeRClassWriterKt.exportToCompiledJava$default(iterable, path, false, null, null, 28, null);
        }
    }

    @VisibleForTesting
    @NotNull
    public static final List<SymbolTable> processLibraryMainSymbolTable(@NotNull String finalPackageName, @NotNull SymbolTable librarySymbols, @NotNull List<? extends SymbolTable> depSymbolTables, @NotNull SymbolTable platformSymbols, boolean nonTransitiveRClass, @Nullable Path symbolFileOut, boolean generateDependencyRClasses, @NotNull IdProvider idProvider) {
        List list;
        Intrinsics.checkNotNullParameter((Object)finalPackageName, (String)"finalPackageName");
        Intrinsics.checkNotNullParameter((Object)librarySymbols, (String)"librarySymbols");
        Intrinsics.checkNotNullParameter(depSymbolTables, (String)"depSymbolTables");
        Intrinsics.checkNotNullParameter((Object)platformSymbols, (String)"platformSymbols");
        Intrinsics.checkNotNullParameter((Object)idProvider, (String)"idProvider");
        SymbolTable allSymbols = SymbolUtils.mergeAndRenumberSymbols((String)finalPackageName, (SymbolTable)librarySymbols, (Collection)depSymbolTables, (SymbolTable)platformSymbols, (IdProvider)idProvider);
        SymbolTable mainSymbolTable = nonTransitiveRClass ? allSymbols.filter(librarySymbols) : allSymbols;
        Path path = symbolFileOut;
        if (path != null) {
            Path it = path;
            boolean bl5 = false;
            Files.createDirectories(it.getParent(), new FileAttribute[0]);
            SymbolIo.writeForAar((SymbolTable)mainSymbolTable, (Path)it);
        }
        if (generateDependencyRClasses) {
            List list2 = RGeneration.generateAllSymbolTablesToWrite((SymbolTable)allSymbols, (SymbolTable)mainSymbolTable, (Collection)depSymbolTables);
            Intrinsics.checkNotNull((Object)list2);
            list = list2;
        } else {
            ImmutableList immutableList = ImmutableList.of((Object)mainSymbolTable);
            Intrinsics.checkNotNull((Object)immutableList);
            list = (List)immutableList;
        }
        return list;
    }

    public static /* synthetic */ List processLibraryMainSymbolTable$default(String string, SymbolTable symbolTable, List list, SymbolTable symbolTable2, boolean bl5, Path path, boolean bl6, IdProvider idProvider, int n15, Object object) {
        if ((n15 & 0x40) != 0) {
            bl6 = true;
        }
        if ((n15 & 0x80) != 0) {
            idProvider = IdProvider.Companion.sequential();
        }
        return SymbolExportUtils.processLibraryMainSymbolTable(string, symbolTable, list, symbolTable2, bl5, path, bl6, idProvider);
    }

    public static final void writeSymbolListWithPackageName(@NotNull SymbolTable table, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.write(table.getTablePackage());
        writer.write(10);
        for (ResourceType resourceType : ResourceType.values()) {
            List symbols = table.getSymbolByResourceType(resourceType);
            for (Symbol symbol : symbols) {
                writer.write(resourceType.getName());
                writer.write(32);
                writer.write(symbol.getCanonicalName());
                if (symbol instanceof Symbol.StyleableSymbol) {
                    UnmodifiableIterator unmodifiableIterator;
                    Intrinsics.checkNotNullExpressionValue((Object)symbol.getChildren().iterator(), (String)"iterator(...)");
                    while (unmodifiableIterator.hasNext()) {
                        String child = (String)unmodifiableIterator.next();
                        writer.write(32);
                        writer.write(child);
                    }
                }
                writer.write(10);
            }
        }
    }

    public static final void writePublicTxtFile(@NotNull SymbolTable table, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        for (ResourceType resType : ResourceType.values()) {
            List symbols = table.getSymbolByResourceType(resType);
            for (Symbol s15 : symbols) {
                writer.write(s15.getResourceType().getName());
                writer.write(32);
                writer.write(s15.getCanonicalName());
                writer.write(10);
            }
        }
    }
}

