/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.files;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.utils.AbiUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DirectoryNameTokenizer {
    private static final String STANDARD_QUALIFIER_REGEX = "[$]?[a-z0-9_]+";
    private final Pattern qualifierPattern;

    public static DirectoryNameTokenizer forAssets() {
        return new DirectoryNameTokenizer();
    }

    public static DirectoryNameTokenizer forNativeLibraries() {
        return new DirectoryNameTokenizer(DirectoryNameTokenizer.createRegexFromLiterals(AbiUtils.ABI_NAMES));
    }

    public static DirectoryNameTokenizer forResources() {
        return new DirectoryNameTokenizer(DirectoryNameTokenizer.joinRegexes("mcc[0-9]+-mnc[0-9]+", "[a-z]{2}-r[A-Z]{2}"));
    }

    DirectoryNameTokenizer() {
        this.qualifierPattern = DirectoryNameTokenizer.compilePatternFromRegex(STANDARD_QUALIFIER_REGEX);
    }

    DirectoryNameTokenizer(String specialTokenRegex) {
        Preconditions.checkArgument((!specialTokenRegex.isEmpty() ? 1 : 0) != 0, (Object)"The regex cannot be empty");
        this.qualifierPattern = DirectoryNameTokenizer.compilePatternFromRegex(DirectoryNameTokenizer.joinRegexes(specialTokenRegex, STANDARD_QUALIFIER_REGEX));
    }

    public ImmutableList<String> tokenize(String input) {
        Preconditions.checkArgument((!input.isEmpty() ? 1 : 0) != 0, (Object)"input cannot be empty");
        ImmutableList.Builder result = ImmutableList.builder();
        int pos = 0;
        while (pos < input.length()) {
            String match;
            if ((pos += (match = DirectoryNameTokenizer.matchOrFail(this.qualifierPattern, input, pos)).length()) < input.length()) {
                ++pos;
            }
            result.add((Object)match);
        }
        return result.build();
    }

    private static String matchOrFail(Pattern pattern, String input, int pos) {
        Matcher matcher = pattern.matcher(input);
        if (matcher.find(pos) && matcher.start() == pos) {
            return matcher.group();
        }
        throw new ValidationException("Cannot tokenize directory '%s' at position %d: '%s'", input, pos, input.substring(pos));
    }

    private static String createRegexFromLiterals(Collection<String> literals) {
        return DirectoryNameTokenizer.joinRegexes((Collection)literals.stream().sorted(Comparator.reverseOrder()).map(Pattern::quote).collect(ImmutableList.toImmutableList()));
    }

    private static Pattern compilePatternFromRegex(String regex) {
        return Pattern.compile("(" + regex + ")" + "($|(?=-.))", 2);
    }

    private static String joinRegexes(String ... regexes) {
        return DirectoryNameTokenizer.joinRegexes(Arrays.asList(regexes));
    }

    private static String joinRegexes(Collection<String> regexes) {
        return regexes.stream().map(regex -> "(" + regex + ")").collect(Collectors.joining("|"));
    }
}

