/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.manifest;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.manifest.ProtoXmlHelper;
import com.google.common.base.Preconditions;

public class ManifestEditor {
    public static final int OPEN_GL_VERSION_MULTIPLIER = 65536;
    public static final int HAS_CODE_RESOURCE_ID = 0x101000C;
    public static final int MIN_SDK_VERSION_RESOURCE_ID = 16843276;
    public static final int MAX_SDK_VERSION_RESOURCE_ID = 16843377;
    private final Resources.XmlNode.Builder rootNodeBuilder;

    public ManifestEditor(Resources.XmlNode rootNode) {
        this.rootNodeBuilder = rootNode.toBuilder();
    }

    public ManifestEditor setMinSdkVersion(int minSdkVersion) {
        return this.setUsesSdkAttribute("minSdkVersion", minSdkVersion, 16843276);
    }

    public ManifestEditor setMaxSdkVersion(int maxSdkVersion) {
        return this.setUsesSdkAttribute("maxSdkVersion", maxSdkVersion, 16843377);
    }

    public ManifestEditor setSplitIdForFeatureSplit(String splitId) {
        Resources.XmlElement.Builder manifestBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "manifest");
        if (ManifestEditor.isBaseSplit(splitId)) {
            ProtoXmlHelper.removeAttribute(manifestBuilder, "", "split");
        } else {
            Resources.XmlAttribute.Builder splitAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "split");
            splitAttributeBuilder.setValue(splitId);
        }
        ProtoXmlHelper.removeAttribute(manifestBuilder, "", "configForSplit");
        Resources.XmlAttribute.Builder isFeatureSplitAttribute = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "http://schemas.android.com/apk/res/android", "isFeatureSplit");
        ProtoXmlHelper.setAttributeValueAsBoolean(isFeatureSplitAttribute, true);
        return this;
    }

    public ManifestEditor setSplitIdForConfigSplit(String splitId, String featureSplitId) {
        Preconditions.checkArgument((!splitId.isEmpty() ? 1 : 0) != 0, (Object)"SplitId cannot be empty for config split!");
        Resources.XmlElement.Builder manifestBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "manifest");
        ProtoXmlHelper.removeAttribute(manifestBuilder, "", "dynamic");
        Resources.XmlAttribute.Builder splitAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "split");
        splitAttributeBuilder.setValue(splitId);
        ProtoXmlHelper.removeAttribute(manifestBuilder, "http://schemas.android.com/apk/res/android", "isFeatureSplit");
        if (!featureSplitId.isEmpty()) {
            Resources.XmlAttribute.Builder featureSplitAttributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(manifestBuilder, "configForSplit");
            featureSplitAttributeBuilder.setValue(featureSplitId);
        }
        Resources.XmlElement.Builder applicationBuilder = ProtoXmlHelper.getExactlyOneElementBuilder(this.rootNodeBuilder, "application");
        Resources.XmlAttribute.Builder hasCodeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(applicationBuilder, "http://schemas.android.com/apk/res/android", "hasCode");
        hasCodeBuilder.setResourceId(0x101000C);
        ProtoXmlHelper.setAttributeValueAsBoolean(hasCodeBuilder, false);
        return this;
    }

    public AndroidManifest save() {
        return AndroidManifest.create(this.rootNodeBuilder.build());
    }

    private ManifestEditor setUsesSdkAttribute(String attributeName, int value, int resourceId) {
        Resources.XmlElement.Builder usesSdk = ProtoXmlHelper.getFirstOrCreateElementBuilder(this.rootNodeBuilder, "uses-sdk");
        Resources.XmlAttribute.Builder attributeBuilder = ProtoXmlHelper.findOrCreateAttributeBuilder(usesSdk, "http://schemas.android.com/apk/res/android", attributeName);
        attributeBuilder.setResourceId(resourceId);
        ProtoXmlHelper.setAttributeValueAsDecimalInteger(attributeBuilder, value);
        return this;
    }

    private static boolean isBaseSplit(String splitId) {
        return splitId.isEmpty();
    }
}

