/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.AutoValue_ModuleZipEntry;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@AutoValue
public abstract class ModuleZipEntry
implements ModuleEntry {
    abstract ZipEntry getZipEntry();

    abstract ZipFile getZipFile();

    abstract int getPathNamesToSkip();

    @Override
    public InputStream getContent() {
        try {
            return this.getZipFile().getInputStream(this.getZipEntry());
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "I/O error during retrieving the zip entry: '%s'", this.getZipEntry().getName());
        }
    }

    @Override
    public Path getPath() {
        Path path = Paths.get(this.getZipEntry().getName(), new String[0]);
        return path.subpath(this.getPathNamesToSkip(), path.getNameCount());
    }

    @Override
    public boolean isDirectory() {
        return this.getZipEntry().isDirectory();
    }

    public static ModuleZipEntry fromBundleZipEntry(ZipEntry zipEntry, ZipFile zipFile) {
        return ModuleZipEntry.create(zipEntry, zipFile, 1);
    }

    public static ModuleZipEntry fromModuleZipEntry(ZipEntry zipEntry, ZipFile zipFile) {
        return ModuleZipEntry.create(zipEntry, zipFile, 0);
    }

    private static ModuleZipEntry create(ZipEntry zipEntry, ZipFile zipFile, int pathNamesToSkip) {
        Preconditions.checkArgument((Paths.get(zipEntry.getName(), new String[0]).getNameCount() > pathNamesToSkip ? 1 : 0) != 0);
        return new AutoValue_ModuleZipEntry(zipEntry, zipFile, pathNamesToSkip);
    }
}

