/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils;

import com.android.aapt.Resources;
import com.android.bundle.Targeting;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.stream.Stream;

public class ResourcesUtils {
    public static final ImmutableBiMap<String, Targeting.ScreenDensity.DensityAlias> SCREEN_DENSITY_TO_PROTO_VALUE_MAP = ImmutableBiMap.builder().put((Object)"nodpi", (Object)Targeting.ScreenDensity.DensityAlias.NODPI).put((Object)"default", (Object)Targeting.ScreenDensity.DensityAlias.DENSITY_UNSPECIFIED).put((Object)"ldpi", (Object)Targeting.ScreenDensity.DensityAlias.LDPI).put((Object)"mdpi", (Object)Targeting.ScreenDensity.DensityAlias.MDPI).put((Object)"tvdpi", (Object)Targeting.ScreenDensity.DensityAlias.TVDPI).put((Object)"hdpi", (Object)Targeting.ScreenDensity.DensityAlias.HDPI).put((Object)"xhdpi", (Object)Targeting.ScreenDensity.DensityAlias.XHDPI).put((Object)"xxhdpi", (Object)Targeting.ScreenDensity.DensityAlias.XXHDPI).put((Object)"xxxhdpi", (Object)Targeting.ScreenDensity.DensityAlias.XXXHDPI).build();
    public static final int DEFAULT_DENSITY_VALUE = 0;
    public static final int LDPI_VALUE = 120;
    public static final int MDPI_VALUE = 160;
    public static final int TVDPI_VALUE = 213;
    public static final int HDPI_VALUE = 240;
    public static final int XHDPI_VALUE = 320;
    public static final int XXHDPI_VALUE = 480;
    public static final int XXXHDPI_VALUE = 640;
    public static final int ANY_DENSITY_VALUE = 65534;
    public static final int NONE_DENSITY_VALUE = 65535;
    public static final String MIPMAP_TYPE = "mipmap";
    public static final ImmutableMap<Targeting.ScreenDensity.DensityAlias, Integer> DENSITY_ALIAS_TO_DPI_MAP = ImmutableMap.builder().put((Object)Targeting.ScreenDensity.DensityAlias.NODPI, (Object)65535).put((Object)Targeting.ScreenDensity.DensityAlias.DENSITY_UNSPECIFIED, (Object)0).put((Object)Targeting.ScreenDensity.DensityAlias.LDPI, (Object)120).put((Object)Targeting.ScreenDensity.DensityAlias.MDPI, (Object)160).put((Object)Targeting.ScreenDensity.DensityAlias.TVDPI, (Object)213).put((Object)Targeting.ScreenDensity.DensityAlias.HDPI, (Object)240).put((Object)Targeting.ScreenDensity.DensityAlias.XHDPI, (Object)320).put((Object)Targeting.ScreenDensity.DensityAlias.XXHDPI, (Object)480).put((Object)Targeting.ScreenDensity.DensityAlias.XXXHDPI, (Object)640).build();

    public static Stream<Resources.Entry> entries(Resources.ResourceTable resourceTable) {
        return resourceTable.getPackageList().stream().map(Resources.Package::getTypeList).flatMap(Collection::stream).map(Resources.Type::getEntryList).flatMap(Collection::stream);
    }

    public static Stream<Resources.ConfigValue> configValues(Resources.ResourceTable resourceTable) {
        return ResourcesUtils.entries(resourceTable).map(Resources.Entry::getConfigValueList).flatMap(Collection::stream);
    }

    public static ImmutableSet<Path> getAllFileReferences(Resources.ResourceTable resourceTable) {
        return (ImmutableSet)ResourcesUtils.configValues(resourceTable).filter(configValue -> configValue.getValue().getItem().hasFile()).map(configValue -> Paths.get(configValue.getValue().getItem().getFile().getPath(), new String[0])).collect(ImmutableSet.toImmutableSet());
    }

    private ResourcesUtils() {
    }
}

