/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.files;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.utils.AbiUtils;
import com.google.common.base.Preconditions;
import java.util.Collection;

public class TargetingGenerator {
    private static final String ASSETS_DIR = "assets/";
    private static final String LIB_DIR = "lib/";

    public Files.Assets generateTargetingForAssets(Collection<String> assetDirectories) {
        for (String directory : assetDirectories) {
            TargetingGenerator.checkRootDirectoryName(ASSETS_DIR, directory);
        }
        return Files.Assets.getDefaultInstance();
    }

    public Files.NativeLibraries generateTargetingForNativeLibraries(Collection<String> libDirectories) {
        Files.NativeLibraries.Builder nativeLibraries = Files.NativeLibraries.newBuilder();
        for (String directory : libDirectories) {
            TargetingGenerator.checkRootDirectoryName(LIB_DIR, directory);
            String abiName = directory.substring(LIB_DIR.length());
            Targeting.Abi abi = TargetingGenerator.checkAbiName(abiName, directory);
            nativeLibraries.addDirectory(Files.TargetedNativeDirectory.newBuilder().setPath(directory).setTargeting(Targeting.NativeDirectoryTargeting.newBuilder().setAbi(abi)).build());
        }
        return nativeLibraries.build();
    }

    private static String checkRootDirectoryName(String rootName, String forDirectory) {
        Preconditions.checkArgument((boolean)rootName.endsWith("/"), (String)"'%s' does not end with '/'.", (Object)rootName);
        Preconditions.checkArgument((boolean)forDirectory.startsWith(rootName), (String)"Directory '%s' must start with '%s'.", (Object)forDirectory, (Object)rootName);
        return rootName;
    }

    private static Targeting.Abi checkAbiName(String token, String forDirectory) {
        Targeting.Abi.AbiAlias abiAlias = (Targeting.Abi.AbiAlias)((Object)AbiUtils.ABI_NAME_TO_PROTO_VALUE_MAP.get((Object)token));
        if (abiAlias == null) {
            if (AbiUtils.ABI_NAME_TO_PROTO_VALUE_MAP.containsKey((Object)token.toLowerCase())) {
                throw new ValidationException("Expecting ABI name in directory '%s', but found '%s' which is not recognized. Did you mean '%s'?", forDirectory, token, token.toLowerCase());
            }
            throw new ValidationException("Expecting ABI name in directory '%s', but found '%s' which is not recognized.", forDirectory, token);
        }
        return Targeting.Abi.newBuilder().setAlias(abiAlias).build();
    }
}

