/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.zip;

import com.android.tools.build.bundletool.utils.zip.OutputBuilder;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipBuilder
extends OutputBuilder {
    @Override
    public Path writeTo(Path target) throws IOException {
        Path tempFile = Files.createTempFile("ZipBuilder-", ".zip.tmp", new FileAttribute[0]);
        try {
            try (ZipOutputStream outZip = new ZipOutputStream(new FileOutputStream(tempFile.toFile()));){
                for (Path path : this.entries.keySet()) {
                    ZipEntry zipEntry;
                    OutputBuilder.Entry entry = (OutputBuilder.Entry)this.entries.get(path);
                    OutputBuilder.InputStreamSupplier inputStreamSupplier = entry.getIsDirectory() ? () -> new ByteArrayInputStream(new byte[0]) : entry.getInputStreamSupplier().get();
                    if (entry.getIsDirectory()) {
                        zipEntry = new ZipEntry(path + "/");
                    } else {
                        zipEntry = new ZipEntry(path.toString());
                        if (entry.hasOption(OutputBuilder.EntryOption.UNCOMPRESSED)) {
                            zipEntry.setMethod(0);
                            byte[] entryData = ByteStreams.toByteArray((InputStream)entry.getInputStreamSupplier().get().get());
                            zipEntry.setSize(entryData.length);
                            zipEntry.setCompressedSize(entryData.length);
                            zipEntry.setCrc(ZipBuilder.computeCrc32(entryData));
                        }
                    }
                    InputStream content = inputStreamSupplier.get();
                    Throwable throwable = null;
                    try {
                        outZip.putNextEntry(zipEntry);
                        ByteStreams.copy((InputStream)content, (OutputStream)outZip);
                        outZip.closeEntry();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (content == null) continue;
                        if (throwable != null) {
                            try {
                                content.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        content.close();
                    }
                }
            }
            Files.move(tempFile, target, new CopyOption[0]);
        }
        catch (IOException e) {
            Files.deleteIfExists(tempFile);
            throw e;
        }
        return target;
    }

    private static long computeCrc32(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return crc32.getValue();
    }
}

