/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.zip;

import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtils {
    public static Stream<Path> getFilesWithPathPrefix(ZipFile zipFile, Path prefix) {
        return ZipUtils.getStreamOfEntriesWithPathPrefix(zipFile, prefix).map(ZipEntry::getName).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public static ImmutableList<ZipEntry> getEntriesWithPathPrefix(ZipFile zipFile, Path prefix) {
        return (ImmutableList)ZipUtils.getStreamOfEntriesWithPathPrefix(zipFile, prefix).collect(ImmutableList.toImmutableList());
    }

    private static Stream<? extends ZipEntry> getStreamOfEntriesWithPathPrefix(ZipFile zipFile, Path prefix) {
        return zipFile.stream().filter(entry -> !entry.isDirectory() && Paths.get(entry.getName(), new String[0]).startsWith(prefix));
    }

    private ZipUtils() {
    }
}

