/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.AutoValue_ManifestDeliveryElement;
import com.android.tools.build.bundletool.model.DeviceFeatureCondition;
import com.android.tools.build.bundletool.model.ModuleConditions;
import com.android.tools.build.bundletool.model.UserCountriesCondition;
import com.android.tools.build.bundletool.model.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Immutable
@AutoValue
public abstract class ManifestDeliveryElement {
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final ImmutableList<String> ALLOWED_DELIVERY_MODES = ImmutableList.of((Object)"install-time", (Object)"on-demand");
    private static final ImmutableList<String> CONDITIONS_ALLOWED_ONLY_ONCE = ImmutableList.of((Object)"min-sdk", (Object)"user-countries");

    abstract XmlProtoElement getDeliveryElement();

    public boolean isWellFormed() {
        return this.hasOnDemandElement() || this.hasInstallTimeElement();
    }

    public boolean hasModuleConditions() {
        return !this.getModuleConditions().isEmpty();
    }

    public boolean hasOnDemandElement() {
        return this.getDeliveryElement().getOptionalChildElement("http://schemas.android.com/apk/distribution", "on-demand").isPresent();
    }

    public boolean hasInstallTimeElement() {
        return this.getDeliveryElement().getOptionalChildElement("http://schemas.android.com/apk/distribution", "install-time").isPresent();
    }

    public ModuleConditions getModuleConditions() {
        ImmutableList<XmlProtoElement> conditionElements = this.getModuleConditionElements();
        Map<String, Long> conditionCounts = conditionElements.stream().collect(Collectors.groupingBy(rec$ -> ((XmlProtoElement)rec$).getName(), Collectors.counting()));
        for (String conditionName : CONDITIONS_ALLOWED_ONLY_ONCE) {
            if (conditionCounts.getOrDefault(conditionName, 0L) <= 1L) continue;
            throw ValidationException.builder().withMessage("Multiple '<dist:%s>' conditions are not supported.", conditionName).build();
        }
        ModuleConditions.Builder moduleConditions = ModuleConditions.builder();
        block11: for (XmlProtoElement conditionElement : conditionElements) {
            if (!conditionElement.getNamespaceUri().equals("http://schemas.android.com/apk/distribution")) {
                throw ValidationException.builder().withMessage("Invalid namespace found in the module condition element. Expected '%s'; found '%s'.", "http://schemas.android.com/apk/distribution", conditionElement.getNamespaceUri()).build();
            }
            switch (conditionElement.getName()) {
                case "device-feature": {
                    moduleConditions.addDeviceFeatureCondition(this.parseDeviceFeatureCondition(conditionElement));
                    continue block11;
                }
                case "min-sdk": {
                    moduleConditions.setMinSdkVersion(this.parseMinSdkVersionCondition(conditionElement));
                    continue block11;
                }
                case "user-countries": {
                    moduleConditions.setUserCountriesCondition(this.parseUserCountriesCondition(conditionElement));
                    continue block11;
                }
            }
            throw new ValidationException(String.format("Unrecognized module condition: '%s'", conditionElement.getName()));
        }
        return moduleConditions.build();
    }

    private UserCountriesCondition parseUserCountriesCondition(XmlProtoElement conditionElement) {
        ImmutableList.Builder countryCodes = ImmutableList.builder();
        for (XmlProtoElement countryElement : (ImmutableList)conditionElement.getChildrenElements().collect(ImmutableList.toImmutableList())) {
            if (!countryElement.getName().equals("country")) {
                throw ValidationException.builder().withMessage("Expected only <dist:country> elements inside <dist:user-countries>, but found %s", ManifestDeliveryElement.printElement(conditionElement)).build();
            }
            countryCodes.add((Object)countryElement.getAttribute("http://schemas.android.com/apk/distribution", "code").map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsString()).map(String::toUpperCase).orElseThrow(() -> ValidationException.builder().withMessage("<dist:country> element is expected to have 'dist:code' attribute but found none.").build()));
        }
        boolean exclude = conditionElement.getAttribute("http://schemas.android.com/apk/distribution", "exclude").map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsBoolean()).orElse(false);
        return UserCountriesCondition.create((ImmutableList<String>)countryCodes.build(), exclude);
    }

    private static void validateDeliveryElement(XmlProtoElement deliveryElement) {
        ManifestDeliveryElement.validateDeliveryElementChildren(deliveryElement);
        ManifestDeliveryElement.validateInstallTimeElement(deliveryElement.getOptionalChildElement("http://schemas.android.com/apk/distribution", "install-time"));
        ManifestDeliveryElement.validateOnDemandElement(deliveryElement.getOptionalChildElement("http://schemas.android.com/apk/distribution", "on-demand"));
    }

    private static void validateDeliveryElementChildren(XmlProtoElement deliveryElement) {
        Optional offendingElement = deliveryElement.getChildrenElements(child -> !child.getNamespaceUri().equals("http://schemas.android.com/apk/distribution") || !ALLOWED_DELIVERY_MODES.contains((Object)child.getName())).findAny();
        if (offendingElement.isPresent()) {
            throw ValidationException.builder().withMessage("Expected <dist:delivery> element to contain only <dist:install-time> or <dist:on-demand> elements but found: %s", ManifestDeliveryElement.printElement((XmlProtoElement)offendingElement.get())).build();
        }
    }

    private static void validateInstallTimeElement(Optional<XmlProtoElement> installTimeElement) {
        Optional offendingElement = installTimeElement.flatMap(installTime -> installTime.getChildrenElements(child -> !child.getNamespaceUri().equals("http://schemas.android.com/apk/distribution") || !child.getName().equals("conditions")).findAny());
        if (offendingElement.isPresent()) {
            throw ValidationException.builder().withMessage("Expected <dist:install-time> element to contain only <dist:conditions> element but found: %s.", ManifestDeliveryElement.printElement((XmlProtoElement)offendingElement.get())).build();
        }
    }

    private static void validateOnDemandElement(Optional<XmlProtoElement> onDemandElement) {
        Optional offendingChild = onDemandElement.flatMap(element -> element.getChildrenElements().findAny());
        if (offendingChild.isPresent()) {
            throw ValidationException.builder().withMessage("Expected <dist:on-demand> element to have no child elements but found: %s.", ManifestDeliveryElement.printElement((XmlProtoElement)offendingChild.get())).build();
        }
    }

    private ImmutableList<XmlProtoElement> getModuleConditionElements() {
        Optional installTimeElement = this.getDeliveryElement().getOptionalChildElement("http://schemas.android.com/apk/distribution", "install-time");
        return installTimeElement.flatMap(installTime -> installTime.getOptionalChildElement("http://schemas.android.com/apk/distribution", "conditions")).map(conditions -> (ImmutableList)conditions.getChildrenElements().collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
    }

    private DeviceFeatureCondition parseDeviceFeatureCondition(XmlProtoElement conditionElement) {
        return DeviceFeatureCondition.create(((XmlProtoAttribute)conditionElement.getAttribute("http://schemas.android.com/apk/distribution", "name").orElseThrow(() -> new ValidationException("Missing required 'dist:name' attribute in the 'device-feature' condition element."))).getValueAsString(), conditionElement.getAttribute("http://schemas.android.com/apk/distribution", VERSION_ATTRIBUTE_NAME).map(rec$ -> ((XmlProtoAttribute)rec$).getValueAsInteger()));
    }

    private int parseMinSdkVersionCondition(XmlProtoElement conditionElement) {
        return ((XmlProtoAttribute)conditionElement.getAttribute("http://schemas.android.com/apk/distribution", "value").orElseThrow(() -> new ValidationException("Missing required 'dist:value' attribute in the 'min-sdk' condition element."))).getValueAsDecimalInteger();
    }

    private static String printElement(XmlProtoElement element) {
        if (element.getNamespaceUri().isEmpty()) {
            return String.format("'%s' with namespace not provided", element.getName());
        }
        return String.format("'%s' with namespace URI: '%s'", element.getName(), element.getNamespaceUri());
    }

    public static Optional<ManifestDeliveryElement> fromManifestElement(XmlProtoElement manifestElement) {
        return ManifestDeliveryElement.fromManifestElement(manifestElement, "delivery");
    }

    public static Optional<ManifestDeliveryElement> instantFromManifestElement(XmlProtoElement manifestElement) {
        return ManifestDeliveryElement.fromManifestElement(manifestElement, "instant-delivery");
    }

    private static Optional<ManifestDeliveryElement> fromManifestElement(XmlProtoElement manifestElement, String deliveryTag) {
        return manifestElement.getOptionalChildElement("http://schemas.android.com/apk/distribution", "module").flatMap(elem -> elem.getOptionalChildElement("http://schemas.android.com/apk/distribution", deliveryTag)).map(elem -> {
            ManifestDeliveryElement.validateDeliveryElement(elem);
            return new AutoValue_ManifestDeliveryElement((XmlProtoElement)elem);
        });
    }

    @VisibleForTesting
    static Optional<ManifestDeliveryElement> fromManifestRootNode(Resources.XmlNode xmlNode) {
        return ManifestDeliveryElement.fromManifestElement((XmlProtoElement)new XmlProtoNode(xmlNode).getElement());
    }

    @VisibleForTesting
    static Optional<ManifestDeliveryElement> instantFromManifestRootNode(Resources.XmlNode xmlNode) {
        return ManifestDeliveryElement.instantFromManifestElement((XmlProtoElement)new XmlProtoNode(xmlNode).getElement());
    }
}

