/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.IOExceptionDiagnostic;

public interface UsageInformationConsumer {
    public void acceptUsageInformation(byte[] var1, DiagnosticsHandler var2);

    public static EmptyConsumer emptyConsumer() {
        return EmptyConsumer.EMPTY_CONSUMER;
    }

    public static class StreamConsumer
    extends ForwardingConsumer {
        private final Origin origin;
        private final OutputStream outputStream;

        public StreamConsumer(Origin origin, OutputStream outputStream) {
            this(origin, outputStream, null);
        }

        public StreamConsumer(Origin origin, OutputStream outputStream, UsageInformationConsumer consumer) {
            super(consumer);
            this.origin = origin;
            this.outputStream = outputStream;
        }

        @Override
        public void acceptUsageInformation(byte[] data, DiagnosticsHandler handler) {
            super.acceptUsageInformation(data, handler);
            try {
                this.outputStream.write(data);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, this.origin));
            }
        }
    }

    public static class FileConsumer
    extends ForwardingConsumer {
        private final Path outputPath;

        public FileConsumer(Path outputPath) {
            this(outputPath, null);
        }

        public FileConsumer(Path outputPath, UsageInformationConsumer consumer) {
            super(consumer);
            this.outputPath = outputPath;
        }

        @Override
        public void acceptUsageInformation(byte[] data, DiagnosticsHandler handler) {
            super.acceptUsageInformation(data, handler);
            try {
                FileUtils.writeToFile(this.outputPath, null, data);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, new PathOrigin(this.outputPath)));
            }
        }
    }

    public static class ForwardingConsumer
    implements UsageInformationConsumer {
        private final UsageInformationConsumer consumer;

        public ForwardingConsumer(UsageInformationConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void acceptUsageInformation(byte[] data, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.acceptUsageInformation(data, handler);
            }
        }
    }

    public static class EmptyConsumer
    implements UsageInformationConsumer {
        private static final EmptyConsumer EMPTY_CONSUMER = new EmptyConsumer();

        private EmptyConsumer() {
        }

        @Override
        public void acceptUsageInformation(byte[] data, DiagnosticsHandler handler) {
        }
    }
}

