/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.Descriptor;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DirectMappedDexApplication;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;

public class AppInfoWithSubtyping
extends AppInfo {
    private final Set<DexType> missingClasses = Sets.newIdentityHashSet();
    private final Map<DexType, ImmutableSet<DexType>> subtypeMap = new IdentityHashMap<DexType, ImmutableSet<DexType>>();

    public AppInfoWithSubtyping(DexApplication application) {
        super(application);
        this.populateSubtypeMap(application.asDirect(), application.dexItemFactory);
    }

    protected AppInfoWithSubtyping(AppInfoWithSubtyping previous) {
        super(previous);
        this.missingClasses.addAll(previous.missingClasses);
        this.subtypeMap.putAll(previous.subtypeMap);
        assert (this.app instanceof DirectMappedDexApplication);
    }

    protected AppInfoWithSubtyping(DirectMappedDexApplication application, GraphLense lense) {
        super(application, lense);
        this.populateSubtypeMap(application, this.dexItemFactory);
    }

    private DirectMappedDexApplication getDirectApplication() {
        return (DirectMappedDexApplication)this.app;
    }

    public Iterable<DexLibraryClass> libraryClasses() {
        return this.getDirectApplication().libraryClasses();
    }

    public Set<DexType> getMissingClasses() {
        return Collections.unmodifiableSet(this.missingClasses);
    }

    public ImmutableSet<DexType> subtypes(DexType type) {
        assert (type.isClassType());
        ImmutableSet<DexType> subtypes = this.subtypeMap.get(type);
        return subtypes == null ? ImmutableSet.of() : subtypes;
    }

    private void populateSuperType(Map<DexType, Set<DexType>> map, DexType superType, DexClass baseClass, Function<DexType, DexClass> definitions) {
        Set set;
        if (superType != null && (set = map.computeIfAbsent(superType, ignore -> new HashSet())).add(baseClass.type)) {
            this.populateAllSuperTypes(map, superType, baseClass, definitions);
        }
    }

    private void populateAllSuperTypes(Map<DexType, Set<DexType>> map, DexType holder, DexClass baseClass, Function<DexType, DexClass> definitions) {
        DexClass holderClass = definitions.apply(holder);
        if (holderClass != null) {
            this.populateSuperType(map, holderClass.superType, baseClass, definitions);
            if (holderClass.superType != null) {
                holderClass.superType.addDirectSubtype(holder);
            } else assert (this.dexItemFactory.objectType == holder);
            for (DexType inter : holderClass.interfaces.values) {
                this.populateSuperType(map, inter, baseClass, definitions);
                inter.addInterfaceSubtype(holder);
            }
            if (holderClass.isInterface()) {
                holder.tagAsInteface();
            }
        } else {
            if (!baseClass.isLibraryClass()) {
                this.missingClasses.add(holder);
            }
            if (holder != this.dexItemFactory.objectType) {
                this.dexItemFactory.objectType.addDirectSubtype(holder);
            }
        }
    }

    private void populateSubtypeMap(DirectMappedDexApplication app, DexItemFactory dexItemFactory) {
        dexItemFactory.clearSubtypeInformation();
        dexItemFactory.objectType.tagAsSubtypeRoot();
        IdentityHashMap<DexType, Set<DexType>> map = new IdentityHashMap<DexType, Set<DexType>>();
        for (DexClass dexClass : Iterables.concat(app.classes(), app.libraryClasses())) {
            this.populateAllSuperTypes(map, dexClass.type, dexClass, app::definitionFor);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.subtypeMap.put((DexType)entry.getKey(), (ImmutableSet<DexType>)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
        assert (DexType.validateLevelsAreCorrect(app::definitionFor, dexItemFactory));
    }

    public Set<DexEncodedMethod> lookupVirtualTargets(DexMethod method) {
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        DexClass root = this.definitionFor(method.holder);
        if (root == null) {
            return null;
        }
        AppInfo.ResolutionResult topTargets = this.resolveMethodOnClass(method.holder, method);
        if (topTargets.asResultOfResolve() == null) {
            return null;
        }
        topTargets.forEachTarget(result::add);
        for (DexType type : this.subtypes(method.holder)) {
            DexClass clazz = this.definitionFor(type);
            if (clazz.isInterface()) continue;
            AppInfo.ResolutionResult methods = this.resolveMethodOnClass(type, method);
            methods.forEachTarget(result::add);
        }
        return result;
    }

    private boolean holderIsAbstract(Descriptor<?, ?> desc) {
        DexClass holder = this.definitionFor(desc.getHolder());
        return holder.accessFlags.isAbstract();
    }

    private boolean holderIsInterface(Descriptor<?, ?> desc) {
        DexClass holder = this.definitionFor(desc.getHolder());
        return holder == null || holder.accessFlags.isInterface();
    }

    @Override
    public DexEncodedMethod lookupSuperTarget(DexMethod method, DexType invocationContext) {
        if (!invocationContext.isSubtypeOf(method.holder, this)) {
            DexClass contextClass = this.definitionFor(invocationContext);
            throw new CompilationError("Illegal invoke-super to " + method.toSourceString() + " from class " + invocationContext, contextClass.getOrigin());
        }
        return super.lookupSuperTarget(method, invocationContext);
    }

    public Set<DexEncodedMethod> lookupInterfaceTargets(DexMethod method) {
        AppInfo.ResolutionResult topTarget = this.resolveMethodOnInterface(method.holder, method);
        if (topTarget.asResultOfResolve() == null) {
            return null;
        }
        ImmutableSet<DexType> set = this.subtypes(method.holder);
        if (set.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<DexEncodedMethod> result = new HashSet<DexEncodedMethod>();
        for (DexType type : set) {
            DexClass clazz = this.definitionFor(type);
            if (clazz.isInterface()) continue;
            AppInfo.ResolutionResult targetMethods = this.resolveMethodOnClass(type, method);
            targetMethods.forEachTarget(result::add);
        }
        return result;
    }

    @Override
    public void registerNewType(DexType newType, DexType superType) {
        superType.addDirectSubtype(newType);
    }

    @Override
    public boolean hasSubtyping() {
        return true;
    }

    @Override
    public AppInfoWithSubtyping withSubtyping() {
        return this;
    }
}

