/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.device.AdbShellCommandTask;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.device.DeviceFeaturesParser;
import com.android.tools.build.bundletool.model.exceptions.InstallationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.IDevice;
import shadow.bundletool.com.android.ddmlib.IShellOutputReceiver;
import shadow.bundletool.com.android.ddmlib.InstallException;
import shadow.bundletool.com.android.ddmlib.ShellCommandUnresponsiveException;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.sdklib.AndroidVersion;

public class DdmlibDevice
extends Device {
    private final IDevice device;
    private static final int ADB_TIMEOUT_MS = 60000;
    private static final String DEVICE_FEATURES_COMMAND = "pm list features";
    private final DeviceFeaturesParser deviceFeaturesParser = new DeviceFeaturesParser();

    public DdmlibDevice(IDevice device) {
        this.device = device;
    }

    @Override
    public IDevice.DeviceState getState() {
        return this.device.getState();
    }

    @Override
    public AndroidVersion getVersion() {
        return this.device.getVersion();
    }

    @Override
    public ImmutableList<String> getAbis() {
        return ImmutableList.copyOf(this.device.getAbis());
    }

    @Override
    public int getDensity() {
        return this.device.getDensity();
    }

    @Override
    public String getSerialNumber() {
        return this.device.getSerialNumber();
    }

    @Override
    public Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.device.getProperty(propertyName));
    }

    @Override
    public ImmutableList<String> getDeviceFeatures() {
        return this.deviceFeaturesParser.parse(new AdbShellCommandTask(this, DEVICE_FEATURES_COMMAND).execute(60000L, TimeUnit.MILLISECONDS));
    }

    @Override
    public void executeShellCommand(String command, IShellOutputReceiver receiver, long maxTimeToOutputResponse, TimeUnit maxTimeUnits) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.device.executeShellCommand(command, receiver, maxTimeToOutputResponse, maxTimeUnits);
    }

    @Override
    public void installApks(ImmutableList<Path> apks, Device.InstallOptions installOptions) {
        ImmutableList apkFiles = (ImmutableList)apks.stream().map(Path::toFile).collect(ImmutableList.toImmutableList());
        ImmutableList extraArgs = installOptions.getAllowDowngrade() ? ImmutableList.of((Object)"-d") : ImmutableList.of();
        try {
            if (this.getVersion().isGreaterOrEqualThan(AndroidVersion.ALLOW_SPLIT_APK_INSTALLATION.getApiLevel())) {
                this.device.installPackages((List<File>)apkFiles, installOptions.getAllowReinstall(), (List<String>)extraArgs, installOptions.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.device.installPackage(((File)Iterables.getOnlyElement((Iterable)apkFiles)).toString(), installOptions.getAllowReinstall(), (String[])extraArgs.toArray((Object[])new String[0]));
            }
        }
        catch (InstallException e) {
            throw InstallationException.builder().withCause(e).withMessage("Installation of the app failed.").build();
        }
    }
}

