/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

final class MergingUtils {
    public static <T> Optional<T> getSameValueOrNonNull(@Nullable T nullableValue, T otherValue) {
        Preconditions.checkNotNull(otherValue);
        if (nullableValue == null || nullableValue.equals(otherValue)) {
            return Optional.of(otherValue);
        }
        return Optional.empty();
    }

    public static Targeting.ApkTargeting mergeShardTargetings(Targeting.ApkTargeting targeting1, Targeting.ApkTargeting targeting2) {
        MergingUtils.checkHasOnlyAbiDensityAndLanguageTargeting(targeting1);
        MergingUtils.checkHasOnlyAbiDensityAndLanguageTargeting(targeting2);
        Targeting.ApkTargeting.Builder merged = Targeting.ApkTargeting.newBuilder();
        if (targeting1.hasAbiTargeting() || targeting2.hasAbiTargeting()) {
            merged.setAbiTargeting(MergingUtils.mergeAbiTargetingsOf(targeting1, targeting2));
        }
        if (targeting1.hasScreenDensityTargeting() || targeting2.hasScreenDensityTargeting()) {
            merged.setScreenDensityTargeting(MergingUtils.mergeDensityTargetingsOf(targeting1, targeting2));
        }
        if (targeting1.hasLanguageTargeting() || targeting2.hasLanguageTargeting()) {
            merged.setLanguageTargeting(MergingUtils.mergeLanguageTargetingsOf(targeting1, targeting2));
        }
        return merged.build();
    }

    private static void checkHasOnlyAbiDensityAndLanguageTargeting(Targeting.ApkTargeting targeting) {
        Targeting.ApkTargeting targetingWithoutAbiDensityAndLanguage = targeting.toBuilder().clearAbiTargeting().clearScreenDensityTargeting().clearLanguageTargeting().build();
        if (!targetingWithoutAbiDensityAndLanguage.equals(Targeting.ApkTargeting.getDefaultInstance())) {
            throw CommandExecutionException.builder().withMessage("Expecting only ABI, screen density and language targeting, got '%s'.", targeting).build();
        }
    }

    private static Targeting.AbiTargeting mergeAbiTargetingsOf(Targeting.ApkTargeting targeting1, Targeting.ApkTargeting targeting2) {
        Sets.SetView universe = Sets.union(TargetingProtoUtils.abiUniverse(targeting1), TargetingProtoUtils.abiUniverse(targeting2));
        Sets.SetView values = Sets.union(TargetingProtoUtils.abiValues(targeting1), TargetingProtoUtils.abiValues(targeting2));
        return Targeting.AbiTargeting.newBuilder().addAllValue((Iterable<? extends Targeting.Abi>)values).addAllAlternatives((Iterable<? extends Targeting.Abi>)Sets.difference((Set)universe, (Set)values)).build();
    }

    private static Targeting.ScreenDensityTargeting mergeDensityTargetingsOf(Targeting.ApkTargeting targeting1, Targeting.ApkTargeting targeting2) {
        Sets.SetView universe = Sets.union(TargetingProtoUtils.densityUniverse(targeting1), TargetingProtoUtils.densityUniverse(targeting2));
        Sets.SetView values = Sets.union(TargetingProtoUtils.densityValues(targeting1), TargetingProtoUtils.densityValues(targeting2));
        return Targeting.ScreenDensityTargeting.newBuilder().addAllValue((Iterable<? extends Targeting.ScreenDensity>)values).addAllAlternatives((Iterable<? extends Targeting.ScreenDensity>)Sets.difference((Set)universe, (Set)values)).build();
    }

    private static Targeting.LanguageTargeting mergeLanguageTargetingsOf(Targeting.ApkTargeting targeting1, Targeting.ApkTargeting targeting2) {
        Sets.SetView universe = Sets.union(TargetingProtoUtils.languageUniverse(targeting1), TargetingProtoUtils.languageUniverse(targeting2));
        Sets.SetView values = Sets.union(TargetingProtoUtils.languageValues(targeting1), TargetingProtoUtils.languageValues(targeting2));
        return Targeting.LanguageTargeting.newBuilder().addAllValue((Iterable<String>)values).addAllAlternatives((Iterable<String>)Sets.difference((Set)universe, (Set)values)).build();
    }

    private MergingUtils() {
    }
}

