/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_FileSystemModuleEntry;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.MustBeClosed;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@Immutable
@AutoValue
public abstract class FileSystemModuleEntry
implements ModuleEntry {
    @Override
    public abstract ZipPath getPath();

    @Override
    public abstract boolean isDirectory();

    @Override
    public abstract boolean shouldCompress();

    abstract Path getFileSystemPath();

    @Override
    @MustBeClosed
    public InputStream getContent() {
        try {
            return BufferedIo.inputStream(this.getFileSystemPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Error while reading file '%s'.", this.getFileSystemPath()), e);
        }
    }

    @Override
    public FileSystemModuleEntry setCompression(boolean shouldCompress) {
        if (shouldCompress == this.shouldCompress()) {
            return this;
        }
        return FileSystemModuleEntry.create(this.getPath(), this.isDirectory(), shouldCompress, this.getFileSystemPath());
    }

    public static FileSystemModuleEntry ofFile(ZipPath entryPath, Path fileSystemPath) {
        Preconditions.checkArgument((boolean)Files.isRegularFile(fileSystemPath, new LinkOption[0]), (String)"Expecting '%s' to be an existing regular file.", (Object)fileSystemPath);
        return FileSystemModuleEntry.create(entryPath, false, true, fileSystemPath);
    }

    private static FileSystemModuleEntry create(ZipPath entryPath, boolean isDirectory, boolean shouldCompress, Path fileSystemPath) {
        return new AutoValue_FileSystemModuleEntry(entryPath, isDirectory, shouldCompress, fileSystemPath);
    }
}

