/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import org.objectweb.asm.Type;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public class MemberNaming {
    final Signature signature;
    final Signature renamedSignature;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberNaming)) {
            return false;
        }
        MemberNaming that = (MemberNaming)o;
        return this.signature.equals(that.signature) && this.renamedSignature.equals(that.renamedSignature);
    }

    public int hashCode() {
        int result = this.signature.hashCode();
        result = 31 * result + this.renamedSignature.hashCode();
        return result;
    }

    public MemberNaming(Signature signature, String renamedName) {
        this.signature = signature;
        this.renamedSignature = signature.asRenamed(renamedName);
    }

    public Signature getOriginalSignature() {
        return this.signature;
    }

    public String getOriginalName() {
        return this.signature.name;
    }

    public Signature getRenamedSignature() {
        return this.renamedSignature;
    }

    public String getRenamedName() {
        return this.renamedSignature.name;
    }

    public boolean isMethodNaming() {
        return this.signature.kind() == Signature.SignatureKind.METHOD;
    }

    public String toString() {
        return this.signature.toString() + " -> " + this.renamedSignature.name;
    }

    public static class MethodSignature
    extends Signature {
        public final String type;
        public final String[] parameters;

        public MethodSignature(String name, String type, String[] parameters) {
            super(name);
            this.type = type;
            this.parameters = parameters;
        }

        public MethodSignature(String name, String type, Collection<String> parameters) {
            super(name);
            this.type = type;
            this.parameters = parameters.toArray(new String[parameters.size()]);
        }

        public static MethodSignature fromDexMethod(DexMethod method) {
            return MethodSignature.fromDexMethod(method, false);
        }

        public static MethodSignature fromDexMethod(DexMethod method, boolean withQualifiedName) {
            String[] paramNames = new String[method.getArity()];
            DexType[] values = method.proto.parameters.values;
            for (int i = 0; i < values.length; ++i) {
                paramNames[i] = values[i].toSourceString();
            }
            return new MethodSignature(withQualifiedName ? method.qualifiedName() : method.name.toSourceString(), method.proto.returnType.toSourceString(), paramNames);
        }

        public static MethodSignature fromSignature(String name, String signature) {
            Type[] parameterDescriptors = Type.getArgumentTypes((String)signature);
            Type returnDescriptor = Type.getReturnType((String)signature);
            String[] parameterTypes = new String[parameterDescriptors.length];
            for (int i = 0; i < parameterDescriptors.length; ++i) {
                parameterTypes[i] = DescriptorUtils.descriptorToJavaType(parameterDescriptors[i].getDescriptor());
            }
            return new MethodSignature(name, DescriptorUtils.descriptorToJavaType(returnDescriptor.getDescriptor()), parameterTypes);
        }

        DexMethod toDexMethod(DexItemFactory factory, DexType clazz) {
            DexType[] paramTypes = new DexType[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                paramTypes[i] = factory.createType(DescriptorUtils.javaTypeToDescriptor(this.parameters[i]));
            }
            DexType returnType = factory.createType(DescriptorUtils.javaTypeToDescriptor(this.type));
            return factory.createMethod(clazz, factory.createProto(returnType, paramTypes), factory.createString(this.name));
        }

        public static MethodSignature initializer(String[] parameters) {
            return new MethodSignature("<init>", "void", parameters);
        }

        @Override
        Signature asRenamed(String renamedName) {
            return new MethodSignature(renamedName, this.type, this.parameters);
        }

        @Override
        public Signature.SignatureKind kind() {
            return Signature.SignatureKind.METHOD;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodSignature)) {
                return false;
            }
            MethodSignature that = (MethodSignature)o;
            return this.type.equals(that.type) && this.name.equals(that.name) && Arrays.equals(this.parameters, that.parameters);
        }

        @Override
        public int hashCode() {
            return (this.type.hashCode() * 17 + this.name.hashCode()) * 31 + Arrays.hashCode(this.parameters);
        }

        @Override
        public String toString() {
            return this.type + ' ' + this.name + '(' + String.join((CharSequence)",", this.parameters) + ')';
        }

        @Override
        void write(Writer writer) throws IOException {
            writer.append(this.type).append(' ').append(this.name).append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                writer.append(this.parameters[i]);
                if (i >= this.parameters.length - 1) continue;
                writer.append(',');
            }
            writer.append(')');
        }
    }

    public static class FieldSignature
    extends Signature {
        public final String type;

        public FieldSignature(String name, String type) {
            super(name);
            this.type = type;
        }

        public static FieldSignature fromDexField(DexField field) {
            return new FieldSignature(field.name.toSourceString(), field.type.toSourceString());
        }

        DexField toDexField(DexItemFactory factory, DexType clazz) {
            return factory.createField(clazz, factory.createType(DescriptorUtils.javaTypeToDescriptor(this.type)), factory.createString(this.name));
        }

        @Override
        Signature asRenamed(String renamedName) {
            return new FieldSignature(renamedName, this.type);
        }

        @Override
        public Signature.SignatureKind kind() {
            return Signature.SignatureKind.FIELD;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldSignature)) {
                return false;
            }
            FieldSignature that = (FieldSignature)o;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() * 31 + this.type.hashCode();
        }

        @Override
        public String toString() {
            return this.type + " " + this.name;
        }

        @Override
        void write(Writer writer) throws IOException {
            writer.append(this.type);
            writer.append(' ');
            writer.append(this.name);
        }
    }

    public static abstract class Signature {
        public final String name;

        protected Signature(String name) {
            this.name = name;
        }

        abstract Signature asRenamed(String var1);

        public abstract SignatureKind kind();

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        abstract void write(Writer var1) throws IOException;

        public String toString() {
            try {
                StringWriter writer = new StringWriter();
                this.write(writer);
                return writer.toString();
            }
            catch (IOException e) {
                throw new Unreachable(e);
            }
        }

        static enum SignatureKind {
            METHOD,
            FIELD;

        }
    }
}

