/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking.protolite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BiPredicate;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.DominatorTree;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceGet;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeInterface;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.MemberType;
import shadow.bundletool.com.android.tools.r8.ir.code.Switch;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.optimize.SwitchUtils;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.shaking.protolite.ProtoLiteBase;

public class ProtoLitePruner
extends ProtoLiteBase {
    private final DexType visitorType;
    private final DexType methodEnumType;
    private final DexType codedOutputStreamType;
    private final DexType protobufListType;
    private final DexType listType;
    private final DexString visitTag;
    private final DexString mergeTag;
    private final DexString isInitializedTag;
    private final DexString makeImmutabkeTag;
    private final DexString computeMethodPrefix;
    private final DexString writeMethodPrefix;
    private final DexString isInitializedMethodName;
    private final DexString makeImmutableMethodName;
    private final DexString sizeMethodName;
    private final DexMethod sizeMethod;

    public ProtoLitePruner(Enqueuer.AppInfoWithLiveness appInfo) {
        super(appInfo);
        DexItemFactory factory = appInfo.dexItemFactory;
        this.visitorType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite$Visitor;");
        this.methodEnumType = factory.createType("Lcom/google/protobuf/GeneratedMessageLite$MethodToInvoke;");
        this.codedOutputStreamType = factory.createType("Lcom/google/protobuf/CodedOutputStream;");
        this.protobufListType = factory.createType("Lcom/google/protobuf/Internal$ProtobufList;");
        this.listType = factory.createType("Ljava/util/List;");
        this.visitTag = factory.createString("VISIT");
        this.mergeTag = factory.createString("MERGE_FROM_STREAM");
        this.isInitializedTag = factory.createString("IS_INITIALIZED");
        this.makeImmutabkeTag = factory.createString("MAKE_IMMUTABLE");
        this.computeMethodPrefix = factory.createString("compute");
        this.writeMethodPrefix = factory.createString("write");
        this.sizeMethodName = factory.createString("size");
        this.isInitializedMethodName = factory.createString("isInitialized");
        this.makeImmutableMethodName = factory.createString("makeImmutable");
        this.sizeMethod = factory.createMethod(this.listType, factory.createProto(factory.intType, new DexType[0]), this.sizeMethodName);
    }

    private boolean isPresenceField(DexField field, DexType instanceType) {
        if (field.getHolder() != instanceType) {
            return false;
        }
        String fieldName = field.name.toString();
        return fieldName.endsWith("_") && fieldName.startsWith("bitField");
    }

    @Override
    boolean isSetterThatNeedsProcessing(DexEncodedMethod method) {
        return false;
    }

    private boolean isGetter(DexMethod method) {
        return this.isGetterHelper(method, 0);
    }

    private boolean isCountGetter(DexMethod method) {
        return this.isGetterHelper(method, 5);
    }

    private boolean isGetterHelper(DexMethod method, int postFixLength) {
        if (!method.name.beginsWith(this.getterNamePrefix) || !method.proto.parameters.isEmpty() && !this.hasSingleIntArgument(method) || method.holder == this.messageType || !method.holder.isSubtypeOf(this.messageType, this.appInfo) || method.name.size <= 3 + postFixLength) {
            return false;
        }
        DexField correspondingField = this.getterToField(method, postFixLength);
        return this.isProtoField(correspondingField);
    }

    private boolean isDefinedAsNull(Value value) {
        return value.definition != null && value.isZero();
    }

    private boolean isComputeSizeMethod(DexMethod invokedMethod) {
        return invokedMethod.holder == this.codedOutputStreamType && invokedMethod.name.beginsWith(this.computeMethodPrefix);
    }

    private boolean isWriteMethod(DexMethod invokedMethod) {
        return invokedMethod.holder == this.codedOutputStreamType && invokedMethod.name.beginsWith(this.writeMethodPrefix);
    }

    private boolean isProtoField(DexField field) {
        return this.appInfo.withLiveness().isProtoLiteField(field);
    }

    public void rewriteProtoLiteSpecialMethod(IRCode code, DexEncodedMethod method) {
        DexString methodName = method.method.name;
        if (methodName == this.dynamicMethodName) {
            this.rewriteDynamicMethod(code, method);
        } else if (methodName == this.writeToMethodName || methodName == this.getSerializedSizeMethodName) {
            this.rewriteSizeOrWriteMethod(code);
        } else if (methodName == this.constructorMethodName) {
            this.rewriteConstructor(code);
        } else {
            throw new Unreachable();
        }
    }

    private void rewriteConstructor(IRCode code) {
        boolean wasRewritten;
        do {
            wasRewritten = false;
            InstructionIterator it = code.instructionIterator();
            while (it.hasNext()) {
                Instruction insn = (Instruction)it.next();
                if (insn.isInstancePut() && this.isDeadProtoField(insn.asInstancePut().getField())) {
                    it.remove();
                    wasRewritten = true;
                    continue;
                }
                if (!insn.isInvokeStatic()) continue;
                InvokeStatic invokeStatic = insn.asInvokeStatic();
                DexMethod invokedMethod = invokeStatic.getInvokedMethod();
                if (invokeStatic.outValue().isUsed() || !invokedMethod.proto.returnType.isSubtypeOf(this.protobufListType, this.appInfo)) continue;
                it.remove();
            }
        } while (wasRewritten);
    }

    private void rewriteSizeOrWriteMethod(IRCode code) {
        boolean wasRewritten;
        do {
            wasRewritten = false;
            InstructionIterator it = code.instructionIterator();
            while (it.hasNext()) {
                Value lastArg;
                DexMethod invokedMethod;
                InvokeMethod invokeMethod;
                Instruction insn = (Instruction)it.next();
                if (insn.isInstanceGet()) {
                    DexField field = insn.asInstanceGet().getField();
                    if (!this.isDeadProtoField(field)) continue;
                    it.replaceCurrentInstruction(code.createConstNull(insn.asInstanceGet()));
                    wasRewritten = true;
                    continue;
                }
                if (insn.isInvokeMethodWithReceiver()) {
                    Value receiver;
                    invokeMethod = insn.asInvokeMethodWithReceiver();
                    invokedMethod = invokeMethod.getInvokedMethod();
                    if (this.isDeadProtoGetter(invokedMethod)) {
                        it.replaceCurrentInstruction(code.createConstNull(invokeMethod));
                        wasRewritten = true;
                        continue;
                    }
                    if (invokedMethod.name == this.sizeMethodName && invokedMethod.holder.isSubtypeOf(this.listType, this.appInfo)) {
                        receiver = ((InvokeMethodWithReceiver)invokeMethod).getReceiver();
                        if (!this.isDefinedAsNull(receiver)) continue;
                        it.replaceCurrentInstruction(code.createConstNull(invokeMethod));
                        continue;
                    }
                    if (invokedMethod.name == this.getterNamePrefix && invokedMethod.holder.isSubtypeOf(this.listType, this.appInfo)) {
                        receiver = ((InvokeMethodWithReceiver)invokeMethod).getReceiver();
                        if (!this.isDefinedAsNull(receiver)) continue;
                        it.replaceCurrentInstruction(code.createConstNull(invokeMethod));
                        wasRewritten = true;
                        continue;
                    }
                    if (!this.isWriteMethod(invokedMethod) || !this.isDefinedAsNull(lastArg = (Value)Iterables.getLast(invokeMethod.inValues()))) continue;
                    it.remove();
                    continue;
                }
                if (!insn.isInvokeMethod() || !this.isComputeSizeMethod(invokedMethod = (invokeMethod = insn.asInvokeMethod()).getInvokedMethod()) || !this.isDefinedAsNull(lastArg = (Value)Iterables.getLast(invokeMethod.inValues()))) continue;
                assert (invokeMethod.outValue() != null);
                it.replaceCurrentInstruction(code.createConstNull(invokeMethod));
                wasRewritten = true;
            }
        } while (wasRewritten);
    }

    private void rewriteDynamicMethod(IRCode code, DexEncodedMethod method) {
        InstructionIterator iterator2 = code.instructionIterator();
        Instruction matchingInstr = iterator2.nextUntil(Instruction::isSwitch);
        if (matchingInstr == null) {
            throw new CompilationError("dynamicMethod in protoLite without switch.");
        }
        Switch switchInstr = matchingInstr.asSwitch();
        SwitchUtils.EnumSwitchInfo info = SwitchUtils.analyzeSwitchOverEnum(switchInstr, this.appInfo.withLiveness());
        if (info == null || info.enumClass != this.methodEnumType) {
            throw new CompilationError("Malformed switch in dynamicMethod of proto lite.");
        }
        BasicBlock initializedCase = null;
        BasicBlock visitCase = null;
        BasicBlock mergeCase = null;
        BasicBlock makeImmutableCase = null;
        for (int keyIdx = 0; keyIdx < switchInstr.numberOfKeys(); ++keyIdx) {
            int key = switchInstr.getKey(keyIdx);
            DexField label = (DexField)info.indexMap.get(key);
            assert (label != null);
            if (label.name == this.visitTag) {
                assert (visitCase == null);
                visitCase = switchInstr.targetBlock(keyIdx);
                continue;
            }
            if (label.name == this.mergeTag) {
                assert (mergeCase == null);
                mergeCase = switchInstr.targetBlock(keyIdx);
                continue;
            }
            if (label.name == this.isInitializedTag) {
                assert (initializedCase == null);
                initializedCase = switchInstr.targetBlock(keyIdx);
                continue;
            }
            if (label.name != this.makeImmutabkeTag) continue;
            assert (makeImmutableCase == null);
            makeImmutableCase = switchInstr.targetBlock(keyIdx);
        }
        DexType instanceType = method.method.getHolder();
        this.rewriteIsInitializedCase(initializedCase, instanceType, code);
        assert (code.isConsistentSSA());
        this.rewriteMakeImmutableCase(makeImmutableCase, code);
        assert (code.isConsistentSSA());
        this.rewriteVisitCase(visitCase, code);
        assert (code.isConsistentSSA());
        this.rewriteMergeCase(mergeCase, instanceType, code);
        code.splitCriticalEdges();
        code.traceBlocks();
        assert (code.isConsistentSSA());
    }

    private void rewriteMakeImmutableCase(BasicBlock switchCase, IRCode code) {
        boolean wasRewritten;
        DominatorTree dom = new DominatorTree(code);
        do {
            wasRewritten = false;
            for (BasicBlock current : dom.dominatedBlocks(switchCase)) {
                InstructionIterator it = current.iterator();
                while (it.hasNext()) {
                    Value receiver;
                    Instruction insn = (Instruction)it.next();
                    if (insn.isInstanceGet() && this.isDeadProtoField(insn.asInstanceGet().getField())) {
                        it.replaceCurrentInstruction(code.createConstNull(insn));
                        wasRewritten = true;
                        continue;
                    }
                    if (!insn.isInvokeMethodWithReceiver()) continue;
                    InvokeMethodWithReceiver invokeMethod = insn.asInvokeMethodWithReceiver();
                    DexMethod invokedMethod = invokeMethod.getInvokedMethod();
                    if (this.isDeadProtoGetter(invokedMethod)) {
                        it.replaceCurrentInstruction(code.createConstNull(invokeMethod));
                        wasRewritten = true;
                        continue;
                    }
                    if (invokedMethod.name != this.makeImmutableMethodName || !invokedMethod.getHolder().isSubtypeOf(this.protobufListType, this.appInfo) || !this.isDefinedAsNull(receiver = invokeMethod.getReceiver())) continue;
                    it.remove();
                }
            }
        } while (wasRewritten);
    }

    private void rewriteIsInitializedCase(BasicBlock switchCase, DexType instanceType, IRCode code) {
        boolean wasRewritten;
        DominatorTree dom = new DominatorTree(code);
        do {
            wasRewritten = false;
            for (BasicBlock current : dom.dominatedBlocks(switchCase)) {
                InstructionIterator it = current.iterator();
                while (it.hasNext()) {
                    Instruction insn = (Instruction)it.next();
                    if (!insn.isInvokeMethodWithReceiver()) continue;
                    InvokeMethodWithReceiver invokeMethod = insn.asInvokeMethodWithReceiver();
                    DexMethod invokedMethod = invokeMethod.getInvokedMethod();
                    if (this.isDeadProtoGetter(invokedMethod)) {
                        it.replaceCurrentInstruction(code.createConstNull(invokeMethod));
                        wasRewritten = true;
                        continue;
                    }
                    if (invokedMethod.name == this.isInitializedMethodName && invokedMethod.getHolder().isSubtypeOf(this.messageType, this.appInfo)) {
                        Value receiver = invokeMethod.getReceiver();
                        if (!this.isDefinedAsNull(receiver)) continue;
                        it.replaceCurrentInstruction(code.createTrue());
                        wasRewritten = true;
                        continue;
                    }
                    if (!this.isCountGetter(invokedMethod)) continue;
                    DexField field = this.getterToField(invokedMethod, 5);
                    if (this.appInfo.withLiveness().liveFields.contains(field)) {
                        Value thisReference = invokeMethod.getReceiver();
                        Value newResult = code.createValue(ValueType.INT);
                        invokeMethod.outValue().replaceUsers(newResult);
                        Value theList = code.createValue(ValueType.OBJECT);
                        it.replaceCurrentInstruction(new InstanceGet(MemberType.OBJECT, theList, thisReference, field));
                        it.add(new InvokeInterface(this.sizeMethod, newResult, Collections.emptyList()));
                        continue;
                    }
                    it.replaceCurrentInstruction(code.createConstNull(invokeMethod));
                }
            }
        } while (wasRewritten);
    }

    private InstancePut findProtoFieldWrite(BasicBlock block, DexType instanceType, BiPredicate<DexField, DexType> filter, DominatorTree dom) {
        for (BasicBlock current : dom.dominatedBlocks(block)) {
            InstructionIterator insns = current.iterator();
            InstancePut instancePut = (InstancePut)insns.nextUntil(Instruction::isInstancePut);
            if (instancePut == null || !filter.test(instancePut.getField(), instanceType)) continue;
            return instancePut;
        }
        return null;
    }

    private void rewriteMergeCase(BasicBlock caseBlock, DexType instanceType, IRCode code) {
        ArrayList<BasicBlock> deadBlocks = new ArrayList<BasicBlock>();
        DominatorTree dom = new DominatorTree(code);
        for (BasicBlock current : dom.dominatedBlocks(caseBlock)) {
            InstructionIterator it = current.iterator();
            Switch switchInstr = (Switch)it.nextUntil(Instruction::isSwitch);
            if (switchInstr == null) continue;
            int nextBlock = code.getHighestBlockNumber() + 1;
            IntArrayList liveKeys = new IntArrayList(switchInstr.numberOfKeys());
            ArrayList<BasicBlock> liveBlocks = new ArrayList<BasicBlock>(switchInstr.numberOfKeys());
            boolean needsCleanup = false;
            for (int keyIdx = 0; keyIdx < switchInstr.numberOfKeys(); ++keyIdx) {
                BasicBlock targetBlock = switchInstr.targetBlock(keyIdx);
                InstancePut instancePut = this.findProtoFieldWrite(targetBlock, instanceType, (field, holder) -> this.isProtoField((DexField)field), dom);
                if (instancePut == null || this.appInfo.withLiveness().liveFields.contains(instancePut.getField())) {
                    liveKeys.add(switchInstr.getKey(keyIdx));
                    liveBlocks.add(targetBlock);
                    continue;
                }
                InstancePut bitFieldUpdate = this.findProtoFieldWrite(targetBlock, instanceType, this::isPresenceField, dom);
                if (bitFieldUpdate != null) {
                    BasicBlock newBlock = BasicBlock.createGotoBlock(nextBlock++);
                    newBlock.link(switchInstr.fallthroughBlock());
                    this.moveInstructionTo(newBlock.listIterator(), bitFieldUpdate, dom, targetBlock);
                    switchInstr.getBlock().link(newBlock);
                    liveKeys.add(switchInstr.getKey(keyIdx));
                    liveBlocks.add(newBlock);
                    code.blocks.add(newBlock);
                }
                needsCleanup = true;
            }
            if (!needsCleanup) break;
            DominatorTree updatedTree = new DominatorTree(code);
            BasicBlock fallThrough = switchInstr.fallthroughBlock();
            ImmutableList successors = ImmutableList.copyOf(current.getNormalSuccessors());
            for (BasicBlock successor : successors) {
                if (successor == fallThrough || liveBlocks.contains(successor)) continue;
                deadBlocks.addAll(current.unlink(successor, updatedTree));
            }
            int[] blockIndices = new int[liveBlocks.size()];
            for (int i = 0; i < liveBlocks.size(); ++i) {
                blockIndices[i] = current.getSuccessors().indexOf(liveBlocks.get(i));
            }
            Switch newSwitch = new Switch(switchInstr.inValues().get(0), liveKeys.toIntArray(), blockIndices, current.getSuccessors().indexOf(fallThrough));
            it.replaceCurrentInstruction(newSwitch);
            break;
        }
        code.removeBlocks(deadBlocks);
    }

    private void moveInstructionTo(InstructionListIterator iterator2, Instruction insn, DominatorTree dom, BasicBlock dominator) {
        for (Value value : insn.inValues()) {
            Instruction input = value.definition;
            assert (input != null);
            if (!dom.dominatedBy(input.getBlock(), dominator)) continue;
            assert (input.outValue().numberOfUsers() == 1);
            this.moveInstructionTo(iterator2, input, dom, dominator);
        }
        insn.getBlock().removeInstruction(insn);
        iterator2.add(insn);
    }

    private boolean isDeadProtoField(DexField field) {
        return this.isProtoField(field) && !this.appInfo.withLiveness().liveFields.contains(field);
    }

    private boolean isDeadProtoGetter(DexMethod method) {
        return this.isGetter(method) && this.isDeadProtoField(this.getterToField(method));
    }

    private boolean isVisitOfDeadField(Instruction instruction) {
        if (!instruction.isInvokeMethod()) {
            return false;
        }
        InvokeMethod invokeMethod = instruction.asInvokeMethod();
        if (invokeMethod.getInvokedMethod().getHolder() == this.visitorType && invokeMethod.getInvokedMethod().getArity() >= 2) {
            Instruction secondArg = invokeMethod.inValues().get((int)2).definition;
            return secondArg.isConstNumber();
        }
        return false;
    }

    private void rewriteVisitCase(BasicBlock switchCase, IRCode code) {
        boolean wasRewritten;
        DominatorTree dom = new DominatorTree(code);
        do {
            wasRewritten = false;
            for (BasicBlock target : dom.dominatedBlocks(switchCase)) {
                InstructionIterator it = target.iterator();
                while (it.hasNext()) {
                    Value inValue;
                    Instruction insn = (Instruction)it.next();
                    if (insn.isInstanceGet()) {
                        InstanceGet instanceGet = insn.asInstanceGet();
                        if (!this.isDeadProtoField(instanceGet.getField())) continue;
                        it.replaceCurrentInstruction(code.createConstNull(instanceGet));
                        wasRewritten = true;
                        continue;
                    }
                    if (insn.isInstancePut()) {
                        if (!this.isDeadProtoField(insn.asInstancePut().getField())) continue;
                        it.remove();
                        continue;
                    }
                    if (this.isVisitOfDeadField(insn)) {
                        it.replaceCurrentInstruction(code.createConstNull(insn));
                        continue;
                    }
                    if (!insn.isCheckCast() || !this.isDefinedAsNull(inValue = insn.inValues().get(0))) continue;
                    insn.outValue().replaceUsers(inValue);
                    it.remove();
                }
            }
        } while (wasRewritten);
    }
}

