/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_ZipPath;
import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class ZipPath
implements Path {
    private static final String SEPARATOR = "/";
    private static final Splitter SPLITTER = Splitter.on((String)"/").omitEmptyStrings();
    private static final Joiner JOINER = Joiner.on((String)"/");
    private static final ImmutableSet<String> FORBIDDEN_NAMES = ImmutableSet.of((Object)"", (Object)".", (Object)"..");
    public static final ZipPath ROOT = ZipPath.create("");

    ZipPath() {
    }

    abstract ImmutableList<String> getNames();

    public static ZipPath create(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path cannot be null.");
        return ZipPath.create((ImmutableList<String>)ImmutableList.copyOf((Collection)SPLITTER.splitToList((CharSequence)path)));
    }

    public static ZipPath create(ImmutableList<String> names) {
        names.forEach(name -> {
            Preconditions.checkArgument((!name.contains(SEPARATOR) ? 1 : 0) != 0, (String)"Name '%s' contains a forward slash and cannot be used in a path.", (Object)name);
            Preconditions.checkArgument((!FORBIDDEN_NAMES.contains(name) ? 1 : 0) != 0, (String)"Name '%s' is not supported inside path.", (Object)name);
        });
        return new AutoValue_ZipPath(names);
    }

    @Override
    @CheckReturnValue
    public ZipPath resolve(Path p3) {
        Preconditions.checkNotNull((Object)p3, (Object)"Path cannot be null.");
        ZipPath path = (ZipPath)p3;
        return ZipPath.create((ImmutableList<String>)ImmutableList.builder().addAll(this.getNames()).addAll(path.getNames()).build());
    }

    @Override
    @CheckReturnValue
    public ZipPath resolve(String path) {
        return this.resolve(ZipPath.create(path));
    }

    @Override
    @CheckReturnValue
    public ZipPath resolveSibling(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path cannot be null.");
        Preconditions.checkState((!this.getNames().isEmpty() ? 1 : 0) != 0, (Object)"Root has not sibling.");
        return this.getParent().resolve(path);
    }

    @Override
    @CheckReturnValue
    public ZipPath resolveSibling(String path) {
        return this.resolveSibling(ZipPath.create(path));
    }

    @Override
    @CheckReturnValue
    public ZipPath subpath(int from, int to) {
        Preconditions.checkArgument((from >= 0 && from < this.getNames().size() ? 1 : 0) != 0);
        Preconditions.checkArgument((to >= 0 && to <= this.getNames().size() ? 1 : 0) != 0);
        Preconditions.checkArgument((from < to ? 1 : 0) != 0);
        return ZipPath.create((ImmutableList<String>)this.getNames().subList(from, to));
    }

    @Override
    @Nullable
    @CheckReturnValue
    public ZipPath getParent() {
        if (this.getNames().isEmpty()) {
            return null;
        }
        return ZipPath.create((ImmutableList<String>)this.getNames().subList(0, this.getNames().size() - 1));
    }

    @Override
    public int getNameCount() {
        return this.getNames().size();
    }

    @Override
    public ZipPath getRoot() {
        return ROOT;
    }

    @Override
    public ZipPath getName(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.getNames().size() ? 1 : 0) != 0);
        return ZipPath.create((String)this.getNames().get(index));
    }

    @Override
    public boolean startsWith(Path p3) {
        ZipPath path = (ZipPath)p3;
        if (path.getNameCount() > this.getNameCount()) {
            return false;
        }
        ImmutableList<String> names = this.getNames();
        ImmutableList<String> otherNames = path.getNames();
        for (int i3 = 0; i3 < path.getNameCount(); ++i3) {
            if (((String)otherNames.get(i3)).equals(names.get(i3))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String p3) {
        return this.startsWith(ZipPath.create(p3));
    }

    @Override
    public boolean endsWith(Path p3) {
        ZipPath path = (ZipPath)p3;
        if (path.getNameCount() > this.getNameCount()) {
            return false;
        }
        ImmutableList<String> names = this.getNames();
        ImmutableList<String> otherNames = path.getNames();
        for (int i3 = 0; i3 < path.getNameCount(); ++i3) {
            if (((String)otherNames.get(otherNames.size() - i3 - 1)).equals(names.get(names.size() - i3 - 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String p3) {
        return this.endsWith(ZipPath.create(p3));
    }

    @Override
    public final int compareTo(Path other) {
        return Comparators.lexicographical(Comparator.naturalOrder()).compare(this.getNames(), ((ZipPath)other).getNames());
    }

    @Override
    public final String toString() {
        return JOINER.join(this.getNames());
    }

    @Override
    public ZipPath getFileName() {
        Preconditions.checkArgument((this.getNameCount() > 0 ? 1 : 0) != 0, (Object)"Root does not have a file name.");
        return this.getName(this.getNameCount() - 1);
    }

    @Override
    public Iterator<Path> iterator() {
        return this.getNames().stream().map(name -> ZipPath.create(name)).iterator();
    }

    @Override
    @CheckReturnValue
    public ZipPath normalize() {
        return this;
    }

    @Override
    public ZipPath toRealPath(LinkOption ... options) {
        return this;
    }

    @Override
    public ZipPath toAbsolutePath() {
        return this;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    @CheckReturnValue
    public ZipPath relativize(Path p3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException("Zip entries don't match to a file on disk.");
    }

    @Override
    public URI toUri() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }
}

