/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.targeting;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.targeting.TargetedDirectory;
import com.android.tools.build.bundletool.model.targeting.TargetedDirectorySegment;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.android.tools.build.bundletool.model.utils.TextureCompressionUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public final class TargetingUtils {
    public static ImmutableList<TargetingDimension> getTargetingDimensions(Targeting.AssetsDirectoryTargeting targeting) {
        ImmutableList.Builder dimensions = new ImmutableList.Builder();
        if (targeting.hasAbi()) {
            dimensions.add((Object)TargetingDimension.ABI);
        }
        if (targeting.hasGraphicsApi()) {
            dimensions.add((Object)TargetingDimension.GRAPHICS_API);
        }
        if (targeting.hasTextureCompressionFormat()) {
            dimensions.add((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT);
        }
        if (targeting.hasLanguage()) {
            dimensions.add((Object)TargetingDimension.LANGUAGE);
        }
        return dimensions.build();
    }

    public static ImmutableSet<Targeting.VariantTargeting> generateAllVariantTargetings(ImmutableSet<Targeting.VariantTargeting> variantTargetings) {
        if (variantTargetings.size() <= 1) {
            return variantTargetings;
        }
        ImmutableList<Targeting.SdkVersionTargeting> sdkVersionTargetings = TargetingUtils.disjointSdkTargetings((ImmutableList<Targeting.SdkVersionTargeting>)((ImmutableList)variantTargetings.stream().map(variantTargeting -> variantTargeting.getSdkVersionTargeting()).collect(ImmutableList.toImmutableList())));
        return (ImmutableSet)sdkVersionTargetings.stream().map(sdkVersionTargeting -> Targeting.VariantTargeting.newBuilder().setSdkVersionTargeting((Targeting.SdkVersionTargeting)sdkVersionTargeting).build()).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<Targeting.VariantTargeting> cropVariantsWithAppSdkRange(ImmutableSet<Targeting.VariantTargeting> variantTargetings, Range<Integer> sdkRange) {
        ImmutableList<Range<Integer>> ranges = TargetingUtils.calculateVariantSdkRanges(variantTargetings, sdkRange);
        return (ImmutableSet)ranges.stream().map(range -> TargetingUtils.sdkVariantTargeting((Integer)range.lowerEndpoint())).collect(ImmutableSet.toImmutableSet());
    }

    private static ImmutableList<Range<Integer>> calculateVariantSdkRanges(ImmutableSet<Targeting.VariantTargeting> variantTargetings, Range<Integer> appSdkRange) {
        return (ImmutableList)TargetingUtils.disjointSdkTargetings((ImmutableList<Targeting.SdkVersionTargeting>)((ImmutableList)variantTargetings.stream().map(variantTargeting -> variantTargeting.getSdkVersionTargeting()).collect(ImmutableList.toImmutableList()))).stream().map(sdkTargeting -> Range.closedOpen((Comparable)Integer.valueOf(TargetingUtils.getMinSdk(sdkTargeting)), (Comparable)Integer.valueOf(TargetingUtils.getMaxSdk(sdkTargeting)))).filter(arg_0 -> appSdkRange.isConnected(arg_0)).map(arg_0 -> appSdkRange.intersection(arg_0)).filter((Predicate<Range>)Predicates.not(Range::isEmpty)).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<Targeting.SdkVersionTargeting> disjointSdkTargetings(ImmutableList<Targeting.SdkVersionTargeting> sdkVersionTargetings) {
        sdkVersionTargetings.forEach(sdkVersionTargeting -> Preconditions.checkState((sdkVersionTargeting.getValueList().size() == 1 ? 1 : 0) != 0));
        ImmutableList minSdkValues = (ImmutableList)sdkVersionTargetings.stream().map(sdkVersionTargeting -> sdkVersionTargeting.getValue(0).getMin().getValue()).distinct().sorted().collect(ImmutableList.toImmutableList());
        ImmutableSet sdkVersions = (ImmutableSet)minSdkValues.stream().map(TargetingProtoUtils::sdkVersionFrom).collect(ImmutableSet.toImmutableSet());
        return (ImmutableList)sdkVersions.stream().map(sdkVersion -> TargetingProtoUtils.sdkVersionTargeting(sdkVersion, (ImmutableSet<Targeting.SdkVersion>)Sets.difference((Set)sdkVersions, (Set)ImmutableSet.of((Object)sdkVersion)).immutableCopy())).collect(ImmutableList.toImmutableList());
    }

    public static int getMinSdk(Targeting.SdkVersionTargeting sdkVersionTargeting) {
        if (sdkVersionTargeting.getValueList().isEmpty()) {
            return 1;
        }
        return ((Targeting.SdkVersion)Iterables.getOnlyElement(sdkVersionTargeting.getValueList())).getMin().getValue();
    }

    public static int getMaxSdk(Targeting.SdkVersionTargeting sdkVersionTargeting) {
        int minSdk = TargetingUtils.getMinSdk(sdkVersionTargeting);
        int alternativeMinSdk = sdkVersionTargeting.getAlternativesList().stream().mapToInt(alternativeSdk -> alternativeSdk.getMin().getValue()).filter(sdkValue -> minSdk < sdkValue).min().orElse(Integer.MAX_VALUE);
        return alternativeMinSdk;
    }

    private static Targeting.VariantTargeting sdkVariantTargeting(int minSdk) {
        return Targeting.VariantTargeting.newBuilder().setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(TargetingProtoUtils.sdkVersionFrom(minSdk))).build();
    }

    public static ModuleSplit removeAssetsTargeting(ModuleSplit moduleSplit, TargetingDimension dimension) {
        if (!moduleSplit.getAssetsConfig().isPresent()) {
            return moduleSplit;
        }
        Files.Assets assetsConfig = moduleSplit.getAssetsConfig().get();
        Files.Assets.Builder updatedAssetsConfig = assetsConfig.toBuilder().clearDirectory();
        ImmutableList updatedEntries = moduleSplit.getEntries();
        for (Files.TargetedAssetsDirectory targetedAssetsDirectory : assetsConfig.getDirectoryList()) {
            Files.TargetedAssetsDirectory updatedTargetedAssetsDirectory = TargetingUtils.removeAssetsTargetingFromDirectory(targetedAssetsDirectory, dimension);
            if (!updatedTargetedAssetsDirectory.equals(targetedAssetsDirectory)) {
                ZipPath directoryPath = ZipPath.create(targetedAssetsDirectory.getPath());
                updatedEntries = (ImmutableList)updatedEntries.stream().map(entry -> {
                    if (entry.getPath().startsWith(directoryPath)) {
                        return TargetingUtils.removeTargetingFromEntry(entry, dimension);
                    }
                    return entry;
                }).collect(ImmutableList.toImmutableList());
            }
            updatedAssetsConfig.addDirectory(updatedTargetedAssetsDirectory);
        }
        return moduleSplit.toBuilder().setEntries((List<ModuleEntry>)updatedEntries).setAssetsConfig(updatedAssetsConfig.build()).build();
    }

    public static ModuleSplit excludeAssetsTargetingOtherValue(ModuleSplit moduleSplit, TargetingDimension dimension, String value) {
        if (!moduleSplit.getAssetsConfig().isPresent()) {
            return moduleSplit;
        }
        Files.Assets assetsConfig = moduleSplit.getAssetsConfig().get();
        Files.Assets.Builder updatedAssetsConfig = assetsConfig.toBuilder().clearDirectory();
        ImmutableList updatedEntries = moduleSplit.getEntries();
        for (Files.TargetedAssetsDirectory targetedAssetsDirectory : assetsConfig.getDirectoryList()) {
            ZipPath directoryPath = ZipPath.create(targetedAssetsDirectory.getPath());
            if (TargetingUtils.isDirectoryTargetingOtherValue(targetedAssetsDirectory, dimension, value)) {
                updatedEntries = (ImmutableList)updatedEntries.stream().filter(entry -> !entry.getPath().startsWith(directoryPath)).collect(ImmutableList.toImmutableList());
                continue;
            }
            updatedAssetsConfig.addDirectory(targetedAssetsDirectory);
        }
        return moduleSplit.toBuilder().setEntries((List<ModuleEntry>)updatedEntries).setAssetsConfig(updatedAssetsConfig.build()).build();
    }

    private static Files.TargetedAssetsDirectory removeAssetsTargetingFromDirectory(Files.TargetedAssetsDirectory directory, TargetingDimension dimension) {
        Preconditions.checkArgument((boolean)dimension.equals((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT));
        if (!directory.getTargeting().hasTextureCompressionFormat()) {
            return directory;
        }
        TargetedDirectory targetedDirectory = TargetedDirectory.parse(ZipPath.create(directory.getPath()));
        TargetedDirectory newTargetedDirectory = targetedDirectory.removeTargeting(dimension);
        return directory.toBuilder().setPath(newTargetedDirectory.toZipPath().toString()).setTargeting(directory.getTargeting().toBuilder().clearTextureCompressionFormat().build()).build();
    }

    private static ModuleEntry removeTargetingFromEntry(ModuleEntry moduleEntry, TargetingDimension dimension) {
        if (!TargetedDirectorySegment.pathMayContain(moduleEntry.getPath().toString(), dimension)) {
            return moduleEntry;
        }
        TargetedDirectory targetedDirectory = TargetedDirectory.parse(moduleEntry.getPath());
        TargetedDirectory newTargetedDirectory = targetedDirectory.removeTargeting(dimension);
        if (!newTargetedDirectory.equals(targetedDirectory)) {
            return moduleEntry.setPath(newTargetedDirectory.toZipPath());
        }
        return moduleEntry;
    }

    private static boolean isDirectoryTargetingOtherValue(Files.TargetedAssetsDirectory directory, TargetingDimension dimension, String value) {
        Preconditions.checkArgument((boolean)dimension.equals((Object)TargetingDimension.TEXTURE_COMPRESSION_FORMAT));
        Targeting.AssetsDirectoryTargeting targeting = directory.getTargeting();
        if (!targeting.hasTextureCompressionFormat()) {
            return false;
        }
        if (targeting.getTextureCompressionFormat().getValueList().isEmpty()) {
            return !targeting.getTextureCompressionFormat().getAlternativesList().isEmpty();
        }
        String targetingValue = (String)TextureCompressionUtils.TARGETING_TO_TEXTURE.getOrDefault((Object)((Targeting.TextureCompressionFormat)Iterables.getOnlyElement(targeting.getTextureCompressionFormat().getValueList())).getAlias(), null);
        return !value.equals(targetingValue);
    }
}

