/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.proguard;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ProguardUsagesMap {
    private final Set<String> classes;
    private final Multimap<String, String> methodsByClass;
    private final Multimap<String, String> fieldsByClass;
    private static ImmutableSet<String> modifiers = ImmutableSet.of((Object)"abstract", (Object)"final", (Object)"native", (Object)"private", (Object)"protected", (Object)"public", (Object[])new String[]{"strictfp", "static", "synchronized", "transient", "volatile"});

    private ProguardUsagesMap(Set<String> classes, Multimap<String, String> methodsByClass, Multimap<String, String> fieldsByClass) {
        this.classes = ImmutableSet.copyOf(classes);
        this.methodsByClass = ImmutableMultimap.copyOf(methodsByClass);
        this.fieldsByClass = ImmutableMultimap.copyOf(fieldsByClass);
    }

    public Collection<String> getClasses() {
        return this.classes;
    }

    public Multimap<String, String> getMethodsByClass() {
        return this.methodsByClass;
    }

    public Multimap<String, String> getFieldsByClass() {
        return this.fieldsByClass;
    }

    public boolean hasClass(String fqcn) {
        return this.classes.contains(fqcn);
    }

    public boolean hasMethod(String fqcn, String methodSig) {
        return this.methodsByClass.containsEntry((Object)fqcn, (Object)methodSig);
    }

    public boolean hasField(String fqcn, String fieldName) {
        return this.fieldsByClass.containsEntry((Object)fqcn, (Object)fieldName);
    }

    public static ProguardUsagesMap parse(Path usageFile) throws IOException {
        return ProguardUsagesMap.parse(Files.newBufferedReader(usageFile, Charsets.UTF_8));
    }

    public static ProguardUsagesMap parse(Reader reader) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        ArrayListMultimap methods = ArrayListMultimap.create();
        ArrayListMultimap fields = ArrayListMultimap.create();
        try (BufferedReader br = new BufferedReader(reader);){
            String line;
            String currentClass = null;
            while ((line = br.readLine()) != null) {
                String trimmedLine = line.trim();
                if (line.isEmpty() || trimmedLine.charAt(0) == '#') continue;
                if (!Character.isWhitespace(line.charAt(0))) {
                    if (line.endsWith(":")) {
                        currentClass = line.substring(0, line.length() - 1);
                        continue;
                    }
                    classes.add(line);
                    currentClass = null;
                    continue;
                }
                line = trimmedLine;
                if (currentClass == null) {
                    String msg = "Unexpected format for proguard usages map. Encountered method or field with unknown class at line: " + line;
                    throw new IOException(msg);
                }
                if ((line = line.substring(line.lastIndexOf(58) + 1)).contains("(")) {
                    methods.put((Object)currentClass, (Object)ProguardUsagesMap.getMethodSpec(line));
                    continue;
                }
                fields.put((Object)currentClass, (Object)ProguardUsagesMap.getFieldName(line));
            }
        }
        return new ProguardUsagesMap(classes, (Multimap<String, String>)methods, (Multimap<String, String>)fields);
    }

    private static String getFieldName(String line) throws IOException {
        int i3 = line.lastIndexOf(32);
        int j3 = line.lastIndexOf(32, i3 - 1);
        int n3 = i3 = j3 >= 0 ? j3 : 0;
        if (i3 < 0 || i3 == line.length() - 1) {
            String message = "Unexpected field specification in proguard usages map: " + line;
            throw new IOException(message);
        }
        return line.substring(i3 + 1);
    }

    private static String getMethodSpec(String line) {
        return Arrays.stream(line.split(" ")).filter(s3 -> !modifiers.contains(s3)).collect(Collectors.joining(" ")).trim();
    }
}

