/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class SdkUtils {
    public static final String FILENAME_PREFIX = "From: ";
    public static final List<String> IMAGE_EXTENSIONS = ImmutableList.of((Object)".png", (Object)".9.png", (Object)".gif", (Object)".jpeg", (Object)".jpg", (Object)".bmp", (Object)".webp");

    public static boolean endsWithIgnoreCase(String string, String suffix) {
        return string.regionMatches(true, string.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean endsWith(CharSequence sequence, CharSequence suffix) {
        return SdkUtils.endsWith(sequence, sequence.length(), suffix);
    }

    public static boolean endsWith(CharSequence sequence, int endOffset, CharSequence suffix) {
        if (endOffset < suffix.length()) {
            return false;
        }
        int i3 = endOffset - 1;
        for (int j3 = suffix.length() - 1; j3 >= 0; --j3) {
            if (sequence.charAt(i3) != suffix.charAt(j3)) {
                return false;
            }
            --i3;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static String wrap(String text, int lineWidth, String hangingIndent) {
        return SdkUtils.wrap(text, lineWidth, lineWidth, hangingIndent);
    }

    public static String wrap(String text, int firstLineWidth, int nextLineWidth, String hangingIndent) {
        if (hangingIndent == null) {
            hangingIndent = "";
        }
        int lineWidth = firstLineWidth;
        int explanationLength = text.length();
        StringBuilder sb = new StringBuilder(explanationLength * 2);
        int index = 0;
        while (index < explanationLength) {
            int next;
            int lineEnd = text.indexOf(10, index);
            if (lineEnd != -1 && lineEnd - index < lineWidth) {
                next = lineEnd + 1;
            } else {
                lineEnd = Math.min(index + lineWidth, explanationLength);
                if (lineEnd - index < lineWidth) {
                    next = explanationLength;
                } else {
                    int lastSpace = text.lastIndexOf(32, lineEnd);
                    if (lastSpace > index) {
                        lineEnd = lastSpace;
                        next = lastSpace + 1;
                    } else {
                        next = lineEnd;
                    }
                }
            }
            if (sb.length() > 0) {
                sb.append(hangingIndent);
            } else {
                lineWidth = nextLineWidth - hangingIndent.length();
            }
            sb.append(text.substring(index, lineEnd));
            sb.append('\n');
            index = next;
        }
        return sb.toString();
    }

    public static File urlToFile(String url) throws MalformedURLException {
        return SdkUtils.urlToFile(new URL(url));
    }

    public static File urlToFile(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException e3) {
            MalformedURLException ex = new MalformedURLException(e3.getLocalizedMessage());
            ex.initCause(e3);
            throw ex;
        }
        catch (URISyntaxException e4) {
            return new File(url.getPath());
        }
    }

    public static String fileToUrlString(File file) throws MalformedURLException {
        String url = SdkUtils.fileToUrl(file).toExternalForm();
        if (!url.startsWith("file:///")) {
            url = url.replaceFirst("file:/", "file:///");
        }
        return url;
    }

    public static URL fileToUrl(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static String createPathComment(File file, boolean includePadding) throws MalformedURLException {
        String url = SdkUtils.fileToUrlString(file);
        int dashes = url.indexOf("--");
        if (dashes != -1) {
            url = url.replace("--", "%2D%2D");
        }
        if (includePadding) {
            return " From: " + url + ' ';
        }
        return FILENAME_PREFIX + url;
    }

    public static String xmlNameToConstantName(String xmlName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, xmlName);
    }

    public static String camelCaseToConstantName(String camelCaseName) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelCaseName);
    }

    public static String constantNameToCamelCase(String constantName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, constantName);
    }

    public static String constantNameToXmlName(String constantName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, constantName);
    }

    public static String getResourceFieldName(String resourceName) {
        int n3 = resourceName.length();
        for (int i3 = 0; i3 < n3; ++i3) {
            char c3 = resourceName.charAt(i3);
            if (c3 != '.' && c3 != ':' && c3 != '-') continue;
            return resourceName.replace('.', '_').replace('-', '_').replace(':', '_');
        }
        return resourceName;
    }

    public static String fileNameToResourceName(String fileName) {
        int extension = fileName.indexOf(46);
        if (extension > 0) {
            return fileName.substring(0, extension);
        }
        return fileName;
    }

    public static boolean hasImageExtension(String path) {
        for (String ext : IMAGE_EXTENSIONS) {
            if (!SdkUtils.endsWithIgnoreCase(path, ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBitmapFile(File file) {
        return SdkUtils.hasImageExtension(file.getPath());
    }

    public static String escapePropertyValue(String value) {
        Properties properties = new Properties();
        properties.setProperty("k", value);
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
            String s3 = writer.toString();
            int end = s3.length();
            String lineSeparator = System.lineSeparator();
            if (s3.endsWith(lineSeparator)) {
                end -= lineSeparator.length();
            }
            int start = s3.indexOf(61);
            assert (start != -1) : s3;
            return s3.substring(start + 1, end);
        }
        catch (IOException e3) {
            return value;
        }
    }

    public static String globToRegexp(String glob) {
        StringBuilder sb = new StringBuilder(glob.length() * 2);
        int begin = 0;
        sb.append('^');
        int n3 = glob.length();
        for (int i3 = 0; i3 < n3; ++i3) {
            char c3 = glob.charAt(i3);
            if (c3 == '*') {
                begin = SdkUtils.appendQuoted(sb, glob, begin, i3) + 1;
                if (i3 < n3 - 1 && glob.charAt(i3 + 1) == '*') {
                    ++i3;
                    ++begin;
                }
                sb.append(".*?");
                continue;
            }
            if (c3 != '?') continue;
            begin = SdkUtils.appendQuoted(sb, glob, begin, i3) + 1;
            sb.append(".?");
        }
        SdkUtils.appendQuoted(sb, glob, begin, glob.length());
        sb.append('$');
        return sb.toString();
    }

    private static int appendQuoted(StringBuilder sb, String s3, int from, int to) {
        if (to > from) {
            int i3;
            boolean isSimple = true;
            for (i3 = from; i3 < to; ++i3) {
                char c3 = s3.charAt(i3);
                if (Character.isLetterOrDigit(c3) || c3 == '/' || c3 == ' ') continue;
                isSimple = false;
                break;
            }
            if (isSimple) {
                for (i3 = from; i3 < to; ++i3) {
                    sb.append(s3.charAt(i3));
                }
                return to;
            }
            sb.append(Pattern.quote(s3.substring(from, to)));
        }
        return to;
    }

    public static boolean isServiceKey(String name) {
        switch (name) {
            case "gcm_defaultSenderId": 
            case "google_app_id": 
            case "google_api_key": 
            case "google_storage_bucket": 
            case "ga_trackingID": 
            case "default_web_client_id": 
            case "firebase_database_url": 
            case "google_crash_reporting_api_key": {
                return true;
            }
        }
        return false;
    }
}

