/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AutoValue_InstallApksCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.tools.build.bundletool.device.AdbRunner;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.flags.Flag;
import com.android.tools.build.bundletool.flags.ParsedFlags;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.DefaultSystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.ResultUtils;
import com.android.tools.build.bundletool.model.utils.SdkToolsLocator;
import com.android.tools.build.bundletool.model.utils.SystemEnvironmentProvider;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;

@AutoValue
public abstract class InstallApksCommand {
    public static final String COMMAND_NAME = "install-apks";
    private static final Flag<Path> ADB_PATH_FLAG = Flag.path("adb");
    private static final Flag<Path> APKS_ARCHIVE_FILE_FLAG = Flag.path("apks");
    private static final Flag<String> DEVICE_ID_FLAG = Flag.string("device-id");
    private static final Flag<ImmutableSet<String>> MODULES_FLAG = Flag.stringSet("modules");
    private static final Flag<Boolean> ALLOW_DOWNGRADE_FLAG = Flag.booleanFlag("allow-downgrade");
    private static final Flag<String> PUSH_SPLITS_FLAG = Flag.string("push-splits-to");
    private static final Flag<Boolean> CLEAR_PUSH_PATH_FLAG = Flag.booleanFlag("clear-push-path");
    private static final Flag<Boolean> ALLOW_TEST_ONLY_FLAG = Flag.booleanFlag("allow-test-only");
    private static final String ANDROID_SERIAL_VARIABLE = "ANDROID_SERIAL";
    private static final SystemEnvironmentProvider DEFAULT_PROVIDER = new DefaultSystemEnvironmentProvider();

    public abstract Path getAdbPath();

    public abstract Path getApksArchivePath();

    public abstract Optional<String> getDeviceId();

    public abstract Optional<ImmutableSet<String>> getModules();

    public abstract boolean getAllowDowngrade();

    public abstract Optional<String> getPushSplitsPath();

    public abstract boolean getClearPushPath();

    public abstract boolean getAllowTestOnly();

    abstract AdbServer getAdbServer();

    public static Builder builder() {
        return new AutoValue_InstallApksCommand.Builder().setAllowDowngrade(false).setClearPushPath(false).setAllowTestOnly(false);
    }

    public static InstallApksCommand fromFlags(ParsedFlags flags, AdbServer adbServer) {
        return InstallApksCommand.fromFlags(flags, DEFAULT_PROVIDER, adbServer);
    }

    public static InstallApksCommand fromFlags(ParsedFlags flags, SystemEnvironmentProvider systemEnvironmentProvider, AdbServer adbServer) {
        Path apksArchivePath = APKS_ARCHIVE_FILE_FLAG.getRequiredValue(flags);
        Path adbPath = ADB_PATH_FLAG.getValue(flags).orElseGet(() -> new SdkToolsLocator().locateAdb(systemEnvironmentProvider).orElseThrow(() -> new CommandExecutionException("Unable to determine the location of ADB. Please set the --adb flag or define ANDROID_HOME or PATH environment variable.")));
        Optional<String> deviceSerialName = DEVICE_ID_FLAG.getValue(flags);
        if (!deviceSerialName.isPresent()) {
            deviceSerialName = systemEnvironmentProvider.getVariable(ANDROID_SERIAL_VARIABLE);
        }
        Optional<ImmutableSet<String>> modules = MODULES_FLAG.getValue(flags);
        Optional<Boolean> allowDowngrade = ALLOW_DOWNGRADE_FLAG.getValue(flags);
        Optional<String> pushSplits = PUSH_SPLITS_FLAG.getValue(flags);
        Optional<Boolean> clearPushPath = CLEAR_PUSH_PATH_FLAG.getValue(flags);
        Optional<Boolean> allowTestOnly = ALLOW_TEST_ONLY_FLAG.getValue(flags);
        flags.checkNoUnknownFlags();
        Builder command = InstallApksCommand.builder().setAdbPath(adbPath).setAdbServer(adbServer).setApksArchivePath(apksArchivePath);
        deviceSerialName.ifPresent(command::setDeviceId);
        modules.ifPresent(command::setModules);
        allowDowngrade.ifPresent(command::setAllowDowngrade);
        allowTestOnly.ifPresent(command::setAllowTestOnly);
        return command.build();
    }

    public void execute() {
        this.validateInput();
        AdbServer adbServer = this.getAdbServer();
        adbServer.init(this.getAdbPath());
        try (TempDirectory tempDirectory = new TempDirectory();){
            Devices.DeviceSpec deviceSpec = new DeviceAnalyzer(adbServer).getDeviceSpec(this.getDeviceId());
            ExtractApksCommand.Builder extractApksCommand = ExtractApksCommand.builder().setApksArchivePath(this.getApksArchivePath()).setDeviceSpec(deviceSpec);
            if (!Files.isDirectory(this.getApksArchivePath(), new LinkOption[0])) {
                extractApksCommand.setOutputDirectory(tempDirectory.getPath());
            }
            this.getModules().ifPresent(extractApksCommand::setModules);
            ImmutableList<Path> extractedApks = extractApksCommand.build().execute();
            AdbRunner adbRunner = new AdbRunner(adbServer);
            Device.InstallOptions installOptions = Device.InstallOptions.builder().setAllowDowngrade(this.getAllowDowngrade()).setAllowTestOnly(this.getAllowTestOnly()).build();
            if (this.getDeviceId().isPresent()) {
                adbRunner.run(device -> device.installApks(extractedApks, installOptions), this.getDeviceId().get());
            } else {
                adbRunner.run(device -> device.installApks(extractedApks, installOptions));
            }
            this.pushSplits(deviceSpec, extractApksCommand.build(), adbRunner);
        }
    }

    private void pushSplits(Devices.DeviceSpec baseSpec, ExtractApksCommand baseExtractCommand, AdbRunner adbRunner) {
        if (!this.getPushSplitsPath().isPresent()) {
            return;
        }
        ExtractApksCommand.Builder extractApksCommand = ExtractApksCommand.builder();
        extractApksCommand.setApksArchivePath(baseExtractCommand.getApksArchivePath());
        baseExtractCommand.getOutputDirectory().ifPresent(extractApksCommand::setOutputDirectory);
        extractApksCommand.setModules((ImmutableSet<String>)ImmutableSet.of((Object)"_ALL_"));
        Commands.BuildApksResult toc = ResultUtils.readTableOfContents(this.getApksArchivePath());
        ImmutableSet<String> targetedLanguages = ResultUtils.getAllTargetedLanguages(toc);
        ImmutableList<Path> extractedApksForPush = extractApksCommand.setDeviceSpec(baseSpec.toBuilder().addAllSupportedLocales((Iterable<String>)targetedLanguages).build()).build().execute();
        Device.PushOptions.Builder pushOptions = Device.PushOptions.builder().setDestinationPath(this.getPushSplitsPath().get()).setClearDestinationPath(this.getClearPushPath());
        if (!this.getPushSplitsPath().get().startsWith("/")) {
            String packageName = toc.getPackageName();
            if (packageName.isEmpty()) {
                throw new CommandExecutionException("Unable to determine the package name of the base APK. If your APK set was produced using an older version of bundletool, please regenerate it. Alternatively, you can try again with an absolute path for --push-splits-to, pointing to a location that is writeable by the shell user, e.g. /sdcard/...");
            }
            pushOptions.setPackageName(packageName);
        }
        if (this.getDeviceId().isPresent()) {
            adbRunner.run(device -> device.pushApks(extractedApksForPush, pushOptions.build()), this.getDeviceId().get());
        } else {
            adbRunner.run(device -> device.pushApks(extractedApksForPush, pushOptions.build()));
        }
    }

    private void validateInput() {
        if (Files.isDirectory(this.getApksArchivePath(), new LinkOption[0])) {
            FilePreconditions.checkDirectoryExists(this.getApksArchivePath());
        } else {
            FilePreconditions.checkFileExistsAndReadable(this.getApksArchivePath());
        }
        FilePreconditions.checkFileExistsAndExecutable(this.getAdbPath());
        if (this.getClearPushPath()) {
            Preconditions.checkArgument((boolean)this.getPushSplitsPath().isPresent(), (String)"--%s only applies when --%s is set.", (Object)CLEAR_PUSH_PATH_FLAG.getName(), (Object)PUSH_SPLITS_FLAG.getName());
        }
        this.getPushSplitsPath().ifPresent(path -> Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (String)"The value of the flag --%s cannot be empty.", (Object)PUSH_SPLITS_FLAG.getName()));
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Installs APKs extracted from an APK Set to a connected device. Replaces already installed package.").addAdditionalParagraph("This will extract from the APK Set archive and install only the APKs that would be served to that device. If the app is not compatible with the device or if the APK Set archive was generated for a different type of device, this command will fail.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADB_PATH_FLAG.getName()).setExampleValue("path/to/adb").setOptional(true).setDescription("Path to the adb utility. If absent, an attempt will be made to locate it if the %s or %s environment variable is set.", "ANDROID_HOME", "PATH").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APKS_ARCHIVE_FILE_FLAG.getName()).setExampleValue("archive.apks").setDescription("Path to the archive file generated by the '%s' command.", "build-apks").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_ID_FLAG.getName()).setExampleValue("device-serial-name").setOptional(true).setDescription("Device serial name. If absent, this uses the %s environment variable. Either this flag or the environment variable is required when more than one device or emulator is connected.", ANDROID_SERIAL_VARIABLE).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ALLOW_DOWNGRADE_FLAG.getName()).setOptional(true).setDescription("If set, allows APKs to be installed on the device even if the app is already installed with a lower version code.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MODULES_FLAG.getName()).setExampleValue("base,module1,module2").setOptional(true).setDescription("List of modules to be installed, or \"%s\" for all modules. Defaults to modules installed during the first install, i.e. not on-demand. Note that the dependent modules will also be extracted. The value of this flag is ignored if the device receives a standalone APK.", "_ALL_").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ALLOW_TEST_ONLY_FLAG.getName()).setOptional(true).setDescription("If set, apps with 'android:testOnly=true' set in their manifest can also be deployed").build()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setAdbPath(Path var1);

        public abstract Builder setApksArchivePath(Path var1);

        public abstract Builder setDeviceId(String var1);

        public abstract Builder setModules(ImmutableSet<String> var1);

        public abstract Builder setAllowDowngrade(boolean var1);

        public abstract Builder setAdbServer(AdbServer var1);

        public abstract Builder setPushSplitsPath(String var1);

        public abstract Builder setClearPushPath(boolean var1);

        public abstract Builder setAllowTestOnly(boolean var1);

        public abstract InstallApksCommand build();
    }
}

